/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Version;

public class VersionFilter {
    private final Set<ReleaseType> types = new HashSet<ReleaseType>(ReleaseType.valuesCollection());
    private final Set<ReleaseType.SubType> subTypes = new HashSet<ReleaseType.SubType>(ReleaseType.SubType.valuesCollection());

    public Set<ReleaseType> getTypes() {
        return this.types;
    }

    public Set<ReleaseType.SubType> getSubTypes() {
        return this.subTypes;
    }

    public VersionFilter onlyForType(ReleaseType ... types) {
        this.types.clear();
        this.include(types);
        return this;
    }

    public VersionFilter onlyForType(ReleaseType.SubType ... subTypes) {
        this.subTypes.clear();
        this.include(subTypes);
        return this;
    }

    public VersionFilter include(ReleaseType ... types) {
        if (types != null) {
            Collections.addAll(this.types, types);
        }
        return this;
    }

    public VersionFilter include(ReleaseType.SubType ... types) {
        if (types != null) {
            Collections.addAll(this.subTypes, types);
        }
        return this;
    }

    public VersionFilter exclude(ReleaseType ... types) {
        if (types != null) {
            ReleaseType[] arr$ = types;
            int len$ = types.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ReleaseType type = arr$[i$];
                this.types.remove((Object)type);
            }
        }
        return this;
    }

    public VersionFilter exclude(ReleaseType.SubType ... types) {
        if (types != null) {
            ReleaseType.SubType[] arr$ = types;
            int len$ = types.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ReleaseType.SubType type = arr$[i$];
                this.subTypes.remove((Object)type);
            }
        }
        return this;
    }

    public boolean satisfies(Version v) {
        ReleaseType releaseType = v.getReleaseType();
        if (releaseType == null) {
            return true;
        }
        if (!this.types.contains((Object)releaseType)) {
            return false;
        }
        ReleaseType.SubType subType = ReleaseType.SubType.get(v);
        return subType == null ? true : this.subTypes.contains((Object)subType);
    }

    public String toString() {
        return "VersionFilter" + this.types;
    }
}

