/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.Version;
import net.minecraft.launcher.versions.json.PatternTypeAdapter;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.component.InterruptibleComponent;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.managers.ComponentManager;
import ru.turikhay.tlauncher.managers.ElyManagerListener;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.util.OS;
import ru.turikhay.util.U;

public class ElyManager
extends InterruptibleComponent {
    private static final double VERSION = 1.0;
    private final Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Pattern.class), new PatternTypeAdapter()).create();
    private List<ElyLib> authlib = ElyManager.nl();
    private List<ElyLib> asm = ElyManager.nl();
    private List<ElyLib> total = ElyManager.nl();
    private final List<ElyManagerListener> listeners = Collections.synchronizedList(new ArrayList());
    private boolean refreshAllowed;

    public ElyManager(ComponentManager manager) throws Exception {
        super(manager);
    }

    public boolean hasLibraries(VersionSyncInfo version) {
        return version.isInstalled() && this.hasLibraries(version.getLocal()) || version.hasRemote() && this.hasLibraries(version.getRemote());
    }

    public boolean hasLibraries(Version version) {
        if (this.hasLibraries(version.getID())) {
            return true;
        }
        if (!(version instanceof CompleteVersion)) {
            return false;
        }
        CompleteVersion complete = (CompleteVersion)version;
        for (Library library : complete.getLibraries()) {
            for (ElyLib elyLib : this.total) {
                if (!elyLib.replaces(library)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasLibraries(String version) {
        ElyLib library;
        Iterator<ElyLib> i$ = this.total.iterator();
        do {
            if (i$.hasNext()) continue;
            return false;
        } while (!(library = i$.next()).getSupportedList().contains(version));
        return true;
    }

    public List<ElyLib> getLibraries(CompleteVersion complete) {
        String id = complete.getID();
        ArrayList<ElyLib> libList = new ArrayList<ElyLib>();
        for (ElyLib elyLib : this.total) {
            if (elyLib.supports(id)) {
                libList.add(elyLib);
                continue;
            }
            for (Library library : complete.getLibraries()) {
                if (!elyLib.replaces(library)) continue;
                libList.add(elyLib);
            }
        }
        return libList;
    }

    public CompleteVersion elyficate(CompleteVersion original) {
        this.log("Trying to elyficate version:", original.getID());
        List<ElyLib> libList = this.getLibraries(original);
        CompleteVersion complete = original.copyInto(new CompleteVersion());
        for (ElyLib lib : libList) {
            this.log("Processing Ely library:", lib.getName());
            if (lib.getPattern() != null) {
                Pattern add = lib.getPattern();
                Iterator<Library> i$1 = complete.getLibraries().iterator();
                while (i$1.hasNext()) {
                    Library current = i$1.next();
                    if (!add.matcher(current.getName()).matches()) continue;
                    this.log("Remove", current.getName());
                    i$1.remove();
                }
            }
            if (StringUtils.isNotBlank(lib.getArgs())) {
                String add1 = complete.getMinecraftArguments();
                add1 = StringUtils.isBlank(add1) ? lib.getArgs() : add1 + ' ' + lib.getArgs();
                complete.setMinecraftArguments(add1);
            }
            if (StringUtils.isNotBlank(lib.getMainClass())) {
                complete.setMainClass(lib.getMainClass());
            }
            if (lib.getRequirementList() != null) {
                ArrayList<Library> add2 = new ArrayList<Library>(lib.getRequirementList());
                for (Library current : add2) {
                    Iterator<Library> it = complete.getLibraries().iterator();
                    while (it.hasNext()) {
                        Library compare = it.next();
                        if (!current.getPlainName().equals(compare.getPlainName())) continue;
                        this.log("Version library list already contains:", compare.getName());
                        it.remove();
                    }
                }
                complete.getLibraries().addAll(add2);
            }
            complete.getLibraries().add(lib);
        }
        return complete;
    }

    @Override
    public boolean refreshComponent() {
        return true;
    }

    @Override
    protected boolean refresh(int refreshID) {
        if (!this.refreshAllowed) {
            this.log("Refresh is not allowed.");
            this.clearAll();
            return false;
        }
        this.log("Refreshing Ely...");
        try {
            this.refreshDirectly();
        }
        catch (Exception var3) {
            this.log("Failed to refresh Ely", var3);
            return false;
        }
        this.log("Refreshed successfully!");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDirectly() throws Exception {
        String content = Repository.EXTRA_VERSION_REPO.getUrl("libraries/by/ely/libraries.json");
        RawResponse response = this.gson.fromJson(content, RawResponse.class);
        if (response.version != 1.0) {
            throw new RuntimeException("incompatible ely summary info version. required: " + response.version + "; have: " + 1.0);
        }
        if (response.authlib == null) {
            throw new NullPointerException("no authlib");
        }
        if (response.asm == null) {
            throw new NullPointerException("no asm");
        }
        List<ElyLib> i$ = this.total;
        List<ElyLib> list = this.total;
        synchronized (list) {
            List<ElyLib> listener = this.authlib;
            List<ElyLib> list2 = this.authlib;
            synchronized (list2) {
                this.authlib.clear();
                this.authlib.addAll(response.authlib);
            }
            listener = this.asm;
            list2 = this.asm;
            synchronized (list2) {
                this.asm.clear();
                this.asm.addAll(response.asm);
            }
            this.total.clear();
            this.total.addAll(this.authlib);
            this.total.addAll(this.asm);
        }
        for (ElyManagerListener listener1 : this.listeners) {
            listener1.onElyUpdated(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAll() {
        List<ElyLib> var1 = this.total;
        List<ElyLib> list = this.total;
        synchronized (list) {
            this.authlib.clear();
            this.asm.clear();
            this.total.clear();
        }
    }

    public void addListener(ElyManagerListener listener) {
        this.listeners.add(listener);
    }

    private static List<ElyLib> nl() {
        return Collections.synchronizedList(new ArrayList());
    }

    public boolean getRefreshAllowed() {
        return this.refreshAllowed;
    }

    public void setRefreshAllowed(boolean allowed) {
        this.log("Refresh allowed:", allowed);
        this.refreshAllowed = true;
    }

    private static class RawResponse {
        private double version;
        private List<ElyLib> authlib;
        private List<ElyLib> asm;

        private RawResponse() {
        }
    }

    public static class ElyLib
    extends Library {
        private Pattern replaces;
        private String args;
        private String mainClass;
        private List<Library> requires = new ArrayList<Library>();
        private List<String> supports = new ArrayList<String>();

        public ElyLib() {
            this.url = "/libraries/";
        }

        public Pattern getPattern() {
            return this.replaces;
        }

        public boolean replaces(Library lib) {
            return this.replaces != null && this.replaces.matcher(lib.getName()).matches();
        }

        public String getArgs() {
            return this.args;
        }

        public String getMainClass() {
            return this.mainClass;
        }

        public List<Library> getRequirementList() {
            return this.requires;
        }

        public List<String> getSupportedList() {
            return this.supports;
        }

        public boolean supports(String version) {
            return this.supports != null && this.supports.contains(version);
        }

        @Override
        public Downloadable getDownloadable(Repository versionSource, File file, OS os) {
            U.log(new Object[]{"getting downloadable", this.getName(), versionSource, file, os});
            return super.getDownloadable(Repository.EXTRA_VERSION_REPO, file, os);
        }

        @Override
        public String toString() {
            return "ElyLib{name='" + this.name + '\'' + ", replaces='" + this.replaces + "', args='" + this.args + "', requires=" + this.requires + ", supports=" + this.supports + "}";
        }
    }
}

