/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launcher.updater.LatestVersionSyncInfo;
import net.minecraft.launcher.updater.LocalVersionList;
import net.minecraft.launcher.updater.RemoteVersionList;
import net.minecraft.launcher.updater.VersionFilter;
import net.minecraft.launcher.updater.VersionList;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Version;
import ru.turikhay.tlauncher.component.ComponentDependence;
import ru.turikhay.tlauncher.component.InterruptibleComponent;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.managers.AssetsManager;
import ru.turikhay.tlauncher.managers.ComponentManager;
import ru.turikhay.tlauncher.managers.ElyManager;
import ru.turikhay.tlauncher.managers.VersionLists;
import ru.turikhay.tlauncher.managers.VersionManagerListener;
import ru.turikhay.tlauncher.managers.VersionSyncInfoContainer;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.Time;
import ru.turikhay.util.U;
import ru.turikhay.util.async.AsyncObject;
import ru.turikhay.util.async.AsyncObjectContainer;
import ru.turikhay.util.async.AsyncObjectGotErrorException;
import ru.turikhay.util.async.AsyncThread;

@ComponentDependence(value={AssetsManager.class, VersionLists.class, ElyManager.class})
public class VersionManager
extends InterruptibleComponent {
    private final LocalVersionList localList;
    private final RemoteVersionList[] remoteLists;
    private Map<ReleaseType, Version> latestVersions;
    private final List<VersionManagerListener> listeners;
    private final Object versionFlushLock;
    private boolean hadRemote;
    private static final Set<Version> NOT_RESOLVED_SET = new HashSet<Version>();

    public VersionManager(ComponentManager manager) throws Exception {
        super(manager);
        VersionLists list = manager.getComponent(VersionLists.class);
        this.localList = list.getLocal();
        this.remoteLists = list.getRemoteLists();
        this.latestVersions = new LinkedHashMap<ReleaseType, Version>();
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.versionFlushLock = new Object();
    }

    public void addListener(VersionManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalVersionList getLocalList() {
        this.logSearchError("getLocalList");
        Object var1 = this.versionFlushLock;
        Object object = this.versionFlushLock;
        synchronized (object) {
            return this.localList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ReleaseType, Version> getLatestVersions() {
        Object var1 = this.versionFlushLock;
        Object object = this.versionFlushLock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.latestVersions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean refresh(int refreshID, boolean local) {
        this.refreshList[refreshID] = true;
        this.hadRemote |= !(local |= !this.manager.getLauncher().getSettings().getBoolean("minecraft.versions.sub.remote"));
        if (local) {
            this.log("Refreshing versions locally...");
        } else {
            this.log("Refreshing versions remotely...");
            this.latestVersions.clear();
            List<VersionManagerListener> lock = this.listeners;
            List<VersionManagerListener> list = this.listeners;
            synchronized (list) {
                for (VersionManagerListener e : this.listeners) {
                    e.onVersionsRefreshing(this);
                }
            }
        }
        Object lock1 = new Object();
        Time.start(lock1);
        Map<AsyncObject<VersionList.RawVersionList>, VersionList.RawVersionList> result1 = null;
        Throwable e1 = null;
        try {
            result1 = this.refreshVersions(local);
        }
        catch (Throwable var14) {
            e1 = var14;
        }
        if (this.isCancelled(refreshID)) {
            this.log("Version refresh has been cancelled (" + Time.stop(lock1) + " ms)");
            return false;
        }
        if (e1 != null) {
            List<VersionManagerListener> e01 = this.listeners;
            List<VersionManagerListener> list = this.listeners;
            synchronized (list) {
                for (VersionManagerListener listener1 : this.listeners) {
                    listener1.onVersionsRefreshingFailed(this);
                }
            }
            this.log("Cannot refresh versions (" + Time.stop(lock1) + " ms)", e1);
            return true;
        }
        if (result1 != null) {
            Object e0 = this.versionFlushLock;
            Object object = this.versionFlushLock;
            synchronized (object) {
                for (AsyncObject asyncObject : result1.keySet()) {
                    VersionList.RawVersionList rawList = result1.get(asyncObject);
                    if (rawList == null) continue;
                    AsyncRawVersionListObject listObject = (AsyncRawVersionListObject)asyncObject;
                    RemoteVersionList versionList = listObject.getVersionList();
                    versionList.refreshVersions(rawList);
                    this.latestVersions.putAll(versionList.getLatestVersions());
                }
            }
        }
        this.latestVersions = U.sortMap(this.latestVersions, ReleaseType.values());
        this.log("Versions has been refreshed (" + Time.stop(lock1) + " ms)");
        this.refreshList[refreshID] = false;
        List<VersionManagerListener> e01 = this.listeners;
        List<VersionManagerListener> list = this.listeners;
        synchronized (list) {
            for (VersionManagerListener listener1 : this.listeners) {
                listener1.onVersionsRefreshed(this);
            }
            return true;
        }
    }

    @Override
    protected boolean refresh(int queueID) {
        return this.refresh(queueID, false);
    }

    public void startRefresh(boolean local) {
        this.refresh(this.nextID(), local);
    }

    @Override
    public synchronized void stopRefresh() {
        super.stopRefresh();
        this.startRefresh(true);
    }

    public void asyncRefresh(final boolean local) {
        AsyncThread.execute(new Runnable(){

            @Override
            public void run() {
                VersionManager.this.startRefresh(local);
            }
        });
    }

    @Override
    public void asyncRefresh() {
        this.asyncRefresh(false);
    }

    private Map<AsyncObject<VersionList.RawVersionList>, VersionList.RawVersionList> refreshVersions(boolean local) throws IOException {
        this.logSearchError("refreshVersions");
        this.localList.refreshVersions();
        if (local) {
            return null;
        }
        AsyncObjectContainer<VersionList.RawVersionList> container = new AsyncObjectContainer<VersionList.RawVersionList>();
        for (RemoteVersionList remoteList : this.remoteLists) {
            container.add(new AsyncRawVersionListObject(remoteList));
        }
        return container.execute();
    }

    public void updateVersionList() {
        if (!this.hadRemote) {
            this.asyncRefresh();
        } else {
            for (VersionManagerListener listener : this.listeners) {
                listener.onVersionsRefreshed(this);
            }
        }
    }

    public VersionSyncInfo getVersionSyncInfo(Version version) {
        return this.getVersionSyncInfo(version.getID());
    }

    public VersionSyncInfo getVersionSyncInfo(String name) {
        Version var10;
        if (name == null) {
            throw new NullPointerException("Cannot get sync info of NULL!");
        }
        if (name.startsWith("latest-")) {
            String localVersion = name.substring(7);
            name = null;
            for (Map.Entry<ReleaseType, Version> arr$ : this.latestVersions.entrySet()) {
                if (!arr$.getKey().toString().equals(localVersion)) continue;
                name = arr$.getValue().getID();
                break;
            }
            if (name == null) {
                return null;
            }
        }
        if ((var10 = this.localList.getVersion(name)) instanceof CompleteVersion && ((CompleteVersion)var10).getInheritsFrom() != null) {
            try {
                var10 = ((CompleteVersion)var10).resolve(this, false);
            }
            catch (IOException var9) {
                throw new RuntimeException("Can't resolve version " + var10, var9);
            }
        }
        Version var11 = null;
        for (RemoteVersionList list : this.remoteLists) {
            Version currentVersion = list.getVersion(name);
            if (currentVersion == null) continue;
            var11 = currentVersion;
            break;
        }
        return var10 == null && var11 == null ? null : new VersionSyncInfo(var10, var11);
    }

    public LatestVersionSyncInfo getLatestVersionSyncInfo(Version version) {
        if (version == null) {
            throw new NullPointerException("Cannot get latest sync info of NULL!");
        }
        VersionSyncInfo syncInfo = this.getVersionSyncInfo(version);
        return new LatestVersionSyncInfo(version.getReleaseType(), syncInfo);
    }

    public List<VersionSyncInfo> getVersions(VersionFilter filter, boolean includeLatest) {
        return this.getVersions0(filter, includeLatest);
    }

    public List<VersionSyncInfo> getVersions(boolean includeLatest) {
        return this.getVersions(TLauncher.getInstance() == null ? null : TLauncher.getInstance().getSettings().getVersionFilter(), includeLatest);
    }

    public synchronized List<VersionSyncInfo> getVersions() {
        return this.getVersions(true);
    }

    private synchronized List<VersionSyncInfo> getVersions0(VersionFilter filter, boolean includeLatest) {
        this.logSearchError("getVersions0");
        if (filter == null) {
            filter = new VersionFilter();
        }
        ArrayList<VersionSyncInfo> plainResult = new ArrayList<VersionSyncInfo>();
        ArrayList<VersionSyncInfo> result = new ArrayList<VersionSyncInfo>();
        HashMap<String, VersionSyncInfo> lookup = new HashMap<String, VersionSyncInfo>();
        if (includeLatest) {
            for (Version arr$ : this.latestVersions.values()) {
                LatestVersionSyncInfo len$;
                if (!filter.satisfies(arr$) || result.contains(len$ = this.getLatestVersionSyncInfo(arr$))) continue;
                result.add(len$);
            }
        }
        List<Version> var14 = this.localList.getVersions();
        for (int var15 = 0; var15 < var14.size(); ++var15) {
            if (!filter.satisfies(var14.get(var15))) continue;
            VersionSyncInfo var17 = this.getVersionSyncInfo(var14.get(var15));
            if (var17 == null) {
                if (NOT_RESOLVED_SET.contains(var14.get(var15))) continue;
                Alert.showWarning(Localizable.get("version.manager.resolve.title"), Localizable.get("version.manager.resolve.message"));
                NOT_RESOLVED_SET.add(var14.get(var15));
                continue;
            }
            lookup.put(var14.get(var15).getID(), var17);
            plainResult.add(var17);
        }
        for (RemoteVersionList remoteList : this.remoteLists) {
            for (Version version : remoteList.getVersions()) {
                if (lookup.containsKey(version.getID()) || !filter.satisfies(version)) continue;
                VersionSyncInfo syncInfo = this.getVersionSyncInfo(version);
                lookup.put(version.getID(), syncInfo);
                plainResult.add(syncInfo);
            }
        }
        Collections.sort(plainResult, new Comparator(){

            public int compare(VersionSyncInfo a, VersionSyncInfo b) {
                Date aDate = a.getLatestVersion().getReleaseTime();
                Date bDate = b.getLatestVersion().getReleaseTime();
                return aDate != null && bDate != null ? bDate.compareTo(aDate) : 1;
            }

            public int compare(Object x0, Object x1) {
                return this.compare((VersionSyncInfo)x0, (VersionSyncInfo)x1);
            }
        });
        result.addAll(plainResult);
        return result;
    }

    public List<VersionSyncInfo> getInstalledVersions(VersionFilter filter) {
        this.logSearchError("getInstalledVersions");
        if (filter == null) {
            new VersionFilter();
        }
        ArrayList<VersionSyncInfo> result = new ArrayList<VersionSyncInfo>();
        for (Version version : this.localList.getVersions()) {
            result.add(this.getVersionSyncInfo(version));
        }
        return result;
    }

    public List<VersionSyncInfo> getInstalledVersions() {
        return this.getInstalledVersions(TLauncher.getInstance() == null ? null : TLauncher.getInstance().getSettings().getVersionFilter());
    }

    public VersionSyncInfoContainer downloadVersion(VersionSyncInfo syncInfo, boolean ely, boolean force) throws IOException {
        Repository repo;
        this.logSearchError("downloadVersion");
        VersionSyncInfoContainer container = new VersionSyncInfoContainer(syncInfo);
        CompleteVersion completeVersion = syncInfo.getCompleteVersion(force);
        if (ely) {
            CompleteVersion baseDirectory = this.manager.getComponent(ElyManager.class).elyficate(completeVersion);
            if (syncInfo.getLocal() == completeVersion) {
                syncInfo.setLocal(baseDirectory);
            } else {
                syncInfo.setRemote(baseDirectory);
            }
            completeVersion = baseDirectory;
        }
        File baseDirectory1 = this.localList.getBaseDirectory();
        Set<Downloadable> required = syncInfo.getRequiredDownloadables(baseDirectory1, force, ely);
        container.addAll(required);
        this.log("Required for version " + syncInfo.getID() + ':', required);
        String originalId = completeVersion.getJar();
        if (!syncInfo.hasRemote() && originalId == null) {
            return container;
        }
        String id = completeVersion.getID();
        String jarFile = "versions/";
        String saveFile = "versions/";
        if (originalId == null) {
            repo = syncInfo.getRemote().getSource();
            saveFile = jarFile = jarFile + id + "/" + id + ".jar";
        } else {
            repo = Repository.OFFICIAL_VERSION_REPO;
            jarFile = jarFile + originalId + "/" + originalId + ".jar";
            saveFile = saveFile + id + "/" + id + ".jar";
        }
        File file = new File(baseDirectory1, saveFile);
        if (!VersionManager.badFile(file)) {
            return container;
        }
        if (!force && originalId != null) {
            File d = new File(baseDirectory1, jarFile);
            File originalFileBak = new File(baseDirectory1, jarFile + ".bak");
            if (d.isFile() && originalFileBak.isFile() && d.length() == originalFileBak.length()) {
                FileUtil.copyFile(d, file, true);
                return container;
            }
        }
        Downloadable d1 = new Downloadable(repo, jarFile, new File(baseDirectory1, saveFile), force);
        d1.addAdditionalDestination(new File(d1.getDestination() + ".bak"));
        this.log("Jar for " + syncInfo.getID() + ':', d1);
        container.add(d1);
        return container;
    }

    private static boolean badFile(File file) {
        return !file.isFile() || file.length() == 0L;
    }

    private void logSearchError(String message) {
        U.debug("[VersionManager] " + message + " " + new Date(System.currentTimeMillis()).toString());
    }

    class AsyncRawVersionListObject
    extends AsyncObject<VersionList.RawVersionList> {
        private final RemoteVersionList remoteList;

        AsyncRawVersionListObject(RemoteVersionList remoteList) {
            this.remoteList = remoteList;
        }

        RemoteVersionList getVersionList() {
            return this.remoteList;
        }

        @Override
        protected VersionList.RawVersionList execute() throws AsyncObjectGotErrorException {
            try {
                return this.remoteList.getRawList();
            }
            catch (Exception var2) {
                VersionManager.this.log(new Object[]{"Error refreshing version list:", var2});
                throw new AsyncObjectGotErrorException(this, (Throwable)var2);
            }
        }
    }
}

