/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.accounts;

import ru.turikhay.tlauncher.managers.ProfileManager;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.minecraft.auth.Authenticator;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorListener;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.accounts.AccountEditor;
import ru.turikhay.tlauncher.ui.accounts.AccountList;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.listener.AuthUIListener;
import ru.turikhay.tlauncher.ui.scenes.AccountEditorScene;
import ru.turikhay.util.U;

public class AccountHandler {
    private final AccountEditorScene scene;
    public final AccountList list;
    public final AccountEditor editor;
    private final ProfileManager manager = TLauncher.getInstance().getProfileManager();
    private final AuthUIListener listener;
    private Account lastAccount;
    private Account tempAccount;

    public AccountHandler(AccountEditorScene sc) {
        this.scene = sc;
        this.list = this.scene.list;
        this.editor = this.scene.editor;
        this.listener = new AuthUIListener(new AuthenticatorListener(){

            @Override
            public void onAuthPassing(Authenticator auth) {
                AccountHandler.this.block();
            }

            @Override
            public void onAuthPassingError(Authenticator auth, Throwable e) {
                AccountHandler.this.unblock();
                int num = AccountHandler.this.list.model.indexOf(AccountHandler.this.lastAccount);
                AccountHandler.this.list.model.remove(num);
                AccountHandler.this.clearEditor();
                AccountHandler.this.list.repaint();
                AccountHandler.this.tempAccount = null;
            }

            @Override
            public void onAuthPassed(Authenticator auth) {
                TLauncher.getInstance().getElyManager().setRefreshAllowed(true);
                TLauncher.getInstance().getElyManager().refreshComponent();
                AccountHandler.this.unblock();
                AccountHandler.this.registerTemp();
            }
        });
    }

    public void selectAccount(Account acc) {
        if (acc != null && !acc.equals(this.list.list.getSelectedValue())) {
            this.list.list.setSelectedValue(acc, true);
        }
    }

    void refreshEditor(Account account) {
        if (account == null) {
            this.clearEditor();
        } else if (!account.equals(this.lastAccount)) {
            this.lastAccount = account;
            Blocker.unblock(this.editor, "empty");
            this.editor.fill(account);
            if (!account.equals(this.tempAccount)) {
                this.scene.getMainPane().defaultScene.loginForm.accountComboBox.setAccount(this.lastAccount);
            }
        }
    }

    void clearEditor() {
        this.lastAccount = null;
        this.editor.clear();
        this.notifyEmpty();
    }

    void saveEditor() {
        if (this.lastAccount != null) {
            Account acc = this.editor.get();
            System.out.println(acc.getPassword());
            if (acc.getUsername() == null) {
                Alert.showLocError("auth.error.email.account");
            } else {
                this.lastAccount.complete(acc);
                U.log(this.lastAccount.isFree());
                if (!this.lastAccount.isFree()) {
                    if (this.lastAccount.getAccessToken() == null && this.lastAccount.getPassword() == null) {
                        Alert.showLocError("auth.error.nopass");
                        return;
                    }
                    Authenticator.instanceFor(this.lastAccount).asyncPass(this.listener);
                } else {
                    this.registerTemp();
                    this.listener.saveProfiles();
                }
            }
        }
    }

    void exitEditor() {
        this.scene.getMainPane().openDefaultScene();
        this.listener.saveProfiles();
        this.list.list.clearSelection();
        this.notifyEmpty();
    }

    public void addAccount() {
        if (this.tempAccount == null) {
            for (int i = 0; i < this.list.model.getSize(); ++i) {
                if (this.list.model.getElementAt(i).getUsername() != null) continue;
                return;
            }
            this.tempAccount = new Account();
            this.list.model.addElement(this.tempAccount);
            this.list.list.setSelectedValue(this.tempAccount, true);
            this.refreshEditor(this.tempAccount);
        }
    }

    public void removeAccount() {
        System.out.println("model=" + this.list.model);
        System.out.println("base=" + this.manager.getAuthDatabase().getAccounts());
        if (this.lastAccount != null && !this.list.model.isEmpty()) {
            Account selected = this.list.list.getSelectedValue();
            Account acc = this.lastAccount;
            int num = this.list.model.indexOf(this.lastAccount) - 1;
            this.list.model.removeElement(selected);
            this.lastAccount = acc;
            if (selected.getUsername() != null) {
                U.log("Removing", this.lastAccount);
                this.manager.getAuthDatabase().unregisterAccount(selected);
                this.listener.saveProfiles();
                this.tempAccount = null;
            } else {
                this.tempAccount = null;
                this.clearEditor();
            }
            if (num > -1) {
                this.list.list.setSelectedIndex(num);
            }
            System.out.println("//-------------------------//");
            System.out.println("model=" + this.list.model);
            System.out.println("base=" + this.manager.getAuthDatabase().getAccounts());
        }
    }

    void registerTemp() {
        if (this.tempAccount != null) {
            this.manager.getAuthDatabase().registerAccount(this.tempAccount);
            this.scene.getMainPane().defaultScene.loginForm.accountComboBox.refreshAccounts(this.manager.getAuthDatabase(), this.tempAccount);
            int num = this.list.model.indexOf(this.tempAccount);
            this.list.list.setSelectedIndex(num);
            this.tempAccount = null;
        }
    }

    public void notifyEmpty() {
        if (this.list.list.getSelectedIndex() == -1) {
            Blocker.block(this.editor, "empty");
        }
    }

    private void block() {
        Blocker.block("auth", this.editor, this.list);
    }

    private void unblock() {
        Blocker.unblock("auth", this.editor, this.list);
    }
}

