/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.center;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import javax.swing.BoxLayout;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.configuration.LangConfiguration;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.block.BlockablePanel;
import ru.turikhay.tlauncher.ui.center.CenterPanelTheme;
import ru.turikhay.tlauncher.ui.center.DefaultCenterPanelTheme;
import ru.turikhay.tlauncher.ui.center.LoadingPanelTheme;
import ru.turikhay.tlauncher.ui.center.SettingsPanelTheme;
import ru.turikhay.tlauncher.ui.center.TipPanelTheme;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.swing.Del;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.ui.swing.extended.UnblockablePanel;
import ru.turikhay.util.U;

public class CenterPanel
extends BlockablePanel {
    private static final long serialVersionUID = -1975869198322761508L;
    public static final CenterPanelTheme defaultTheme = new DefaultCenterPanelTheme();
    public static final CenterPanelTheme tipTheme = new TipPanelTheme();
    public static final CenterPanelTheme loadingTheme = new LoadingPanelTheme();
    public static final CenterPanelTheme settingsTheme = new SettingsPanelTheme();
    public static final Insets defaultInsets = new Insets(5, 24, 18, 24);
    public static final Insets squareInsets = new Insets(11, 15, 11, 15);
    public static final Insets smallSquareInsets = new Insets(7, 7, 7, 7);
    public static final Insets smallSquareNoTopInsets = new Insets(5, 15, 5, 15);
    public static final Insets noInsets = new Insets(0, 0, 0, 0);
    protected static final int ARC_SIZE = 24;
    private final Insets insets;
    private final CenterPanelTheme theme;
    protected final ExtendedPanel messagePanel;
    protected final LocalizableLabel messageLabel;
    public final TLauncher tlauncher = TLauncher.getInstance();
    public final Configuration global = this.tlauncher.getSettings();
    public final LangConfiguration lang = this.tlauncher.getLang();

    public CenterPanel() {
        this((CenterPanelTheme)null, null);
    }

    public CenterPanel(Insets insets) {
        this((CenterPanelTheme)null, insets);
    }

    public CenterPanel(CenterPanelTheme theme) {
        this(theme, null);
    }

    public CenterPanel(CenterPanelTheme theme, Insets insets) {
        theme = theme == null ? defaultTheme : theme;
        this.theme = theme;
        Insets var10001 = insets == null ? defaultInsets : insets;
        Insets var10002 = insets == null ? defaultInsets : insets;
        this.insets = var10001;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(theme.getPanelBackground());
        this.messageLabel = new LocalizableLabel("  ");
        this.messageLabel.setFont(this.getFont().deriveFont(1));
        this.messageLabel.setVerticalAlignment(0);
        this.messageLabel.setHorizontalTextPosition(0);
        this.messageLabel.setAlignmentX(0.5f);
        this.messagePanel = new ExtendedPanel();
        this.messagePanel.setLayout(new BoxLayout(this.messagePanel, 1));
        this.messagePanel.setAlignmentX(0.5f);
        this.messagePanel.setInsets(new Insets(3, 0, 3, 0));
        this.messagePanel.add((Component)this.messageLabel);
    }

    @Override
    public void paintComponent(Graphics g0) {
        int var5;
        Graphics2D g = (Graphics2D)g0;
        int x = 0;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getBackground());
        g.fillRoundRect(x, x, this.getWidth(), this.getHeight(), 0, 0);
        g.setColor(this.theme.getBorder());
        for (var5 = 1; var5 < 3; ++var5) {
        }
        Color shadow = U.shiftAlpha(Color.gray, -155);
        var5 = 3;
        while (true) {
            if ((shadow = U.shiftAlpha(shadow, -10)).getAlpha() == 0) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                super.paintComponent(g);
                return;
            }
            g.setColor(shadow);
            ++var5;
        }
    }

    public CenterPanelTheme getTheme() {
        return this.theme;
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    protected Del del(int aligment) {
        return new Del(1, aligment, this.theme.getBorder());
    }

    protected Del del(int aligment, int width, int height) {
        return new Del(1, aligment, width, height, this.theme.getBorder());
    }

    public void defocus() {
        this.requestFocusInWindow();
    }

    public boolean setError(String message) {
        this.messageLabel.setForeground(this.theme.getFailure());
        this.messageLabel.setText(message != null && message.length() != 0 ? message : " ");
        return false;
    }

    protected boolean setMessage(String message, Object ... vars) {
        this.messageLabel.setForeground(this.theme.getFocus());
        this.messageLabel.setText(message != null && message.length() != 0 ? message : " ", vars);
        return true;
    }

    protected boolean setMessage(String message) {
        return this.setMessage(message, Localizable.EMPTY_VARS);
    }

    public static BlockablePanel sepPan(LayoutManager manager, Component ... components) {
        BlockablePanel panel = new BlockablePanel(manager){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return noInsets;
            }
        };
        panel.add(components);
        return panel;
    }

    public static BlockablePanel sepPan(Component ... components) {
        return CenterPanel.sepPan(new GridLayout(0, 1), components);
    }

    public static UnblockablePanel uSepPan(LayoutManager manager, Component ... components) {
        UnblockablePanel panel = new UnblockablePanel(manager){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return noInsets;
            }
        };
        panel.add(components);
        return panel;
    }

    public static UnblockablePanel uSepPan(Component ... components) {
        return CenterPanel.uSepPan(new GridLayout(0, 1), components);
    }

    protected void log(Object ... o) {
        U.log("[" + this.getClass().getSimpleName() + "]", o);
    }
}

