/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.login;

import java.awt.Component;
import java.awt.GridLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.downloader.Downloader;
import ru.turikhay.tlauncher.downloader.DownloaderListener;
import ru.turikhay.tlauncher.managers.ServerList;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.managers.VersionManagerListener;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.minecraft.auth.Authenticator;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorListener;
import ru.turikhay.tlauncher.minecraft.crash.Crash;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftException;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftListener;
import ru.turikhay.tlauncher.ui.MainPane;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.center.CenterPanel;
import ru.turikhay.tlauncher.ui.login.AccountComboBox;
import ru.turikhay.tlauncher.ui.login.CheckBoxPanel;
import ru.turikhay.tlauncher.ui.login.InputPanel;
import ru.turikhay.tlauncher.ui.login.LoginException;
import ru.turikhay.tlauncher.ui.login.LoginWaitException;
import ru.turikhay.tlauncher.ui.login.VersionComboBox;
import ru.turikhay.tlauncher.ui.login.buttons.ButtonPanel;
import ru.turikhay.tlauncher.ui.login.buttons.PlayButton;
import ru.turikhay.tlauncher.ui.scenes.DefaultScene;
import ru.turikhay.tlauncher.ui.settings.SettingsPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.util.U;
import ru.turikhay.util.async.LoopedThread;

public class LoginForm
extends CenterPanel
implements MinecraftListener,
AuthenticatorListener,
VersionManagerListener,
DownloaderListener {
    private final List<LoginStateListener> stateListeners = Collections.synchronizedList(new ArrayList());
    private final List<LoginProcessListener> processListeners = Collections.synchronizedList(new ArrayList());
    public final DefaultScene scene;
    public final MainPane pane;
    private final SettingsPanel settings;
    public final InputPanel input;
    public final VersionComboBox versions;
    public final CheckBoxPanel checkbox;
    public final PlayButton play;
    public final ButtonPanel buttons;
    public final AccountComboBox accountComboBox;
    private final StartThread startThread;
    private final StopThread stopThread;
    private LoginState state = LoginState.STOPPED;
    private ServerList.Server server;
    public static final String LOGIN_BLOCK = "login";
    public static final String REFRESH_BLOCK = "refresh";
    public static final String LAUNCH_BLOCK = "launch";
    public static final String AUTH_BLOCK = "auth";
    public static final String UPDATER_BLOCK = "update";
    public static final String DOWNLOADER_BLOCK = "download";

    public LoginForm(DefaultScene scene) {
        super(squareInsets);
        this.play = new PlayButton(this);
        this.scene = scene;
        this.pane = scene.getMainPane();
        this.settings = scene.settingsForm;
        this.startThread = new StartThread();
        this.stopThread = new StopThread();
        this.input = new InputPanel(this);
        this.versions = this.input.version;
        this.checkbox = this.input.checkbox;
        this.accountComboBox = this.input.accountComboBox;
        this.buttons = new ButtonPanel(this);
        this.processListeners.add(this.settings);
        this.processListeners.add(this.checkbox);
        this.processListeners.add(this.versions);
        this.stateListeners.add(this.play);
        ExtendedPanel panel = new ExtendedPanel();
        GridLayout layout = new GridLayout(1, 3);
        layout.setHgap(5);
        panel.setLayout(layout);
        panel.add(this.input, this.play, this.buttons);
        this.add((Component)panel);
        this.tlauncher.getVersionManager().addListener(this);
        this.tlauncher.getDownloader().addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runProcess() {
        LoginException error = null;
        boolean success = true;
        List<LoginProcessListener> force = this.processListeners;
        List<LoginProcessListener> list = this.processListeners;
        synchronized (list) {
            for (LoginProcessListener listener : this.processListeners) {
                try {
                    this.log("Listener:", listener);
                    listener.logginingIn();
                }
                catch (LoginWaitException var10) {
                    LoginWaitException loginError = var10;
                    this.log("Catched a wait task from this listener, waiting...");
                    try {
                        loginError.getWaitTask().runTask();
                    }
                    catch (LoginException var9) {
                        this.log("Catched an error on a wait task.");
                        error = var9;
                    }
                }
                catch (LoginException var11) {
                    this.log("Catched an error on a listener");
                    error = var11;
                }
                if (error == null) continue;
                this.log(error);
                success = false;
                break;
            }
            if (success) {
                for (LoginProcessListener listener : this.processListeners) {
                    listener.loginSucceed();
                }
            } else {
                this.tlauncher.getPopupMenuManager().enablePopup();
                for (LoginProcessListener listener : this.processListeners) {
                    listener.loginFailed();
                }
            }
        }
        if (error != null) {
            this.log("Login process has ended with an error.");
        } else {
            if (this.input.getTypeAccountShow() == Account.AccountType.FREE) {
                this.global.setForcefully("login.account", this.input.getUsername(), false);
            }
            this.global.setForcefully("login.account.temp", this.input.getUsername(), false);
            this.global.setForcefully("login.version", this.versions.getVersion().getID(), false);
            this.global.store();
            this.log("Login was OK. Trying to launch now.");
            boolean force1 = this.checkbox.forceupdate.isSelected();
            this.changeState(LoginState.LAUNCHING);
            this.tlauncher.launch(this, this.server, force1);
            this.checkbox.forceupdate.setSelected(false);
        }
    }

    private void stopProcess() {
        while (!this.tlauncher.isLauncherWorking()) {
            this.log("waiting for launcher");
            U.sleepFor(500L);
        }
        this.changeState(LoginState.STOPPING);
        this.tlauncher.getLauncher().stop();
    }

    public void startLauncher() {
        this.startLauncher(null);
    }

    public void startLauncher(ServerList.Server server) {
        if (!Blocker.isBlocked(this)) {
            this.server = server;
            this.startThread.iterate();
        }
    }

    public void stopLauncher() {
        this.stopThread.iterate();
    }

    private void changeState(LoginState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        if (this.state != state) {
            this.state = state;
            for (LoginStateListener listener : this.stateListeners) {
                listener.loginStateChanged(state);
            }
        }
    }

    @Override
    public void block(Object reason) {
        if (!Blocker.getBlockList(this).contains(REFRESH_BLOCK)) {
            Blocker.block(this.input.username, reason);
        }
        Blocker.block(reason, this.settings, this.versions, this.play, this.checkbox);
    }

    @Override
    public void unblock(Object reason) {
        Blocker.unblock(reason, this.settings, this.input.username, this.play, this.versions, this.checkbox);
    }

    @Override
    public void onDownloaderStart(Downloader d, int files) {
        Blocker.block(this, DOWNLOADER_BLOCK);
    }

    @Override
    public void onDownloaderAbort(Downloader d) {
        Blocker.unblock(this, DOWNLOADER_BLOCK);
    }

    @Override
    public void onDownloaderProgress(Downloader d, double progress, double speed) {
    }

    @Override
    public void onDownloaderFileComplete(Downloader d, Downloadable file) {
    }

    @Override
    public void onDownloaderComplete(Downloader d) {
        Blocker.unblock(this, DOWNLOADER_BLOCK);
    }

    @Override
    public void onVersionsRefreshing(VersionManager manager) {
        Blocker.block(this, REFRESH_BLOCK);
    }

    @Override
    public void onVersionsRefreshingFailed(VersionManager manager) {
        Blocker.unblock(this, REFRESH_BLOCK);
    }

    @Override
    public void onVersionsRefreshed(VersionManager manager) {
        Blocker.unblock(this, REFRESH_BLOCK);
    }

    @Override
    public void onAuthPassing(Authenticator auth) {
        Blocker.block(this, AUTH_BLOCK);
    }

    @Override
    public void onAuthPassingError(Authenticator auth, Throwable e) {
        Blocker.unblock(this, AUTH_BLOCK);
        Throwable cause = e.getCause();
        if (cause == null || !(e.getCause() instanceof IOException)) {
            throw new LoginException("Cannot auth!");
        }
    }

    @Override
    public void onAuthPassed(Authenticator auth) {
        Blocker.unblock(this, AUTH_BLOCK);
    }

    @Override
    public void onMinecraftPrepare() {
        Blocker.block(this, LAUNCH_BLOCK);
    }

    @Override
    public void onMinecraftAbort() {
        Blocker.unblock(this, LAUNCH_BLOCK);
        this.play.updateState();
    }

    @Override
    public void onMinecraftLaunch() {
        this.changeState(LoginState.LAUNCHED);
    }

    @Override
    public void onMinecraftClose() {
        Blocker.unblock(this, LAUNCH_BLOCK);
        this.changeState(LoginState.STOPPED);
        this.tlauncher.getVersionManager().startRefresh(true);
    }

    @Override
    public void onMinecraftError(Throwable e) {
        Blocker.unblock(this, LAUNCH_BLOCK);
        this.changeState(LoginState.STOPPED);
    }

    @Override
    public void onMinecraftKnownError(MinecraftException e) {
        Blocker.unblock(this, LAUNCH_BLOCK);
        this.changeState(LoginState.STOPPED);
    }

    @Override
    public void onMinecraftCrash(Crash crash) {
        Blocker.unblock(this, LAUNCH_BLOCK);
        this.changeState(LoginState.STOPPED);
    }

    public void removeLoginProcessListener(LoginProcessListener listener) {
        this.processListeners.remove(listener);
    }

    public void addLoginProcessListener(LoginProcessListener listener) {
        this.processListeners.add(listener);
    }

    class StartThread
    extends LoopedThread {
        StartThread() {
            this.startAndWait();
        }

        @Override
        protected void iterateOnce() {
            try {
                LoginForm.this.runProcess();
            }
            catch (Throwable var2) {
                Alert.showError(var2);
            }
        }
    }

    class StopThread
    extends LoopedThread {
        StopThread() {
            this.startAndWait();
        }

        @Override
        protected void iterateOnce() {
            try {
                LoginForm.this.stopProcess();
            }
            catch (Throwable var2) {
                Alert.showError(var2);
            }
        }
    }

    public static enum LoginState {
        LAUNCHING,
        STOPPING,
        STOPPED,
        LAUNCHED;

    }

    public static interface LoginStateListener {
        public void loginStateChanged(LoginState var1);
    }

    public static interface LoginProcessListener {
        public void logginingIn() throws LoginException;

        public void loginFailed();

        public void loginSucceed();
    }

    public static abstract class LoginListener
    implements LoginProcessListener {
        @Override
        public abstract void logginingIn() throws LoginException;

        @Override
        public void loginFailed() {
        }

        @Override
        public void loginSucceed() {
        }
    }

    class LoginAbortedException
    extends Exception {
        LoginAbortedException() {
        }
    }
}

