/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.settings;

import java.io.IOException;
import java.io.StringReader;
import ru.turikhay.tlauncher.ui.images.ImageCache;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.swing.editor.EditorPane;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.U;
import ru.turikhay.util.git.ITokenResolver;
import ru.turikhay.util.git.TokenReplacingReader;

public class HTMLPage
extends BorderPanel
implements LocalizableComponent {
    private final AboutPageTokenResolver resolver;
    private final String source;
    private final EditorPane editor;

    HTMLPage(String resourceName) {
        String tempSource;
        try {
            tempSource = FileUtil.getResource(this.getClass().getResource(resourceName));
        }
        catch (Exception var4) {
            U.log(var4);
            tempSource = null;
        }
        this.source = tempSource;
        this.resolver = new AboutPageTokenResolver();
        this.editor = new EditorPane();
        this.updateLocale();
        this.setCenter(this.editor);
    }

    public EditorPane getEditor() {
        return this.editor;
    }

    public String getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLocale() {
        if (this.source != null) {
            StringBuilder string;
            block9: {
                block8: {
                    string = new StringBuilder();
                    TokenReplacingReader replacer = new TokenReplacingReader(new StringReader(this.source), this.resolver);
                    try {
                        int read;
                        while ((read = replacer.read()) > 0) {
                            try {
                                string.append((char)read);
                            }
                            catch (IOException var8) {
                                var8.printStackTrace();
                                break block8;
                            }
                        }
                        break block9;
                    }
                    finally {
                        U.close(replacer);
                    }
                }
                return;
            }
            this.editor.setText(string.toString());
        }
    }

    private class AboutPageTokenResolver
    implements ITokenResolver {
        private static final String image = "image:";
        private static final String loc = "loc:";
        private static final String color = "color";

        private AboutPageTokenResolver() {
        }

        @Override
        public String resolveToken(String token) {
            return token.startsWith(image) ? ImageCache.getRes(token.substring(image.length())).toExternalForm() : (token.startsWith(loc) ? Localizable.get(token.substring(loc.length())) : (token.equals(color) ? "black" : token));
        }

        AboutPageTokenResolver(SyntheticClass_1 x1) {
            this();
        }
    }

    static class SyntheticClass_1 {
        SyntheticClass_1() {
        }
    }
}

