/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.updater;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.downloader.DownloadableHandler;
import ru.turikhay.tlauncher.downloader.Downloader;
import ru.turikhay.tlauncher.rmo.Bootstrapper;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.updater.PackageType;
import ru.turikhay.tlauncher.updater.UpdateListener;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.U;

public class Update {
    protected double version;
    protected double requiredAtLeastFor;
    protected Map<String, String> description = new HashMap<String, String>();
    protected Map<PackageType, String> links = new HashMap<PackageType, String>();
    protected boolean mandatory;
    @Expose(serialize=false, deserialize=false)
    protected boolean userChoose = true;
    @Expose(serialize=false, deserialize=false)
    protected State state = State.NONE;
    @Expose(serialize=false, deserialize=false)
    protected Downloader downloader = this.getDefaultDownloader();
    @Expose(serialize=false, deserialize=false)
    private Downloadable download;
    @Expose(serialize=false, deserialize=false)
    private final List<UpdateListener> listeners = Collections.synchronizedList(new ArrayList());

    public Update() {
    }

    public Update(double version, Map<String, String> description, Map<PackageType, String> links) {
        this.version = version;
        if (description != null) {
            this.description.putAll(description);
        }
        if (links != null) {
            this.links.putAll(links);
        }
    }

    public double getVersion() {
        return this.version;
    }

    public void setVersion(double version) {
        this.version = version;
    }

    public double getRequiredAtLeastFor() {
        return this.requiredAtLeastFor;
    }

    public void setRequiredAtLeastFor(double version) {
        this.requiredAtLeastFor = version;
    }

    public Map<String, String> getDescriptionMap() {
        return this.description;
    }

    public Map<PackageType, String> getLinks() {
        return this.links;
    }

    public String getLink(PackageType packageType) {
        return this.links.get((Object)packageType);
    }

    public String getLink() {
        return this.getLink(PackageType.CURRENT);
    }

    public State getState() {
        return this.state;
    }

    protected void setState(State newState) {
        if (newState.ordinal() <= this.state.ordinal() && this.state.ordinal() != State.values().length - 1) {
            throw new IllegalStateException("tried to change from " + (Object)((Object)this.state) + " to " + (Object)((Object)newState));
        }
        this.state = newState;
        this.log(new Object[]{"Set state:", newState});
    }

    public Downloader getDownloader() {
        return this.downloader;
    }

    public void setDownloader(Downloader downloader) {
        this.downloader = downloader;
    }

    public boolean isApplicable() {
        return !this.userChoose ? false : StringUtils.isNotBlank(this.links.get((Object)PackageType.CURRENT)) && TLauncher.getVersion() < this.version;
    }

    public boolean isRequired() {
        return !this.userChoose ? false : this.requiredAtLeastFor != 0.0 && TLauncher.getVersion() <= this.requiredAtLeastFor;
    }

    public String getDescription(String key) {
        return this.description == null ? null : this.description.get(key);
    }

    public String getDescription() {
        return this.getDescription(TLauncher.getInstance().getSettings().getLocale().toString());
    }

    protected void download0(PackageType packageType, boolean async) throws Throwable {
        this.setState(State.DOWNLOADING);
        URL url = new URL(this.getLink(packageType));
        this.log("url:", url);
        File destination = new File(FileUtil.getRunningJar().getAbsolutePath() + ".update");
        destination.deleteOnExit();
        this.log("dest", destination);
        this.download = new Downloadable(url.toExternalForm(), destination);
        this.download.setInsertUA(true);
        this.download.addHandler(new DownloadableHandler(){

            @Override
            public void onStart(Downloadable d) {
            }

            @Override
            public void onAbort(Downloadable d) {
                Update.this.onUpdateDownloadError(d.getError());
            }

            @Override
            public void onComplete(Downloadable d) {
                Update.this.onUpdateReady();
            }

            @Override
            public void onError(Downloadable d, Throwable e) {
                Update.this.onUpdateDownloadError(e);
            }
        });
        this.downloader.add(this.download);
        this.onUpdateDownloading();
        if (async) {
            this.downloader.startDownload();
        } else {
            this.downloader.startDownloadAndWait();
        }
    }

    public void download(PackageType type, boolean async) {
        try {
            this.download0(type, async);
        }
        catch (Throwable var4) {
            this.onUpdateError(var4);
        }
    }

    public void download(boolean async) {
        this.download(PackageType.CURRENT, async);
    }

    public void download() {
        this.download(false);
    }

    public void asyncDownload() {
        this.download(true);
    }

    protected void apply0() throws Throwable {
        this.setState(State.APPLYING);
        File replace = FileUtil.getRunningJar();
        File replaceWith = this.download.getDestination();
        String[] args = TLauncher.getInstance() != null ? TLauncher.getArgs() : new String[]{};
        ProcessBuilder builder = Bootstrapper.createLauncher(args).createProcess();
        this.onUpdateApplying();
        FileInputStream in = new FileInputStream(replaceWith);
        FileOutputStream out = new FileOutputStream(replace);
        byte[] buffer = new byte[2048];
        int read = in.read(buffer);
        while (read > 0) {
            out.write(buffer, 0, read);
            read = in.read(buffer);
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            builder.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(0);
    }

    public void apply() {
        try {
            this.apply0();
        }
        catch (Throwable var2) {
            this.onUpdateApplyError(var2);
        }
    }

    public void addListener(UpdateListener l) {
        this.listeners.add(l);
    }

    public void removeListener(UpdateListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onUpdateError(Throwable e) {
        this.setState(State.ERRORED);
        List<UpdateListener> var2 = this.listeners;
        List<UpdateListener> list = this.listeners;
        synchronized (list) {
            for (UpdateListener l : this.listeners) {
                l.onUpdateError(this, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onUpdateDownloading() {
        List<UpdateListener> var1 = this.listeners;
        List<UpdateListener> list = this.listeners;
        synchronized (list) {
            for (UpdateListener l : this.listeners) {
                l.onUpdateDownloading(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onUpdateDownloadError(Throwable e) {
        this.setState(State.ERRORED);
        List<UpdateListener> var2 = this.listeners;
        List<UpdateListener> list = this.listeners;
        synchronized (list) {
            for (UpdateListener l : this.listeners) {
                l.onUpdateDownloadError(this, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onUpdateReady() {
        this.setState(State.READY);
        List<UpdateListener> var1 = this.listeners;
        List<UpdateListener> list = this.listeners;
        synchronized (list) {
            for (UpdateListener l : this.listeners) {
                l.onUpdateReady(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onUpdateApplying() {
        List<UpdateListener> var1 = this.listeners;
        List<UpdateListener> list = this.listeners;
        synchronized (list) {
            for (UpdateListener l : this.listeners) {
                l.onUpdateApplying(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onUpdateApplyError(Throwable e) {
        this.setState(State.ERRORED);
        List<UpdateListener> var2 = this.listeners;
        List<UpdateListener> list = this.listeners;
        synchronized (list) {
            for (UpdateListener l : this.listeners) {
                l.onUpdateApplyError(this, e);
            }
        }
    }

    protected Downloader getDefaultDownloader() {
        return TLauncher.getInstance().getDownloader();
    }

    protected void log(Object ... o) {
        U.log("[Update:" + this.version + "]", o);
    }

    public String toString() {
        return "Update{version=" + this.version + ",requiredAtLeastFor=" + this.requiredAtLeastFor + ",description=" + this.description + ",links=" + this.links + ",mandatory=" + this.mandatory + "}";
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isUserChoose() {
        return this.userChoose;
    }

    public void setUserChoose(boolean userChoose) {
        this.userChoose = userChoose;
    }

    public static enum State {
        NONE,
        DOWNLOADING,
        READY,
        APPLYING,
        ERRORED;

    }

    public static class Deserializer
    implements JsonDeserializer<Update> {
        @Override
        public Update deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            try {
                return this.deserialize0(json, context);
            }
            catch (Exception var5) {
                U.log("Cannot parse update:", var5);
                return new Update();
            }
        }

        private Update deserialize0(JsonElement json, JsonDeserializationContext context) {
            Map links;
            JsonObject object = json.getAsJsonObject();
            Update update = new Update();
            update.version = object.get("version").getAsDouble();
            update.mandatory = object.get("mandatory").getAsBoolean();
            update.requiredAtLeastFor = object.has("requiredAtLeastFor") ? object.get("requiredAtLeastFor").getAsDouble() : 0.0;
            Map description = (Map)context.deserialize(object.get("description"), new TypeToken<Map<String, String>>(){}.getType());
            if (description != null) {
                update.description.putAll(description);
            }
            if ((links = (Map)context.deserialize(object.get("links"), new TypeToken<Map<PackageType, String>>(){}.getType())) != null) {
                update.links.putAll(links);
            }
            return update;
        }
    }
}

