/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.review;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Scanner;
import ru.turikhay.tlauncher.entity.Review;
import ru.turikhay.tlauncher.exceptions.ConnectServerConfig;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.review.ReviewWindowListener;
import ru.turikhay.util.U;
import ru.turikhay.util.review.ReviewMessage;
import ru.turikhay.util.salf.connection.ConfigSeacher;
import ru.turikhay.util.salf.connection.ServerEntity;
import ru.turikhay.util.salf.connection.TransferFilesAbstract;

public class ReferenceReview
extends TransferFilesAbstract
implements Runnable {
    public static final String NAME_FILE_CONFIG = "ConfigReferenceServer.json";
    private ReviewMessage message;
    private ConfigSeacher configSeacher;
    private ReviewWindowListener listener;
    private Review review;
    private boolean interrupt = false;

    public ReferenceReview(Review review, ReviewWindowListener listener) {
        this.review = review;
        this.message = new ReviewMessage();
        this.configSeacher = new ConfigSeacher(TLauncher.getAddressServer(), NAME_FILE_CONFIG);
        this.listener = listener;
        for (File file : review.getListFiles()) {
            this.message.getListNamesOfFiles().add(file.getName());
        }
        this.message.setTitle(review.getTitle());
        this.message.setDescription(review.getDescription());
        this.message.setMailReview(review.getMailReview());
        this.message.setTypeReview(review.getTypeReview());
    }

    @Override
    public void run() {
        Thread.currentThread().setName("ReferenceReview");
        try {
            try {
                this.sendFiles(this.configSeacher.readServer());
            }
            catch (ConnectServerConfig var2) {
                this.configSeacher.saveConfigFromServer();
                this.sendFiles(this.configSeacher.readServer());
            }
        }
        catch (IOException | ConnectServerConfig var3) {
            this.backResult(var3);
            return;
        }
        if (this.interrupt) {
            this.listener.eventFilesSend(1);
        } else {
            this.listener.eventFilesSend(0);
        }
    }

    private void backResult(Exception e) {
        this.log(e);
        this.listener.eventFilesSend(-1);
    }

    @Override
    @Deprecated
    public void sendFiles(String file) throws IOException {
    }

    private void sendFiles(ServerEntity server) throws IOException, ConnectServerConfig {
        int port = this.getPortTransfer(server);
        byte[] array = new byte[65536];
        try (Socket socket = new Socket(server.getUrl(), port);){
            OutputStream x2 = socket.getOutputStream();
            InputStream in = socket.getInputStream();
            ObjectOutputStream outObject = new ObjectOutputStream(x2);
            Scanner sc = new Scanner(in);
            outObject.writeObject(this.message);
            outObject.flush();
            DataOutputStream dataOutputStream = new DataOutputStream(x2);
            for (File file : this.review.getListFiles()) {
                long sizeFile = file.length();
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
                dataOutputStream.writeLong(sizeFile);
                long read = inputStream.read(array);
                for (long i = 0L; i < sizeFile && read != -1L; i += read) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.interrupt = true;
                        this.log("review has canceled");
                        break;
                    }
                    dataOutputStream.write(array, 0, (int)read);
                    read = inputStream.read(array);
                }
                inputStream.close();
                dataOutputStream.flush();
                if (this.interrupt) continue;
                sc.nextLine();
            }
            this.log("review has sent");
            in.close();
            x2.close();
            sc.close();
        }
    }

    private void log(Object o) {
        U.log("[ReferenceReview] ", o);
    }
}

