/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.everythingexplodes.config;

import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EverythingExplodesConfig {
    public static Configuration config;
    public static float explosionStrength;
    public static boolean damagePlayer;

    public static void loadConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        EverythingExplodesConfig.init();
        MinecraftForge.EVENT_BUS.register((Object)new ChangeListener());
    }

    public static void init() {
        String comment = "Explosion strength multiplier. Default: 3.0";
        explosionStrength = EverythingExplodesConfig.loadFloat("explosion.strength", comment, explosionStrength, "general");
        comment = "Whether or not the player who causes the explosion should take damage from it. Default: true";
        damagePlayer = EverythingExplodesConfig.loadBool("player.explosionDamage", comment, damagePlayer, "general");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static float loadFloat(String name, String comment, float def, String category) {
        Property prop = config.get(category, name, (double)def);
        prop.setComment(comment);
        float val = (float)prop.getDouble((double)def);
        if (val <= 0.0f) {
            val = def;
            prop.set((double)def);
        }
        return val;
    }

    public static boolean loadBool(String name, String comment, boolean def, String category) {
        Property prop = config.get(category, name, def);
        prop.setComment(comment);
        return prop.getBoolean(def);
    }

    static {
        explosionStrength = 3.0f;
        damagePlayer = true;
    }

    public static class ChangeListener {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
            if (eventArgs.getModID().equals("EverythingExplodes")) {
                EverythingExplodesConfig.init();
            }
        }
    }
}

