/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.everythingexplodes.event;

import com.chaosthedude.everythingexplodes.config.EverythingExplodesConfig;
import com.chaosthedude.everythingexplodes.mode.ExplosionMode;
import com.chaosthedude.everythingexplodes.mode.ExplosionModes;
import com.chaosthedude.everythingexplodes.util.Util;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class EverythingExplodesEvents {
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            World world = event.player.field_70170_p;
            EntityPlayer exploder = EverythingExplodesConfig.damagePlayer ? null : event.player;
            ExplosionMode explosionMode = ExplosionModes.getExplosionMode(event.player);
            if (explosionMode.shouldExplode(event.player)) {
                Util.createExplosion(world, (Entity)exploder, event.player.func_180425_c());
            } else if (explosionMode == ExplosionModes.COLLIDE) {
                for (Entity entity : Util.getCollidedEntities((EntityLivingBase)event.player)) {
                    Util.createExplosion(world, (Entity)exploder, entity.func_180425_c());
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getSide() == Side.SERVER && ExplosionModes.getExplosionMode(event.getEntityPlayer()) == ExplosionModes.INTERACT) {
            EntityPlayer exploder = EverythingExplodesConfig.damagePlayer ? null : event.getEntityPlayer();
            Util.createExplosion(event.getWorld(), (Entity)exploder, event.getPos());
        }
    }
}

