/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.everythingexplodes.util;

import com.chaosthedude.everythingexplodes.config.EverythingExplodesConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Util {
    public static List<Entity> getCollidedEntities(EntityLivingBase entityLiving) {
        ArrayList<Entity> collidedEntities = new ArrayList<Entity>();
        if (entityLiving != null) {
            for (Entity loadedEntity : entityLiving.field_70170_p.field_72996_f) {
                if (loadedEntity == null || loadedEntity == entityLiving || !entityLiving.func_174813_aQ().func_72326_a(loadedEntity.func_174813_aQ())) continue;
                collidedEntities.add(loadedEntity);
            }
        }
        return collidedEntities;
    }

    public static void createExplosion(World world, Entity entity, BlockPos pos) {
        world.func_72876_a(entity, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), EverythingExplodesConfig.explosionStrength, true);
    }

    public static UUID getPlayerUUID(EntityPlayer player) {
        if (player != null && player.func_146103_bH() != null) {
            return player.func_146103_bH().getId();
        }
        return null;
    }

    public static List<String> parseStringIntoLength(String s, int length) {
        ArrayList<String> parsedStrings = new ArrayList<String>();
        String line = "";
        boolean addedPrev = false;
        for (String word : Util.splitByWords(s)) {
            if ((line = line.concat(" " + word).trim()).length() > length) {
                parsedStrings.add(line);
                line = "";
                addedPrev = true;
                continue;
            }
            addedPrev = false;
        }
        if (!addedPrev) {
            parsedStrings.add(line);
        }
        return parsedStrings;
    }

    public static String[] splitByWords(String s) {
        return s.split(" ");
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawStringOnHUD(FontRenderer fontRenderer, String string, int xOffset, int yOffset, int color, boolean shadow) {
        fontRenderer.func_175065_a(string, (float)(2 + xOffset), (float)(2 + yOffset), color, shadow);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawStringsOnHUD(FontRenderer fontRenderer, List<String> strings, int xOffset, int yOffset, int color, boolean shadow) {
        for (String s : strings) {
            Util.drawStringOnHUD(fontRenderer, s, xOffset, yOffset, color, shadow);
            yOffset += 9;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static String localize(String unlocString, Object ... args) {
        return I18n.func_135052_a((String)unlocString, (Object[])args);
    }
}

