/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.pandorasbox.block.PBBlocks;
import ivorius.pandorasbox.utils.RandomizedItemStack;
import ivorius.pandorasbox.weighted.WeightedBlock;
import ivorius.pandorasbox.weighted.WeightedEntity;
import ivorius.pandorasbox.weighted.WeightedPotion;
import ivorius.pandorasbox.weighted.WeightedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;

public class PandorasBoxHelper {
    public static List<WeightedEntity> mobs = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> creatures = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> waterCreatures = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> waterMobs = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> tameableCreatures = new ArrayList<WeightedEntity>();
    public static List<RandomizedItemStack> blocksAndItems = new ArrayList<RandomizedItemStack>();
    public static Multimap<Block, IProperty> randomizableBlockProperties = HashMultimap.create();
    public static List<WeightedBlock> blocks = new ArrayList<WeightedBlock>();
    public static List<RandomizedItemStack> items = new ArrayList<RandomizedItemStack>();
    public static List<WeightedSet> equipmentSets = new ArrayList<WeightedSet>();
    public static Hashtable<Item, Hashtable<Integer, ItemStack>> equipmentForLevels = new Hashtable();
    public static List<WeightedPotion> buffs = new ArrayList<WeightedPotion>();
    public static List<WeightedPotion> debuffs = new ArrayList<WeightedPotion>();
    public static List<RandomizedItemStack> enchantableArmorList = new ArrayList<RandomizedItemStack>();
    public static List<RandomizedItemStack> enchantableToolList = new ArrayList<RandomizedItemStack>();
    public static List<WeightedBlock> heavyBlocks = new ArrayList<WeightedBlock>();

    public static void addEntities(List<WeightedEntity> list, double weight, int minNumber, int maxNumber, String ... entities) {
        for (String s : entities) {
            list.add(new WeightedEntity(weight, s, minNumber, maxNumber));
        }
    }

    public static void addBlocks(double weight, Block ... blocks) {
        for (Block block : blocks) {
            PandorasBoxHelper.blocks.add(new WeightedBlock(weight, block));
            Item item = Item.func_150898_a((Block)block);
            if (item == null) continue;
            PandorasBoxHelper.addItem(new RandomizedItemStack(item, 0, 1, item.getItemStackLimit(new ItemStack(item)), weight));
        }
    }

    public static void addBlocks(List<WeightedBlock> list, double weight, Block ... blocks) {
        for (Block block : blocks) {
            list.add(new WeightedBlock(weight, block));
        }
    }

    public static void addItem(RandomizedItemStack RandomizedItemStack2) {
        items.add(RandomizedItemStack2);
        blocksAndItems.add(RandomizedItemStack2);
    }

    public static void addItems(double weight, Object ... items) {
        for (Object object : items) {
            if (object instanceof Item) {
                Item item = (Item)object;
                PandorasBoxHelper.addItem(new RandomizedItemStack(item, 0, 1, item.getItemStackLimit(new ItemStack(item)), weight));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)object;
            PandorasBoxHelper.addItem(new RandomizedItemStack(itemStack, 1, itemStack.func_77973_b().getItemStackLimit(itemStack), weight));
        }
    }

    public static void addItemsMinMax(double weight, int min, int max, Object ... items) {
        for (Object object : items) {
            if (object instanceof Item) {
                Item item = (Item)object;
                PandorasBoxHelper.addItem(new RandomizedItemStack(item, 0, min, max, weight));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)object;
            PandorasBoxHelper.addItem(new RandomizedItemStack(itemStack, min, max, weight));
        }
    }

    public static void addEquipmentSet(double weight, Object ... items) {
        ItemStack[] set = new ItemStack[items.length];
        for (int i = 0; i < set.length; ++i) {
            ItemStack itemStack;
            if (items[i] instanceof Item) {
                Item item = (Item)items[i];
                set[i] = new ItemStack(item);
                continue;
            }
            if (!(items[i] instanceof ItemStack)) continue;
            set[i] = itemStack = (ItemStack)items[i];
        }
        equipmentSets.add(new WeightedSet(weight, set));
    }

    public static void addPotions(List<WeightedPotion> list, double weight, int minStrength, int maxStrength, int minDuration, int maxDuration, Potion ... potions) {
        for (Potion potion : potions) {
            list.add(new WeightedPotion(weight, potion, minStrength, maxStrength, minDuration, maxDuration));
        }
    }

    public static void addEnchantableArmor(double weight, Object ... items) {
        for (Object object : items) {
            if (object instanceof Item) {
                Item item = (Item)object;
                enchantableArmorList.add(new RandomizedItemStack(item, 0, 1, 1, weight));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)object;
            enchantableArmorList.add(new RandomizedItemStack(itemStack, 1, 1, weight));
        }
    }

    public static void addEnchantableTools(double weight, Object ... items) {
        for (Object object : items) {
            if (object instanceof Item) {
                Item item = (Item)object;
                enchantableToolList.add(new RandomizedItemStack(item, 0, 1, 1, weight));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)object;
            enchantableToolList.add(new RandomizedItemStack(itemStack, 1, 1, weight));
        }
    }

    public static void addEquipmentForLevel(Item base, int level, ItemStack stack) {
        if (!equipmentForLevels.containsKey(base)) {
            equipmentForLevels.put(base, new Hashtable());
        }
        equipmentForLevels.get(base).put(level, stack);
    }

    public static void addEquipmentLevelsInOrder(Item base, Object ... items) {
        for (int i = 0; i < items.length; ++i) {
            Object object = items[i];
            if (object instanceof Item) {
                PandorasBoxHelper.addEquipmentForLevel(base, i, new ItemStack((Item)items[i]));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            PandorasBoxHelper.addEquipmentForLevel(base, i, (ItemStack)items[i]);
        }
    }

    public static void addAllRandomizableBlockProperties(Block ... blocks) {
        for (Block block : blocks) {
            randomizableBlockProperties.putAll((Object)block, (Iterable)block.func_176223_P().func_177228_b().keySet());
        }
    }

    public static void addRandomizableBlockProperty(Block[] blocks, IProperty ... properties) {
        for (Block block : blocks) {
            for (IProperty property : properties) {
                randomizableBlockProperties.put((Object)block, (Object)property);
            }
        }
    }

    public static void addRandomizableBlockProperty(Block block, IProperty ... properties) {
        for (IProperty property : properties) {
            randomizableBlockProperties.put((Object)block, (Object)property);
        }
    }

    public static void initialize() {
        PandorasBoxHelper.addEntities(mobs, 10.0, 3, 10, "Zombie");
        PandorasBoxHelper.addEntities(mobs, 10.0, 2, 8, "Spider");
        PandorasBoxHelper.addEntities(mobs, 10.0, 2, 5, "Skeleton");
        PandorasBoxHelper.addEntities(mobs, 5.0, 2, 5, "pbspecial_skeletonWither");
        PandorasBoxHelper.addEntities(mobs, 10.0, 2, 8, "Creeper");
        PandorasBoxHelper.addEntities(mobs, 6.0, 2, 8, "Slime");
        PandorasBoxHelper.addEntities(mobs, 4.0, 1, 4, "Ghast");
        PandorasBoxHelper.addEntities(mobs, 6.0, 2, 8, "PigZombie");
        PandorasBoxHelper.addEntities(mobs, 6.0, 2, 6, "Enderman");
        PandorasBoxHelper.addEntities(mobs, 5.0, 2, 4, "CaveSpider");
        PandorasBoxHelper.addEntities(mobs, 5.0, 10, 20, "Silverfish");
        PandorasBoxHelper.addEntities(mobs, 4.0, 2, 5, "Blaze");
        PandorasBoxHelper.addEntities(mobs, 5.0, 2, 6, "LavaSlime");
        PandorasBoxHelper.addEntities(mobs, 1.0, 1, 1, "WitherBoss");
        PandorasBoxHelper.addEntities(mobs, 4.0, 2, 4, "Witch");
        PandorasBoxHelper.addEntities(mobs, 6.0, 10, 20, "Endermite");
        PandorasBoxHelper.addEntities(mobs, 5.0, 2, 6, "pbspecial_angryWolf");
        PandorasBoxHelper.addEntities(mobs, 4.0, 2, 5, "pbspecial_superchargedCreeper");
        PandorasBoxHelper.addEntities(creatures, 10.0, 3, 10, "Pig", "Sheep", "Cow", "Chicken");
        PandorasBoxHelper.addEntities(creatures, 6.0, 2, 6, "Wolf");
        PandorasBoxHelper.addEntities(creatures, 5.0, 4, 10, "Bat");
        PandorasBoxHelper.addEntities(creatures, 7.0, 6, 20, "Rabbit");
        PandorasBoxHelper.addEntities(creatures, 4.0, 3, 7, "MushroomCow");
        PandorasBoxHelper.addEntities(creatures, 4.0, 3, 7, "SnowMan");
        PandorasBoxHelper.addEntities(creatures, 4.0, 2, 5, "EntityHorse");
        PandorasBoxHelper.addEntities(creatures, 4.0, 2, 6, "Ozelot");
        PandorasBoxHelper.addEntities(creatures, 3.0, 3, 6, "Villager");
        PandorasBoxHelper.addEntities(creatures, 3.0, 2, 4, "VillagerGolem");
        PandorasBoxHelper.addEntities(waterCreatures, 6.0, 3, 10, "Squid");
        PandorasBoxHelper.addEntities(waterMobs, 6.0, 3, 10, "Guardian");
        PandorasBoxHelper.addEntities(waterMobs, 5.0, 1, 1, "pbspecial_elderGuardian");
        PandorasBoxHelper.addEntities(tameableCreatures, 4.0, 1, 4, "pbspecial_wolfTamed");
        PandorasBoxHelper.addEntities(tameableCreatures, 4.0, 1, 4, "pbspecial_ocelotTamed");
        PandorasBoxHelper.addBlocks(40.0, new Block[]{Blocks.field_150348_b, Blocks.field_150322_A, Blocks.field_150344_f, Blocks.field_150354_m, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150325_L, Blocks.field_150334_T, Blocks.field_180388_cO, Blocks.field_150373_bw, Blocks.field_150417_aV, Blocks.field_150406_ce});
        PandorasBoxHelper.addBlocks(15.0, Blocks.field_180397_cI, Blocks.field_150371_ca);
        PandorasBoxHelper.addBlocks(10.0, Blocks.field_150347_e, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150385_bj, Blocks.field_150336_V, Blocks.field_150377_bs, Blocks.field_150405_ch);
        PandorasBoxHelper.addBlocks(10.0, new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150351_n, Blocks.field_150423_aK, Blocks.field_150435_aG, Blocks.field_150391_bh});
        PandorasBoxHelper.addBlocks(8.0, new Block[]{Blocks.field_150365_q, Blocks.field_150369_x, Blocks.field_150450_ax, Blocks.field_150449_bY, Blocks.field_150359_w, Blocks.field_150399_cn, Blocks.field_150425_aM});
        PandorasBoxHelper.addBlocks(0.2, Blocks.field_150484_ah, Blocks.field_150475_bE, Blocks.field_150340_R);
        PandorasBoxHelper.addBlocks(0.3, Blocks.field_150339_S);
        PandorasBoxHelper.addBlocks(0.5, Blocks.field_150482_ag, Blocks.field_150412_bA, Blocks.field_150352_o);
        PandorasBoxHelper.addBlocks(1.0, Blocks.field_150366_p);
        PandorasBoxHelper.addBlocks(2.0, Blocks.field_150335_W, Blocks.field_150426_aN, Blocks.field_150402_ci, Blocks.field_150368_y, Blocks.field_150451_bX, Blocks.field_180399_cE, Blocks.field_150360_v);
        PandorasBoxHelper.addBlocks(5.0, Blocks.field_150418_aU, Blocks.field_150379_bu, Blocks.field_180398_cJ, Blocks.field_150433_aE, Blocks.field_150342_X, Blocks.field_150428_aP, Blocks.field_150407_cf, Blocks.field_150343_Z, Blocks.field_150440_ba);
        PandorasBoxHelper.addItems(10.0, Items.field_151044_h, Items.field_151016_H, Items.field_151015_O, Items.field_151141_av, Items.field_151137_ax, Items.field_151103_aS, Items.field_151127_ba, Items.field_151119_aD, Items.field_151122_aG, Items.field_151074_bl, Items.field_151174_bG, Items.field_151133_ar, Items.field_151055_y, Items.field_151007_F, Items.field_151081_bc, Items.field_151080_bb, Items.field_151014_N, Items.field_151126_ay, Items.field_151102_aT, Items.field_151112_aM, Items.field_151156_bN, Items.field_151075_bm, Items.field_151145_ak, Items.field_151110_aK, Items.field_151118_aC, Items.field_151121_aF, new ItemStack(Blocks.field_150478_aa));
        PandorasBoxHelper.addItems(10.0, Item.func_150898_a((Block)PBBlocks.pandorasBox));
        PandorasBoxHelper.addItems(10.0, Items.field_151076_bf, Items.field_151077_bg, Items.field_151082_bd, Items.field_151158_bO, Items.field_151083_be, Items.field_151009_A, Items.field_151078_bh, Items.field_151172_bF, Items.field_151147_al, Items.field_151157_am, Items.field_151034_e, Items.field_151105_aU, Items.field_151025_P, Items.field_151106_aX, Items.field_151115_aP, Items.field_179566_aV, Items.field_179561_bm, Items.field_179557_bn, Items.field_179558_bo, Items.field_179556_br, Items.field_179555_bs, Items.field_179560_bq, Items.field_179559_bp);
        PandorasBoxHelper.addItems(8.0, Items.field_151129_at, Items.field_151117_aB, Items.field_151131_as, Items.field_151033_d, Items.field_151159_an, Items.field_151162_bE, Items.field_151104_aV, Items.field_151124_az, Items.field_151143_au, Items.field_151066_bu);
        PandorasBoxHelper.addItems(8.0, Items.field_151057_cb);
        PandorasBoxHelper.addItems(6.0, Items.field_151042_j, Items.field_151114_aO, Items.field_151065_br, Items.field_151072_bj, Items.field_151113_aN, Items.field_151073_bk, Items.field_151061_bv, Items.field_151060_bw, Items.field_151070_bp, Items.field_151071_bq, Items.field_151064_bs, Items.field_151150_bK);
        PandorasBoxHelper.addItems(4.0, Items.field_151024_Q, Items.field_151027_R, Items.field_151026_S, Items.field_151021_T, Items.field_151041_m, Items.field_151039_o, Items.field_151038_n, Items.field_151053_p, Items.field_151017_I);
        PandorasBoxHelper.addItems(4.0, Items.field_151169_ag, Items.field_151171_ah, Items.field_151149_ai, Items.field_151151_aj, Items.field_151010_B, Items.field_151005_D, Items.field_151011_C, Items.field_151006_E, Items.field_151013_M);
        PandorasBoxHelper.addItems(4.0, Items.field_151028_Y, Items.field_151030_Z, Items.field_151165_aa, Items.field_151167_ab, Items.field_151040_l, Items.field_151035_b, Items.field_151037_a, Items.field_151036_c, Items.field_151019_K);
        PandorasBoxHelper.addItems(3.0, Items.field_151138_bX, Items.field_151136_bY);
        PandorasBoxHelper.addItems(2.0, Items.field_151125_bZ);
        PandorasBoxHelper.addItemsMinMax(2.0, 1, 1, new ItemStack((Block)Blocks.field_150461_bJ), new ItemStack(Blocks.field_150467_bQ), new ItemStack(Blocks.field_150382_bo), new ItemStack(Blocks.field_150367_z), new ItemStack(Blocks.field_150477_bB), new ItemStack(Blocks.field_150421_aI), new ItemStack(Blocks.field_150381_bn));
        PandorasBoxHelper.addItemsMinMax(5.0, 1, 1, new ItemStack((Block)Blocks.field_150486_ae));
        PandorasBoxHelper.addItems(2.0, Items.field_151045_i, Items.field_151166_bC, Items.field_151043_k, Items.field_151153_ao, Items.field_151079_bi, Items.field_179563_cD, Items.field_179562_cC);
        PandorasBoxHelper.addItems(2.0, Items.field_151161_ac, Items.field_151163_ad, Items.field_151173_ae, Items.field_151175_af, Items.field_151048_u, Items.field_151046_w, Items.field_151047_v, Items.field_151056_x, Items.field_151012_L);
        PandorasBoxHelper.addItems(2.0, Items.field_151086_cn, Items.field_151096_cd, Items.field_151094_cf, Items.field_151093_ce, Items.field_151091_cg, Items.field_151092_ch, Items.field_151089_ci, Items.field_151090_cj, Items.field_151087_ck, Items.field_151088_cl, Items.field_151084_co, Items.field_151085_cm);
        for (int i = 0; i < 16; ++i) {
            PandorasBoxHelper.addItems(10.0, new ItemStack(Items.field_151100_aR, 1, i));
        }
        PandorasBoxHelper.addEquipmentSet(10.0, Items.field_151024_Q, Items.field_151027_R, Items.field_151026_S, Items.field_151021_T, Items.field_151041_m, Items.field_151039_o, Items.field_151038_n, Items.field_151053_p, Items.field_151017_I);
        PandorasBoxHelper.addEquipmentSet(6.0, Items.field_151028_Y, Items.field_151030_Z, Items.field_151165_aa, Items.field_151167_ab, Items.field_151040_l, Items.field_151035_b, Items.field_151037_a, Items.field_151036_c, Items.field_151019_K);
        PandorasBoxHelper.addEquipmentSet(4.0, Items.field_151169_ag, Items.field_151171_ah, Items.field_151149_ai, Items.field_151151_aj, Items.field_151010_B, Items.field_151005_D, Items.field_151011_C, Items.field_151006_E, Items.field_151013_M);
        PandorasBoxHelper.addEquipmentSet(2.0, Items.field_151161_ac, Items.field_151163_ad, Items.field_151173_ae, Items.field_151175_af, Items.field_151048_u, Items.field_151046_w, Items.field_151047_v, Items.field_151056_x, Items.field_151012_L);
        PandorasBoxHelper.addEquipmentSet(6.0, Items.field_151031_f, new ItemStack(Items.field_151032_g, 64), Items.field_151028_Y, Items.field_151027_R, Items.field_151026_S, Items.field_151021_T, Items.field_151036_c, new ItemStack(Items.field_151034_e, 8));
        PandorasBoxHelper.addEquipmentSet(6.0, Items.field_151028_Y, Items.field_151027_R, Items.field_151026_S, Items.field_151021_T, Items.field_151046_w, Items.field_151037_a, Items.field_151036_c, Items.field_151052_q, new ItemStack(Items.field_151025_P, 8), new ItemStack(Blocks.field_150478_aa, 32));
        PandorasBoxHelper.addEquipmentSet(8.0, Items.field_151024_Q, Items.field_151019_K, new ItemStack(Items.field_151014_N, 32), new ItemStack(Items.field_151080_bb, 4), new ItemStack(Items.field_151081_bc, 4), new ItemStack(Items.field_151100_aR, 8, 15), new ItemStack(Blocks.field_150346_d, 32), Items.field_151131_as, Items.field_151131_as);
        PandorasBoxHelper.addEquipmentSet(6.0, Items.field_151028_Y, Items.field_151056_x, new ItemStack(Items.field_151082_bd, 16));
        PandorasBoxHelper.addEquipmentSet(6.0, new ItemStack(Items.field_151137_ax, 64), new ItemStack(Blocks.field_150325_L, 16, 0), new ItemStack(Blocks.field_150325_L, 16, 15), new ItemStack(Blocks.field_150325_L, 16, 1), new ItemStack(Blocks.field_150451_bX, 8), new ItemStack(Blocks.field_150429_aA, 8));
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.field_151041_m, Items.field_151041_m, Items.field_151010_B, Items.field_151052_q, Items.field_151040_l, Items.field_151048_u);
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.field_151053_p, Items.field_151053_p, Items.field_151006_E, Items.field_151049_t, Items.field_151036_c, Items.field_151056_x);
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.field_151039_o, Items.field_151039_o, Items.field_151005_D, Items.field_151050_s, Items.field_151035_b, Items.field_151046_w);
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.field_151038_n, Items.field_151038_n, Items.field_151011_C, Items.field_151051_r, Items.field_151037_a, Items.field_151047_v);
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.field_151017_I, Items.field_151017_I, Items.field_151013_M, Items.field_151018_J, Items.field_151019_K, Items.field_151012_L);
        PandorasBoxHelper.addPotions(buffs, 10.0, 0, 3, 1200, 12000, MobEffects.field_76428_l, MobEffects.field_76424_c, MobEffects.field_76420_g, MobEffects.field_76430_j, MobEffects.field_76429_m, MobEffects.field_76427_o, MobEffects.field_76426_n, MobEffects.field_76439_r, MobEffects.field_76441_p, MobEffects.field_76444_x);
        PandorasBoxHelper.addPotions(debuffs, 10.0, 0, 3, 1200, 12000, MobEffects.field_76440_q, MobEffects.field_76431_k, MobEffects.field_76419_f, MobEffects.field_76437_t, MobEffects.field_76438_s);
        PandorasBoxHelper.addPotions(debuffs, 10.0, 0, 2, 600, 1200, MobEffects.field_82731_v);
        PandorasBoxHelper.addEnchantableArmor(10.0, Items.field_151028_Y, Items.field_151169_ag, Items.field_151161_ac, Items.field_151030_Z, Items.field_151171_ah, Items.field_151163_ad, Items.field_151165_aa, Items.field_151149_ai, Items.field_151173_ae, Items.field_151167_ab, Items.field_151151_aj, Items.field_151175_af);
        PandorasBoxHelper.addEnchantableTools(10.0, Items.field_151040_l, Items.field_151010_B, Items.field_151048_u, Items.field_151037_a, Items.field_151011_C, Items.field_151047_v, Items.field_151035_b, Items.field_151005_D, Items.field_151046_w, Items.field_151036_c, Items.field_151006_E, Items.field_151056_x, Items.field_151031_f);
        PandorasBoxHelper.addBlocks(heavyBlocks, 10.0, Blocks.field_150467_bQ);
        PandorasBoxHelper.addAllRandomizableBlockProperties(new Block[]{Blocks.field_150348_b, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150325_L, Blocks.field_150406_ce, Blocks.field_150399_cn, Blocks.field_150397_co, Blocks.field_150376_bx, Blocks.field_150373_bw, Blocks.field_150333_U, Blocks.field_150334_T, Blocks.field_180389_cP, Blocks.field_180388_cO, Blocks.field_150344_f, Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150345_g, Blocks.field_150417_aV, Blocks.field_150390_bg, Blocks.field_150371_ca, Blocks.field_150370_cb, Blocks.field_150322_A, Blocks.field_150372_bz, Blocks.field_180395_cM, Blocks.field_180396_cN, Blocks.field_150448_aq, Blocks.field_150460_al, Blocks.field_150423_aK, Blocks.field_150428_aP, Blocks.field_150433_aE, Blocks.field_150431_aC, Blocks.field_150486_ae, Blocks.field_150477_bB, Blocks.field_150447_bR, Blocks.field_150457_bL, Blocks.field_150360_v});
    }

    public static int getRandomUnifiedSeed(Random random) {
        return Math.abs(random.nextInt());
    }

    private static <T> T randomElement(Collection<T> collection, Random random) {
        int num = random.nextInt(collection.size());
        int i = 0;
        for (T t : collection) {
            if (i++ != num) continue;
            return t;
        }
        throw new InternalError();
    }

    public static IBlockState getRandomBlockState(Random rand, Block block, int unified) {
        IBlockState state = block.func_176223_P();
        Collection randomizableProperties = randomizableBlockProperties.get((Object)block);
        if (randomizableProperties != null) {
            if (unified >= 0) {
                rand = new Random(unified ^ ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).hashCode());
            }
            for (IProperty property : randomizableProperties) {
                state = state.func_177226_a(property, (Comparable)PandorasBoxHelper.randomElement(property.func_177700_c(), rand));
            }
        }
        return state;
    }

    public static Block[] getRandomBlockList(Random rand, Collection<WeightedBlock> selection) {
        int number;
        for (number = 1; number < 10 && rand.nextFloat() < 0.7f; ++number) {
        }
        int[] weights = new int[number];
        for (int i = 0; i < number; ++i) {
            weights[i] = 1;
            while (weights[i] < 10 && rand.nextFloat() < 0.7f) {
                int n = i;
                weights[n] = weights[n] + 1;
            }
        }
        int total = 0;
        for (int i : weights) {
            total += i;
        }
        Block[] blocks = new Block[total];
        int blockIndex = 0;
        for (int i = 0; i < number; ++i) {
            Block block = ((WeightedBlock)WeightedSelector.selectItem((Random)rand, selection)).block;
            for (int j = 0; j < weights[i]; ++j) {
                blocks[blockIndex] = block;
                ++blockIndex;
            }
        }
        return blocks;
    }

    public static Block getRandomBlock(Random rand, Collection<WeightedBlock> randomBlockList) {
        if (randomBlockList != null && randomBlockList.size() > 0) {
            return ((WeightedBlock)WeightedSelector.selectItem((Random)rand, randomBlockList)).block;
        }
        return ((WeightedBlock)WeightedSelector.selectItem((Random)rand, PandorasBoxHelper.blocks)).block;
    }

    public static WeightedEntity[] getRandomEntityList(Random rand, Collection<WeightedEntity> selection) {
        WeightedEntity[] entities = new WeightedEntity[rand.nextInt(5) + 1];
        for (int i = 0; i < entities.length; ++i) {
            entities[i] = PandorasBoxHelper.getRandomEntityFromList(rand, selection);
        }
        return entities;
    }

    public static WeightedEntity getRandomEntityFromList(Random rand, Collection<WeightedEntity> entityList) {
        return (WeightedEntity)WeightedSelector.selectItem((Random)rand, entityList);
    }

    public static ItemStack getRandomWeaponItemForLevel(Random random, int level) {
        Set<Item> itemSet = equipmentForLevels.keySet();
        Item[] itemArray = itemSet.toArray(new Item[itemSet.size()]);
        return PandorasBoxHelper.getWeaponItemForLevel(itemArray[random.nextInt(itemArray.length)], level);
    }

    public static ItemStack getWeaponItemForLevel(Item baseItem, int level) {
        Hashtable<Integer, ItemStack> levels = equipmentForLevels.get(baseItem);
        if (levels != null) {
            while (level > 0) {
                if (levels.containsKey(level)) {
                    return levels.get(level);
                }
                --level;
            }
        }
        return null;
    }
}

