/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import ivorius.pandorasbox.PBConfig;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectMulti;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PBECRegistry {
    public static final int MAX_DELAY_IN_MULTIEFFECT = 60;
    private static final ArrayList<String> goodCreators = new ArrayList();
    private static final ArrayList<String> badCreators = new ArrayList();
    private static final Map<String, Float> fixedChanceCreators = new HashMap<String, Float>();
    private static final BiMap<String, PBEffectCreator> effectCreators = HashBiMap.create();

    public static void register(PBEffectCreator creator, String id, boolean good) {
        (good ? goodCreators : badCreators).add(id);
        effectCreators.put((Object)id, (Object)creator);
    }

    public static void register(PBEffectCreator creator, String id, float fixedChance) {
        fixedChanceCreators.put(id, Float.valueOf(fixedChance));
        effectCreators.put((Object)id, (Object)creator);
    }

    public static String getID(PBEffectCreator creator) {
        return (String)effectCreators.inverse().get((Object)creator);
    }

    public static PBEffectCreator effectCreatorWithName(String name) {
        return (PBEffectCreator)effectCreators.get((Object)name);
    }

    public static boolean hasEffect(String name) {
        return effectCreators.containsKey((Object)name);
    }

    public static boolean isEffectGood(String name) {
        return goodCreators.contains(name);
    }

    public static boolean isEffectBad(String name) {
        return badCreators.contains(name);
    }

    public static PBEffectCreator randomEffectCreatorOfType(Random random, boolean good) {
        ArrayList<String> list = good ? goodCreators : badCreators;
        return (PBEffectCreator)effectCreators.get((Object)list.get(random.nextInt(list.size())));
    }

    public static PBEffect createEffect(World world, Random random, double x, double y, double z, String name) {
        PBEffectCreator creator = PBECRegistry.effectCreatorWithName(name);
        if (creator != null) {
            return PBECRegistry.constructEffectSafe(creator, world, x, y, z, random);
        }
        return null;
    }

    public static PBEffect createRandomEffectOfType(World world, Random random, double x, double y, double z, boolean good) {
        PBEffectCreator creator = PBECRegistry.randomEffectCreatorOfType(random, good);
        if (creator != null) {
            return PBECRegistry.constructEffectSafe(creator, world, x, y, z, random);
        }
        return null;
    }

    public static PBEffect createRandomEffect(World world, Random random, double x, double y, double z, boolean multi) {
        float currentMinChance = 1.0f;
        ArrayList<PBEffect> effects = new ArrayList<PBEffect>();
        do {
            PBEffect effect;
            PBEffectCreator creator = null;
            for (String fixedChanceCreator : fixedChanceCreators.keySet()) {
                if (!(random.nextFloat() < fixedChanceCreators.get(fixedChanceCreator).floatValue())) continue;
                creator = (PBEffectCreator)effectCreators.get((Object)fixedChanceCreator);
                break;
            }
            if (creator == null) {
                creator = PBECRegistry.randomEffectCreatorOfType(random, (double)random.nextFloat() < PBConfig.goodEffectChance);
            }
            if ((effect = PBECRegistry.constructEffectSafe(creator, world, x, y, z, random)) != null) {
                effects.add(effect);
            }
            currentMinChance = Math.min(currentMinChance, creator.chanceForMoreEffects(world, x, y, z, random));
        } while ((double)random.nextFloat() < PBECRegistry.newEffectChance(currentMinChance) && effects.size() < PBConfig.maxEffectsPerBox && multi);
        if (effects.size() == 1) {
            return (PBEffect)effects.get(0);
        }
        PBEffect[] effectArray = effects.toArray(new PBEffect[effects.size()]);
        int[] delays = new int[effectArray.length];
        for (int i = 1; i < delays.length; ++i) {
            delays[i] = random.nextInt(60);
        }
        return new PBEffectMulti(effectArray, delays);
    }

    private static double newEffectChance(double effectFactor) {
        return Math.pow(effectFactor, 1.0 / PBConfig.boxIntensity);
    }

    public static PBEffect constructEffectSafe(PBEffectCreator creator, World world, double x, double y, double z, Random random) {
        try {
            return creator.constructEffect(world, x, y, z, random);
        }
        catch (Exception ex) {
            System.out.println("PBEC failed! '" + PBECRegistry.getID(creator) + "'");
            ex.printStackTrace();
            return null;
        }
    }

    public static EntityPandorasBox spawnPandorasBox(World world, Random random, boolean multi, Entity entity) {
        PBEffect effect = PBECRegistry.createRandomEffect(world, random, entity.field_70165_t, entity.field_70163_u + 1.2, entity.field_70161_v, multi);
        return PBECRegistry.spawnPandorasBox(world, effect, entity);
    }

    public static EntityPandorasBox spawnPandorasBox(World world, Random random, String id, Entity entity) {
        PBEffect effect = PBECRegistry.createEffect(world, random, entity.field_70165_t, entity.field_70163_u + 1.2, entity.field_70161_v, id);
        return PBECRegistry.spawnPandorasBox(world, effect, entity);
    }

    public static EntityPandorasBox spawnPandorasBox(World world, PBEffect effect, Entity entity) {
        if (effect != null) {
            EntityPandorasBox entityPandorasBox = new EntityPandorasBox(world, effect);
            Vec3d look = entity.func_70040_Z();
            double spawnX = entity.field_70165_t + look.field_72450_a * 0.5;
            double spawnY = entity.field_70163_u + 0.9 + look.field_72448_b * 0.5;
            double spawnZ = entity.field_70161_v + look.field_72449_c * 0.5;
            entityPandorasBox.func_70012_b(spawnX, spawnY, spawnZ, entity.field_70177_z + 180.0f, 0.0f);
            entityPandorasBox.beginFloatingAway();
            world.func_72838_d((Entity)entityPandorasBox);
            return entityPandorasBox;
        }
        return null;
    }

    public static Set<String> getAllIDs() {
        return effectCreators.keySet();
    }

    public static String[] getIDArray() {
        Set<String> allIDs = PBECRegistry.getAllIDs();
        return allIDs.toArray(new String[allIDs.size()]);
    }
}

