/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.pandorasbox.effectcreators.PBECSpawnEntities;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectSpawnItemStacks;
import ivorius.pandorasbox.random.DConstant;
import ivorius.pandorasbox.random.DLinear;
import ivorius.pandorasbox.random.IValue;
import ivorius.pandorasbox.random.PandorasBoxItemNamer;
import ivorius.pandorasbox.random.ValueSpawn;
import ivorius.pandorasbox.random.ValueThrow;
import ivorius.pandorasbox.utils.RandomizedItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class PBECSpawnItems
implements PBEffectCreator {
    public IValue number;
    public IValue ticksPerItem;
    public List<RandomizedItemStack> items;
    public ValueThrow valueThrow;
    public ValueSpawn valueSpawn;

    public PBECSpawnItems(IValue number, IValue ticksPerItem, List<RandomizedItemStack> items, ValueThrow valueThrow, ValueSpawn valueSpawn) {
        this.number = number;
        this.ticksPerItem = ticksPerItem;
        this.items = items;
        this.valueThrow = valueThrow;
        this.valueSpawn = valueSpawn;
    }

    public PBECSpawnItems(IValue number, IValue ticksPerItem, List<RandomizedItemStack> items) {
        this(number, ticksPerItem, items, PBECSpawnItems.defaultThrow(), null);
    }

    public static ValueThrow defaultThrow() {
        return new ValueThrow(new DLinear(0.05, 0.2), new DLinear(0.2, 1.0));
    }

    public static ValueSpawn defaultShowerSpawn() {
        return new ValueSpawn(new DLinear(5.0, 30.0), new DConstant(150.0));
    }

    @Override
    public PBEffect constructEffect(World world, double x, double y, double z, Random random) {
        int number = this.number.getValue(random);
        int ticksPerItem = this.ticksPerItem.getValue(random);
        ItemStack[] stacks = PBECSpawnItems.getItemStacks(random, this.items, number, random.nextInt(3) != 0, true, 0, false);
        return PBECSpawnItems.constructEffect(random, stacks, number * ticksPerItem + 1, this.valueThrow, this.valueSpawn);
    }

    public static PBEffect constructEffect(Random random, ItemStack[] stacks, int time, ValueThrow valueThrow, ValueSpawn valueSpawn) {
        boolean canThrow;
        boolean canSpawn = valueSpawn != null;
        boolean bl = canThrow = valueThrow != null;
        if (canThrow && (!canSpawn || random.nextBoolean())) {
            PBEffectSpawnItemStacks effect = new PBEffectSpawnItemStacks(time, stacks);
            PBECSpawnEntities.setEffectThrow(effect, random, valueThrow);
            return effect;
        }
        if (canSpawn) {
            PBEffectSpawnItemStacks effect = new PBEffectSpawnItemStacks(time, stacks);
            PBECSpawnEntities.setEffectSpawn(effect, random, valueSpawn);
            return effect;
        }
        throw new RuntimeException("Both spawnRange and throwStrength are null!");
    }

    public static ItemStack[] getItemStacks(Random random, List<RandomizedItemStack> items, int number, boolean split, boolean mixUp, int enchantLevel, boolean giveNames) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < number; ++i) {
            RandomizedItemStack wrcc = mixUp ? (RandomizedItemStack)WeightedSelector.selectItem((Random)random, items) : items.get(i);
            ItemStack stack = wrcc.itemStack.func_77946_l();
            stack.field_77994_a = wrcc.min + random.nextInt(wrcc.max - wrcc.min + 1);
            if (enchantLevel > 0) {
                List enchantments = EnchantmentHelper.func_77513_b((Random)random, (ItemStack)stack, (int)enchantLevel, (boolean)false);
                if (enchantments.size() == 0) {
                    enchantments = EnchantmentHelper.func_77513_b((Random)random, (ItemStack)new ItemStack(Items.field_151036_c), (int)enchantLevel, (boolean)false);
                }
                if (enchantments.size() > 0) {
                    for (Object enchantment : enchantments) {
                        EnchantmentData enchantmentdata = (EnchantmentData)enchantment;
                        if (stack.func_77973_b() == Items.field_151134_bR) {
                            Items.field_151134_bR.func_92115_a(stack, enchantmentdata);
                            continue;
                        }
                        stack.func_77966_a(enchantmentdata.field_76302_b, enchantmentdata.field_76303_c);
                    }
                }
            }
            if (giveNames) {
                stack.func_151001_c(PandorasBoxItemNamer.getRandomName(random));
            }
            if (split) {
                for (int n = 0; n < stack.field_77994_a; ++n) {
                    ItemStack splitStack = stack.func_77979_a(1);
                    list.add(splitStack);
                }
                continue;
            }
            list.add(stack);
        }
        return list.toArray(new ItemStack[list.size()]);
    }

    @Override
    public float chanceForMoreEffects(World world, double x, double y, double z, Random random) {
        return 0.1f;
    }
}

