/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.PBEffectRegistry;
import ivorius.pandorasbox.effects.PBEffectSpawnEntityIDList;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class PBEffect {
    public String getEffectID() {
        return PBEffectRegistry.getEffectID(this);
    }

    public static boolean setBlockToAirSafe(World world, BlockPos pos) {
        boolean safeDest = world.func_180495_p(pos) == Blocks.field_150350_a || world.func_180495_p(pos).func_185887_b(world, pos) >= 0.0f;
        return safeDest && world.func_175698_g(pos);
    }

    public static boolean setBlockSafe(World world, BlockPos pos, IBlockState state) {
        boolean safeDest = world.func_180495_p(pos) == Blocks.field_150350_a || world.func_180495_p(pos).func_185887_b(world, pos) >= 0.0f;
        boolean safeSrc = state.func_177230_c() == Blocks.field_150350_a || state.func_185887_b(world, pos) >= 0.0f;
        return safeDest && safeSrc && world.func_175656_a(pos, state);
    }

    public static boolean setBlockVarying(World world, BlockPos pos, Block block, int unified) {
        return PBEffect.setBlockSafe(world, pos, PandorasBoxHelper.getRandomBlockState(world.field_73012_v, block, unified));
    }

    public static EntityPlayer getRandomNearbyPlayer(World world, EntityPandorasBox box) {
        return (EntityPlayer)world.func_72857_a(EntityPlayer.class, box.func_174813_aQ().func_72314_b(30.0, 30.0, 30.0), (Entity)box);
    }

    public static EntityPlayer getPlayer(World world, EntityPandorasBox box) {
        return PBEffect.getRandomNearbyPlayer(world, box);
    }

    public static boolean isBlockAnyOf(Block block, Block ... blocks) {
        for (Block block1 : blocks) {
            if (block != block1) continue;
            return true;
        }
        return false;
    }

    public static Entity lazilySpawnEntity(World world, EntityPandorasBox box, Random random, String entityID, float chance, BlockPos pos) {
        Entity entity;
        if (random.nextFloat() < chance && (entity = PBEffectSpawnEntityIDList.createEntity(world, box, random, entityID, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5)) != null) {
            world.func_72838_d(entity);
            return entity;
        }
        return null;
    }

    public static boolean canSpawnEntity(World world, IBlockState block, BlockPos pos) {
        if (world.field_72995_K) {
            return false;
        }
        if (block.getLightOpacity((IBlockAccess)world, pos) > 0) {
            return false;
        }
        return world.func_175677_d(pos.func_177977_b(), false);
    }

    public boolean canSpawnFlyingEntity(World world, IBlockState block, BlockPos pos) {
        if (world.field_72995_K) {
            return false;
        }
        return block.getLightOpacity((IBlockAccess)world, pos) <= 0 && world.getBlockLightOpacity(pos.func_177977_b()) <= 0 && world.getBlockLightOpacity(pos.func_177979_c(2)) <= 0;
    }

    public void addPotionEffectDuration(EntityLivingBase entity, PotionEffect potionEffect) {
        if (entity.func_70687_e(potionEffect)) {
            PotionEffect prevEffect;
            boolean addNewEffect = true;
            if (entity.func_70644_a(potionEffect.func_188419_a()) && (prevEffect = entity.func_70660_b(potionEffect.func_188419_a())).func_76458_c() == potionEffect.func_76458_c()) {
                int duration = prevEffect.func_76459_b() + potionEffect.func_76459_b();
                PotionEffect combined = new PotionEffect(potionEffect.func_188419_a(), duration, potionEffect.func_76458_c(), potionEffect.func_82720_e(), potionEffect.func_188418_e());
                entity.func_70690_d(combined);
            }
            if (addNewEffect) {
                entity.func_70690_d(potionEffect);
            }
        }
    }

    public abstract void doTick(EntityPandorasBox var1, Vec3d var2, int var3);

    public abstract boolean isDone(EntityPandorasBox var1, int var2);

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract boolean canGenerateMoreEffectsAfterwards(EntityPandorasBox var1);
}

