/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectGenerateByStructure;
import ivorius.pandorasbox.effects.PBEffectSpawnEntityIDList;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class PBEffectGenTargets
extends PBEffectGenerateByStructure {
    public String entityToSpawn;
    public double range;
    public double targetSize;
    public double entityDensity;

    public PBEffectGenTargets() {
    }

    public PBEffectGenTargets(int maxTicksAlive, String entityToSpawn, double range, double targetSize, double entityDensity) {
        super(maxTicksAlive);
        this.entityToSpawn = entityToSpawn;
        this.range = range;
        this.targetSize = targetSize;
        this.entityDensity = entityDensity;
    }

    public void createTargets(World world, double x, double y, double z, Random random) {
        List players = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(x - this.range, y - this.range, z - this.range, x + this.range, y + this.range, z + this.range));
        this.structures = new PBEffectGenerateByStructure.Structure[players.size()];
        for (int i = 0; i < players.size(); ++i) {
            EntityPlayer player = (EntityPlayer)players.get(i);
            StructureTarget structureTarget = new StructureTarget();
            structureTarget.x = MathHelper.func_76128_c((double)player.field_70165_t);
            structureTarget.y = MathHelper.func_76128_c((double)(player.field_70163_u - 0.5));
            structureTarget.z = MathHelper.func_76128_c((double)player.field_70161_v);
            structureTarget.structureStart = random.nextFloat() * 0.3f;
            structureTarget.structureLength = 0.5f + random.nextFloat() * 0.2f;
            structureTarget.colors = new int[MathHelper.func_76143_f((double)this.targetSize)];
            for (int j = 0; j < structureTarget.colors.length; ++j) {
                structureTarget.colors[j] = random.nextInt(16);
            }
            this.structures[i] = structureTarget;
        }
    }

    @Override
    public void generateStructure(World world, EntityPandorasBox entity, Random random, PBEffectGenerateByStructure.Structure structure, BlockPos pos, float newRatio, float prevRatio) {
        if (!world.field_72995_K) {
            StructureTarget structureTarget = (StructureTarget)structure;
            double newRange = (double)newRatio * this.targetSize;
            double prevRange = (double)prevRatio * this.targetSize;
            int requiredRange = MathHelper.func_76143_f((double)newRange);
            for (int xP = -requiredRange; xP <= requiredRange; ++xP) {
                for (int zP = -requiredRange; zP <= requiredRange; ++zP) {
                    double dist = MathHelper.func_76133_a((double)(xP * xP + zP * zP));
                    if (dist < newRange && dist >= prevRange) {
                        PBEffectGenTargets.setBlockSafe(world, new BlockPos(structureTarget.x + xP, structureTarget.y, structureTarget.z + zP), Blocks.field_150406_ce.func_176203_a(structureTarget.colors[MathHelper.func_76128_c((double)dist)]));
                        double nextDist = MathHelper.func_76133_a((double)(xP * xP + 9 + (zP * zP + 9)));
                        if (nextDist >= this.targetSize && random.nextDouble() < this.entityDensity) {
                            Entity newEntity = PBEffectSpawnEntityIDList.createEntity(world, entity, random, this.entityToSpawn, (double)(structureTarget.x + xP) + 0.5, (double)structureTarget.y + 1.5, (double)(structureTarget.z + zP) + 0.5);
                            world.func_72838_d(newEntity);
                        }
                    }
                    for (int yP = 1; yP <= requiredRange; ++yP) {
                        double dist3D = MathHelper.func_76133_a((double)(xP * xP + zP * zP + yP * yP));
                        if (!(dist3D < newRange) || !(dist3D >= prevRange)) continue;
                        PBEffectGenTargets.setBlockToAirSafe(world, new BlockPos(structureTarget.x + xP, structureTarget.y, structureTarget.z + zP));
                    }
                }
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74778_a("entityToSpawn", this.entityToSpawn);
        compound.func_74780_a("range", this.range);
        compound.func_74780_a("targetSize", this.targetSize);
        compound.func_74780_a("entityDensity", this.entityDensity);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.entityToSpawn = compound.func_74779_i("entityToSpawn");
        this.range = compound.func_74769_h("range");
        this.targetSize = compound.func_74769_h("targetSize");
        this.entityDensity = compound.func_74769_h("entityDensity");
    }

    @Override
    public StructureTarget createStructure() {
        return new StructureTarget();
    }

    public static class StructureTarget
    extends PBEffectGenerateByStructure.Structure {
        public int[] colors;

        @Override
        public void writeToNBT(NBTTagCompound compound) {
            super.writeToNBT(compound);
            compound.func_74783_a("colors", this.colors);
        }

        @Override
        public void readFromNBT(NBTTagCompound compound) {
            super.readFromNBT(compound);
            this.colors = compound.func_74759_k("colors");
        }
    }
}

