/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectRangeBased;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class PBEffectGenerate2D
extends PBEffectRangeBased {
    public int unifiedSeed;

    public PBEffectGenerate2D() {
    }

    public PBEffectGenerate2D(int time, double range, int passes, int unifiedSeed) {
        super(time, range, passes);
        this.unifiedSeed = unifiedSeed;
    }

    @Override
    public void generateInRange(World world, EntityPandorasBox entity, Random random, Vec3d effectCenter, double prevRange, double newRange, int pass) {
        int requiredRange = MathHelper.func_76128_c((double)newRange);
        int baseX = MathHelper.func_76128_c((double)effectCenter.field_72450_a);
        int baseY = MathHelper.func_76128_c((double)effectCenter.field_72448_b);
        int baseZ = MathHelper.func_76128_c((double)effectCenter.field_72449_c);
        for (int x = -requiredRange; x <= requiredRange; ++x) {
            for (int z = -requiredRange; z <= requiredRange; ++z) {
                double dist = MathHelper.func_76133_a((double)(x * x + z * z));
                if (!(dist <= newRange)) continue;
                if (dist > prevRange) {
                    this.generateOnSurface(world, entity, effectCenter, random, new BlockPos(baseX + x, baseY, baseZ + z), dist, pass);
                    continue;
                }
                z = -z;
            }
        }
    }

    public abstract void generateOnSurface(World var1, EntityPandorasBox var2, Vec3d var3, Random var4, BlockPos var5, double var6, int var8);

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("unifiedSeed", this.unifiedSeed);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.unifiedSeed = compound.func_74762_e("unifiedSeed");
    }
}

