/*
 * Decompiled with CFR 0.152.
 */
package com.alxnns1.mobhunter.capability;

import com.alxnns1.mobhunter.capability.HunterRankProvider;
import com.alxnns1.mobhunter.capability.IHunterRank;
import com.alxnns1.mobhunter.message.MessageHunterRank;
import com.alxnns1.mobhunter.util.CommonUtil;
import com.alxnns1.mobhunter.util.LogHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class HunterRankDefault
implements IHunterRank {
    private float storedHR = 1.0f;

    @Override
    public float getHunterRank() {
        return this.storedHR;
    }

    @Override
    public void setHunterRank(EntityPlayer player, float hunterRank) {
        if (hunterRank < 1.0f) {
            LogHelper.warn("Tried to set the Hunter Rank to a value lower than 1!");
            return;
        }
        this.storedHR = hunterRank;
        this.dataChanged(player);
    }

    @Override
    public void changeHunterRankBy(EntityPlayer player, float amount) {
        this.storedHR += amount;
        if (this.storedHR < 1.0f) {
            this.storedHR = 1.0f;
        }
        this.dataChanged(player);
    }

    @Override
    public NBTTagFloat saveNBT() {
        return (NBTTagFloat)HunterRankStorage.hunterRankStorage.writeNBT(HunterRankProvider.HUNTER_RANK, this, null);
    }

    @Override
    public void loadNBT(NBTTagFloat tag) {
        HunterRankStorage.hunterRankStorage.readNBT(HunterRankProvider.HUNTER_RANK, this, null, (NBTBase)tag);
    }

    @Override
    public void dataChanged(EntityPlayer player) {
        if (player != null && player instanceof EntityPlayerMP) {
            CommonUtil.network.sendTo((IMessage)new MessageHunterRank(this.saveNBT()), (EntityPlayerMP)player);
        }
    }

    public static class HunterRankStorage
    implements Capability.IStorage<IHunterRank> {
        public static final HunterRankStorage hunterRankStorage = new HunterRankStorage();

        public NBTBase writeNBT(Capability<IHunterRank> capability, IHunterRank instance, EnumFacing side) {
            return new NBTTagFloat(((HunterRankDefault)instance).storedHR);
        }

        public void readNBT(Capability<IHunterRank> capability, IHunterRank instance, EnumFacing side, NBTBase nbt) {
            ((HunterRankDefault)instance).storedHR = ((NBTTagFloat)nbt).func_150288_h();
        }
    }
}

