/*
 * Decompiled with CFR 0.152.
 */
package com.alxnns1.mobhunter.crafting;

import com.alxnns1.mobhunter.crafting.WeaponUpgradeRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class WeaponUpgradeManager {
    private static final WeaponUpgradeManager instance = new WeaponUpgradeManager();
    private List<WeaponUpgradeRecipe> recipes = Lists.newArrayList();

    public static WeaponUpgradeManager getInstance() {
        return instance;
    }

    private WeaponUpgradeManager() {
    }

    private void addStack(ArrayList<ItemStack> stacks, ItemStack stack) {
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack s = stacks.get(i);
            if (!OreDictionary.itemMatches((ItemStack)s, (ItemStack)stack, (boolean)false)) continue;
            s.field_77994_a += stack.field_77994_a;
            return;
        }
        stacks.add(stack);
    }

    public void addRecipe(Item result, Item keyItem, Object ... recipeObj) {
        this.addRecipe(new ItemStack(result), new ItemStack(keyItem), recipeObj);
    }

    public void addRecipe(Item result, ItemStack keyItem, Object ... recipeObj) {
        this.addRecipe(new ItemStack(result), keyItem, recipeObj);
    }

    public void addRecipe(ItemStack result, Item keyItem, Object ... recipeObj) {
        this.addRecipe(result, new ItemStack(keyItem), recipeObj);
    }

    public void addRecipe(ItemStack result, ItemStack keyItem, Object ... recipeObj) {
        Object[] r = new Object[]{};
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < recipeObj.length; ++i) {
            Object o = recipeObj[i];
            if (o instanceof Item) {
                this.addStack(stacks, new ItemStack((Item)o));
                continue;
            }
            if (o instanceof Block) {
                this.addStack(stacks, new ItemStack((Block)o));
                continue;
            }
            if (o instanceof ItemStack) {
                this.addStack(stacks, (ItemStack)o);
                continue;
            }
            r = ArrayUtils.add((Object[])r, (Object)o);
        }
        r = ArrayUtils.addAll((Object[])r, (Object[])stacks.toArray());
        this.recipes.add(new WeaponUpgradeRecipe(result, keyItem, r));
    }

    public List<WeaponUpgradeRecipe> findMatchingRecipes(InventoryCrafting inv, InventoryPlayer invPlayer, World world) {
        ArrayList<WeaponUpgradeRecipe> r = new ArrayList<WeaponUpgradeRecipe>();
        for (int j = 0; j < this.recipes.size(); ++j) {
            WeaponUpgradeRecipe WURecipe = this.recipes.get(j);
            if (!WURecipe.func_77569_a(inv, world)) continue;
            r.add(WURecipe);
        }
        return r;
    }

    public List<WeaponUpgradeRecipe> getRecipeList() {
        return this.recipes;
    }
}

