/*
 * Decompiled with CFR 0.152.
 */
package com.alxnns1.mobhunter.entity;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public abstract class EntityMHHerbivore
extends EntityAnimal {
    private static final String KEY_SCALE = "scale";
    private static final DataParameter<Float> ENTITY_SCALE = EntityDataManager.func_187226_a(EntityMHHerbivore.class, (DataSerializer)DataSerializers.field_187193_c);
    private static float scaleMax;
    private static float scaleMin;
    private double baseHealth = 5.0;
    private double baseSpeed = 0.1;
    private double baseKnockback = 0.2;
    private Item breedItem;

    public EntityMHHerbivore(World world) {
        this(world, 1.0f, 1.0f, Items.field_151015_O);
    }

    public EntityMHHerbivore(World world, float minScale, float maxScale) {
        this(world, minScale, maxScale, Items.field_151015_O);
    }

    public EntityMHHerbivore(World world, float minScale, float maxScale, Item temptFood) {
        super(world);
        this.func_70105_a(0.9f, 1.3f);
        scaleMin = minScale;
        scaleMax = maxScale;
        this.breedItem = temptFood;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, temptFood, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ENTITY_SCALE, (Object)Float.valueOf(1.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack == null ? false : stack.func_77973_b() == this.breedItem;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        float scale = this.field_70146_Z.nextFloat() * (scaleMax - scaleMin) + scaleMin;
        this.setEntityScale(scale);
        return super.func_180482_a(difficulty, livingdata);
    }

    private void setEntityScale(float scale) {
        this.field_70180_af.func_187227_b(ENTITY_SCALE, (Object)Float.valueOf(scale));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Math.round(this.baseHealth * (double)scale));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.baseSpeed * (double)scale);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(this.baseKnockback * (double)scale);
        this.func_70606_j(this.func_110138_aP());
    }

    public float getScale() {
        return ((Float)this.field_70180_af.func_187225_a(ENTITY_SCALE)).floatValue();
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74776_a(KEY_SCALE, this.getScale());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setEntityScale(tagCompund.func_74760_g(KEY_SCALE));
    }

    protected void setBaseHealth(int health) {
        this.baseHealth = health;
    }

    protected void setBaseSpeed(double speed) {
        this.baseSpeed = speed;
    }

    protected void setBaseKnockback(double knockback) {
        this.baseKnockback = knockback;
    }
}

