/*
 * Decompiled with CFR 0.152.
 */
package com.alxnns1.mobhunter.handler;

import com.alxnns1.mobhunter.entity.EntityGreatJaggi;
import com.alxnns1.mobhunter.entity.EntityMHBirdWyvern;
import com.alxnns1.mobhunter.entity.EntityMHHerbivore;
import com.alxnns1.mobhunter.entity.EntityMHNeopteron;
import com.alxnns1.mobhunter.init.MHAchievements;
import com.alxnns1.mobhunter.item.ItemMHShield;
import com.alxnns1.mobhunter.item.ItemMHSword;
import com.alxnns1.mobhunter.util.CommonUtil;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class EntityEventHandler {
    public static final String ALL_WILDCARD = "/*";
    public static final String ALL_VANILLA_WILDCARD = "/*v";
    public static final String AGGRESSIVE_WILDCARD = "/a";
    public static final String PASSIVE_WILDCARD = "/p";
    private static final String[] PASSIVE_NAMES = new String[]{"MushroomCow", "Villager", "VillagerGolem", "SnowMan", "Pig", "Sheep", "Cow", "Chicken", "Squid", "Wolf", "Ocelot", "Cat", "Bat", "EntityHorse", "horse", "donkey", "mule", "skeletonhorse", "zombiehorse", "Rabbit"};
    private static final String[] AGGRESIVE_NAMES = new String[]{"Creeper", "Skeleton", "Spider", "Giant", "Zombie", "Slime", "Ghast", "PigZombie", "Enderman", "Endermite", "Silverfish", "CaveSpider", "Blaze", "LavaSlime", "EnderDragon", "WitherBoss", "Witch", "Guardian", "KillerBunny", "Shulker"};
    private static ArrayList<Object[]> mobDrops = new ArrayList();

    private static boolean checkMobName(boolean isAggressive, String name) {
        String[] N = isAggressive ? AGGRESIVE_NAMES : PASSIVE_NAMES;
        for (String n : N) {
            if (!name.equals(n)) continue;
            return true;
        }
        return false;
    }

    public static void addMobDrop(String mobName, ItemStack item, float chance) {
        EntityEventHandler.addMobDrop(mobName, item, 1, 1, chance);
    }

    public static void addMobDrop(String mobName, ItemStack item, int qtyMin, int qtyMax, float chance) {
        if (chance <= 0.0f) {
            chance = 0.01f;
        } else if (chance > 1.0f) {
            chance = 1.0f;
        }
        if (qtyMin > qtyMax) {
            int temp = qtyMin;
            qtyMin = qtyMax;
            qtyMax = temp;
        } else if (qtyMin == 0 && qtyMax == 0) {
            qtyMax = 1;
        }
        mobDrops.add(new Object[]{mobName, item, qtyMin, qtyMax, Float.valueOf(chance)});
    }

    @SubscribeEvent
    public void mobDeath(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        Random rand = new Random();
        for (Object[] o : mobDrops) {
            String s = EntityList.func_75621_b((Entity)entity);
            if (s == null) {
                s = "generic";
            }
            String mobUnlocName = "entity." + s + ".name";
            String mobName = new TextComponentTranslation(mobUnlocName, new Object[0]).func_150260_c();
            if (!(rand.nextFloat() < ((Float)o[4]).floatValue()) || !(o[0].equals(PASSIVE_WILDCARD) && EntityEventHandler.checkMobName(false, s) || o[0].equals(AGGRESSIVE_WILDCARD) && EntityEventHandler.checkMobName(true, s) || o[0].equals(ALL_VANILLA_WILDCARD) && (EntityEventHandler.checkMobName(false, s) || EntityEventHandler.checkMobName(true, s)) || o[0].equals(ALL_WILDCARD) && entity instanceof EntityLiving || mobName.equals(o[0])) && !mobUnlocName.equals(o[0])) continue;
            int min = (Integer)o[2];
            int max = (Integer)o[3];
            int randQty = rand.nextInt(max) + min;
            if (randQty <= 0) continue;
            event.getEntityLiving().func_70099_a((ItemStack)o[1], 0.0f);
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        Item item = event.crafting.func_77973_b();
        EntityPlayer player = event.player;
        if (item instanceof ItemMHSword) {
            player.func_71029_a((StatBase)MHAchievements.firstSword);
        }
    }

    @SubscribeEvent
    public void entityKilled(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        float scale = -1.0f;
        if (entity instanceof EntityGreatJaggi) {
            scale = ((EntityGreatJaggi)entity).getScale() * 1.5f;
        } else if (entity instanceof EntityMHBirdWyvern) {
            scale = ((EntityMHBirdWyvern)entity).getScale();
        } else if (entity instanceof EntityMHHerbivore) {
            scale = ((EntityMHHerbivore)entity).getScale();
        } else if (entity instanceof EntityMHNeopteron) {
            scale = ((EntityMHNeopteron)entity).getScale();
        }
        if (event.getSource() instanceof EntityDamageSource && event.getSource().func_76364_f() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            if (scale != -1.0f) {
                if (scale < 0.84f) {
                    player.func_71029_a((StatBase)MHAchievements.smallCrown);
                } else if (scale > 1.19f) {
                    player.func_71029_a((StatBase)MHAchievements.largeCrown);
                }
            }
            if (entity instanceof EntityGreatJaggi) {
                player.func_71029_a((StatBase)MHAchievements.greatJaggi);
            }
        }
    }

    @SubscribeEvent
    public void entityHurt(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        ItemStack activeStack = entity.func_184607_cu();
        if (entity instanceof EntityPlayer && activeStack != null && activeStack.func_77973_b() instanceof ItemMHShield && CommonUtil.canBlockDamageSource(entity, event.getSource()) && event.getAmount() >= 0.0f) {
            EntityPlayer player = (EntityPlayer)entity;
            int i = 1 + MathHelper.func_76141_d((float)event.getAmount());
            activeStack.func_77972_a(i, (EntityLivingBase)player);
            if (activeStack.field_77994_a <= 0) {
                EnumHand enumhand = player.func_184600_cs();
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)activeStack, (EnumHand)enumhand);
                if (enumhand == EnumHand.MAIN_HAND) {
                    player.func_184201_a(EntityEquipmentSlot.MAINHAND, null);
                } else {
                    player.func_184201_a(EntityEquipmentSlot.OFFHAND, null);
                }
                player.func_184602_cy();
                player.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }
}

