/*
 * Decompiled with CFR 0.152.
 */
package com.alxnns1.mobhunter.item;

import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public enum EnumSharpness {
    RED(0, TextFormatting.RED, "sharpness.red.name", 0.5f, 0.25f),
    ORANGE(1, TextFormatting.GOLD, "sharpness.orange.name", 0.75f, 0.5f),
    YELLOW(2, TextFormatting.YELLOW, "sharpness.yellow.name", 1.0f, 0.75f),
    GREEN(3, TextFormatting.GREEN, "sharpness.green.name", 1.05f, 1.0f),
    BLUE(4, TextFormatting.BLUE, "sharpness.blue.name", 1.2f, 1.0625f),
    WHITE(5, TextFormatting.WHITE, "sharpness.white.name", 1.32f, 1.125f),
    PURPLE(6, TextFormatting.LIGHT_PURPLE, "sharpness.purple.name", 1.45f, 1.2f);

    private static final EnumSharpness[] allValues;
    private final int id;
    private final TextFormatting colour;
    private final String name;
    private final float damage;
    private final float element;

    private EnumSharpness(int id, TextFormatting chatColour, String unlocalisedName, float damageMult, float elementMult) {
        this.id = id;
        this.colour = chatColour;
        this.name = unlocalisedName;
        this.damage = damageMult;
        this.element = elementMult;
    }

    public static boolean isSame(EnumSharpness sharpness1, EnumSharpness sharpness2) {
        return sharpness1.id == sharpness2.id;
    }

    public static EnumSharpness getById(int id) {
        if (id > allValues.length - 1 || id < 0) {
            return null;
        }
        return allValues[id];
    }

    public int getId() {
        return this.id;
    }

    public EnumSharpness getNextSharpness() {
        return this.getNextSharpness(1);
    }

    public EnumSharpness getNextSharpness(int i) {
        if (i < 1) {
            return this;
        }
        if (this.id + i > allValues.length - 1) {
            return allValues[allValues.length - 1];
        }
        return allValues[this.id + i];
    }

    public EnumSharpness getPrevSharpness() {
        return this.getPrevSharpness(1);
    }

    public EnumSharpness getPrevSharpness(int i) {
        if (i < 1) {
            return this;
        }
        if (this.id - i < 0) {
            return allValues[0];
        }
        return allValues[this.id - i];
    }

    public TextFormatting getChatColour() {
        return this.colour;
    }

    public String getUnlocalizedName() {
        return this.name;
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.name, (Object[])new Object[0]);
    }

    public float getDamageMult() {
        return this.damage;
    }

    public float getElementalMult() {
        return this.element;
    }

    static {
        allValues = new EnumSharpness[EnumSharpness.values().length];
        EnumSharpness[] enumSharpnessArray = EnumSharpness.values();
        int n = enumSharpnessArray.length;
        for (int i = 0; i < n; ++i) {
            EnumSharpness es;
            EnumSharpness.allValues[es.id] = es = enumSharpnessArray[i];
        }
    }
}

