/*
 * Decompiled with CFR 0.152.
 */
package com.alxnns1.mobhunter.item;

import com.alxnns1.mobhunter.MobHunter;
import com.alxnns1.mobhunter.init.MHItems;
import com.alxnns1.mobhunter.item.EnumSharpness;
import com.alxnns1.mobhunter.util.CommonUtil;
import com.alxnns1.mobhunter.util.LogHelper;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMHSword
extends ItemSword {
    private final EnumSharpness maxSharpness;
    private final int[] damageLevels;
    private final String damageLevelsString;
    private int nextSharpen = 200;

    public ItemMHSword(String itemName, float damage) {
        super(EnumHelper.addToolMaterial((String)(itemName + "Mat"), (int)0, (int)1, (float)0.0f, (float)(damage - 1.0f), (int)0).setRepairItem(new ItemStack((Item)MHItems.itemWhetstone)));
        this.func_77637_a(MobHunter.MH_TAB);
        this.func_77655_b(itemName);
        this.setRegistryName(itemName);
        LogHelper.warn("Sword " + this.func_77658_a() + " has not been set any sharpness levels!");
        this.maxSharpness = EnumSharpness.RED;
        this.damageLevels = new int[]{1};
        this.damageLevelsString = "No sharpness levels set for this weapon!";
    }

    public ItemMHSword(String itemName, float damage, int ... sharpnessDamageLevels) {
        super(EnumHelper.addToolMaterial((String)(itemName + "Mat"), (int)0, (int)sharpnessDamageLevels[sharpnessDamageLevels.length - 1], (float)0.0f, (float)(damage - 1.0f), (int)0).setRepairItem(new ItemStack((Item)MHItems.itemWhetstone)));
        this.func_77637_a(MobHunter.MH_TAB);
        this.func_77655_b(itemName);
        this.setRegistryName(itemName);
        this.maxSharpness = EnumSharpness.getById(sharpnessDamageLevels.length - 1);
        if (this.maxSharpness == null) {
            LogHelper.warn("Sword " + this.func_77658_a() + " has a null sharpness! Something must be wrong!");
        }
        this.damageLevels = sharpnessDamageLevels;
        String levels = "";
        for (int i = 0; i < this.damageLevels.length; ++i) {
            levels = levels + this.damageLevels[i];
            if (i >= this.damageLevels.length - 1) continue;
            levels = levels + " <- ";
        }
        this.damageLevelsString = levels;
    }

    public EnumSharpness getSharpness(ItemStack stack) {
        if (this.damageLevels != null) {
            for (int i = 0; i < this.damageLevels.length; ++i) {
                if (stack.func_77958_k() - stack.func_77952_i() >= this.damageLevels[i]) continue;
                return EnumSharpness.getById(i);
            }
            return this.maxSharpness;
        }
        return EnumSharpness.RED;
    }

    public float getActualAttackDamage(ItemStack stack) {
        EnumSharpness currentSharpness = this.getSharpness(stack);
        return this.func_150931_i() * currentSharpness.getDamageMult();
    }

    public void repairSharpness(ItemStack stack, int amount) {
        if (stack.func_77952_i() < amount) {
            stack.func_77964_b(0);
        } else {
            stack.func_77964_b(stack.func_77952_i() - amount);
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.func_111205_h(slot);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.removeAll((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getActualAttackDamage(stack), 0));
        }
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (!(attacker instanceof EntityPlayer) || !((EntityPlayer)attacker).field_71075_bZ.field_75098_d) {
            stack.func_77972_a(1, attacker);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        EnumSharpness currentSharpness = this.getSharpness(stack);
        if (currentSharpness != null) {
            tooltip.add(I18n.func_135052_a((String)"item.sharpness", (Object[])new Object[0]) + " " + currentSharpness.getChatColour() + new TextComponentTranslation(currentSharpness.getUnlocalizedName(), new Object[0]).func_150260_c());
            tooltip.add(I18n.func_135052_a((String)"item.maxSharpness", (Object[])new Object[0]) + " " + this.maxSharpness.getChatColour() + new TextComponentTranslation(this.maxSharpness.getUnlocalizedName(), new Object[0]).func_150260_c());
            if (playerIn.func_184812_l_()) {
                tooltip.add(this.damageLevelsString);
            }
        }
        CommonUtil.addTooltip(stack, tooltip);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.EAT;
    }

    public int func_77626_a(ItemStack stack) {
        return 200;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (playerIn.func_70093_af() && itemStackIn.func_77952_i() > 0 && playerIn.field_71071_by.func_70431_c(new ItemStack((Item)MHItems.itemWhetstone))) {
            this.nextSharpen = 200;
            playerIn.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            this.repairSharpness(stack, this.nextSharpen);
            if (this.nextSharpen == 200) {
                ((EntityPlayer)entityLiving).field_71071_by.func_174925_a((Item)MHItems.itemWhetstone, -1, 1, null);
            } else if (this.nextSharpen == 100) {
                ((EntityPlayer)entityLiving).field_71071_by.func_174925_a((Item)MHItems.itemMiniWhetstone, -1, 1, null);
            }
        }
        return stack;
    }
}

