/*
 * Decompiled with CFR 0.152.
 */
package com.alxnns1.mobhunter.tileentity;

import com.alxnns1.mobhunter.init.MHItems;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;

public class TileBbq
extends TileEntity
implements ITickable {
    private int cookTime = 0;
    private int rotationAngles = 64;
    private int RARE_TIME = 120;
    private int DONE_TIME = 180;
    private int BURN_TIME = 200;
    private boolean isCooking = false;
    private String KEY_TIME = "cookTime";
    private String KEY_COOKING = "cooking";

    public boolean isCooking() {
        return this.isCooking;
    }

    public boolean putRawMeat() {
        if (!this.isCooking) {
            this.isCooking = true;
            return true;
        }
        return false;
    }

    public Item getMeat() {
        if (!this.isCooking) {
            return null;
        }
        if (this.cookTime < this.RARE_TIME) {
            return MHItems.itemRawMeat;
        }
        if (this.cookTime < this.DONE_TIME) {
            return MHItems.itemRareSteak;
        }
        if (this.cookTime < this.BURN_TIME) {
            return MHItems.itemDoneSteak;
        }
        return MHItems.itemBurntMeat;
    }

    public int getCookingStage() {
        Item item = this.getMeat();
        if (item == null || item.equals((Object)MHItems.itemRawMeat)) {
            return 0;
        }
        if (item.equals((Object)MHItems.itemRareSteak)) {
            return 1;
        }
        if (item.equals((Object)MHItems.itemDoneSteak)) {
            return 2;
        }
        if (item.equals((Object)MHItems.itemBurntMeat)) {
            return 3;
        }
        return 0;
    }

    public float getMeatRotation() {
        return (float)this.cookTime % (float)this.rotationAngles / (float)this.rotationAngles * 360.0f;
    }

    public Item retrieveItem() {
        Item product = this.getMeat();
        this.isCooking = false;
        this.cookTime = 0;
        return product;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.isCooking = tag.func_74767_n(this.KEY_COOKING);
        this.cookTime = tag.func_74762_e(this.KEY_TIME);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a(this.KEY_COOKING, this.isCooking);
        tag.func_74768_a(this.KEY_TIME, this.cookTime);
        return tag;
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_73660_a() {
        if (this.isCooking) {
            ++this.cookTime;
        }
    }
}

