/*
 * Decompiled with CFR 0.152.
 */
package com.alxnns1.mobhunter.worldgen;

import com.alxnns1.mobhunter.init.MHBlocks;
import com.alxnns1.mobhunter.worldgen.MHPlantGen;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenHandler
implements IWorldGenerator {
    private WorldGenMinable oreEarthCrystal = new WorldGenMinable(MHBlocks.blockOreEarthCrystal.func_176223_P(), 10);
    private WorldGenMinable oreMachalite = new WorldGenMinable(MHBlocks.blockOreMachalite.func_176223_P(), 8);
    private WorldGenMinable oreDragonite = new WorldGenMinable(MHBlocks.blockOreDragonite.func_176223_P(), 6);
    private WorldGenMinable oreLightCrystal = new WorldGenMinable(MHBlocks.blockOreLightCrystal.func_176223_P(), 5);
    private WorldGenMinable oreIceCrystal = new WorldGenMinable(MHBlocks.blockOreIceCrystal.func_176223_P(), 10);
    private WorldGenMinable oreGossamite = new WorldGenMinable(MHBlocks.blockOreGossamite.func_176223_P(), 4);
    private MHPlantGen bushHerb = new MHPlantGen(MHBlocks.blockHerb);
    private MHPlantGen bushShroom = new MHPlantGen(MHBlocks.blockShroom);
    private MHPlantGen bushBerry = new MHPlantGen(MHBlocks.blockBerry);
    private MHPlantGen bushBug = new MHPlantGen(MHBlocks.blockBug);
    private MHPlantGen bushBone = new MHPlantGen(MHBlocks.blockBone);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                this.genNether(world, random, chunkX, chunkZ);
                break;
            }
            case 1: {
                this.genEnd(world, random, chunkX, chunkZ);
                break;
            }
            default: {
                this.genOverworld(world, random, chunkX, chunkZ);
            }
        }
    }

    private BlockPos getRandXZInChunk(Random random, int chunkX, int chunkZ) {
        return this.getRandXZInChunk(random, chunkX, 0, chunkZ);
    }

    private BlockPos getRandXZInChunk(Random random, int chunkX, int y, int chunkZ) {
        return new BlockPos(chunkX * 16 + random.nextInt(16), y, chunkZ * 16 + random.nextInt(16));
    }

    private void genOverworld(World world, Random random, int chunkX, int chunkZ) {
        this.genOre(world, random, chunkX, chunkZ, 16, this.oreEarthCrystal, 0, 128);
        this.genOre(world, random, chunkX, chunkZ, 12, this.oreMachalite, 0, 64);
        this.genOre(world, random, chunkX, chunkZ, 8, this.oreDragonite, 0, 64);
        this.genOre(world, random, chunkX, chunkZ, 8, this.oreLightCrystal, 96, 160);
        this.genOre(world, random, chunkX, chunkZ, 16, this.oreIceCrystal, 0, 64, BiomeDictionary.Type.COLD);
        this.genOre(world, random, chunkX, chunkZ, 8, this.oreGossamite, 96, 160);
        this.bushHerb.func_180709_b(world, random, world.func_175645_m(this.getRandXZInChunk(random, chunkX, chunkZ)));
        this.bushShroom.func_180709_b(world, random, world.func_175645_m(this.getRandXZInChunk(random, chunkX, chunkZ)));
        this.bushBerry.func_180709_b(world, random, world.func_175645_m(this.getRandXZInChunk(random, chunkX, chunkZ)));
        this.bushBug.func_180709_b(world, random, world.func_175645_m(this.getRandXZInChunk(random, chunkX, chunkZ)));
        this.bushBone.func_180709_b(world, random, world.func_175645_m(this.getRandXZInChunk(random, chunkX, chunkZ)));
    }

    private void genNether(World world, Random random, int chunkX, int chunkZ) {
        this.bushHerb.func_180709_b(world, random, this.getRandXZInChunk(random, chunkX, random.nextInt(128), chunkZ));
        this.bushShroom.func_180709_b(world, random, this.getRandXZInChunk(random, chunkX, random.nextInt(128), chunkZ));
        this.bushBerry.func_180709_b(world, random, this.getRandXZInChunk(random, chunkX, random.nextInt(128), chunkZ));
        this.bushBug.func_180709_b(world, random, this.getRandXZInChunk(random, chunkX, random.nextInt(128), chunkZ));
        this.bushBone.func_180709_b(world, random, this.getRandXZInChunk(random, chunkX, random.nextInt(128), chunkZ));
    }

    private void genEnd(World world, Random random, int chunkX, int chunkZ) {
    }

    private void genOre(World world, Random random, int chunkX, int chunkZ, int genCount, WorldGenMinable generator, int minHeight, int maxHeight) {
        int i;
        if (maxHeight < minHeight) {
            i = minHeight;
            minHeight = maxHeight;
            maxHeight = i;
        } else if (maxHeight == minHeight) {
            if (minHeight < 255) {
                ++maxHeight;
            } else {
                --minHeight;
            }
        }
        for (i = 0; i < genCount; ++i) {
            BlockPos pos = this.getRandXZInChunk(random, chunkX, random.nextInt(maxHeight - minHeight) + minHeight, chunkZ);
            generator.func_180709_b(world, random, pos);
        }
    }

    private void genOre(World world, Random random, int chunkX, int chunkZ, int genCount, WorldGenMinable generator, int minHeight, int maxHeight, BiomeDictionary.Type ... biomes) {
        int i;
        if (maxHeight < minHeight) {
            i = minHeight;
            minHeight = maxHeight;
            maxHeight = i;
        } else if (maxHeight == minHeight) {
            if (minHeight < 255) {
                ++maxHeight;
            } else {
                --minHeight;
            }
        }
        for (i = 0; i < genCount; ++i) {
            BlockPos pos = this.getRandXZInChunk(random, chunkX, random.nextInt(maxHeight - minHeight) + minHeight, chunkZ);
            for (BiomeDictionary.Type biome : biomes) {
                if (!BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(pos), (BiomeDictionary.Type)biome)) continue;
                generator.func_180709_b(world, random, pos);
            }
        }
    }
}

