/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.launcher.process.JavaProcess;
import net.minecraft.launcher.process.JavaProcessListener;

class ProcessMonitorThread
extends Thread {
    private final JavaProcess process;

    public ProcessMonitorThread(JavaProcess process) {
        this.process = process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Process raw = this.process.getRawProcess();
        InputStreamReader reader = new InputStreamReader(raw.getInputStream());
        BufferedReader buf = new BufferedReader(reader);
        String line = null;
        JavaProcessListener listener = this.process.getExitRunnable();
        while (this.process.isRunning()) {
            try {
                while ((line = buf.readLine()) != null) {
                    if (listener != null) {
                        listener.onJavaProcessLog(this.process, line);
                    }
                    this.process.getSysOutLines().add(line);
                }
            }
            catch (IOException var14) {}
            continue;
            finally {
                try {
                    buf.close();
                }
                catch (IOException var14) {
                    Logger.getLogger(ProcessMonitorThread.class.getName()).log(Level.SEVERE, (String)null, var14);
                }
            }
        }
        if (listener != null) {
            listener.onJavaProcessEnded(this.process);
        }
    }
}

