/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.accounts;

import java.awt.Component;
import java.net.URL;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.ui.center.CenterPanel;
import ru.turikhay.tlauncher.ui.images.ImageCache;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.scenes.AccountEditorScene;
import ru.turikhay.tlauncher.ui.swing.editor.EditorPane;
import ru.turikhay.util.OS;

public class AccountTip
extends CenterPanel
implements LocalizableComponent {
    public static final int WIDTH = 510;
    private final AccountEditorScene scene;
    public final Tip freeTip;
    public final Tip mojangTip;
    public final Tip elyTip;
    private Tip tip;
    private final EditorPane content;

    public AccountTip(AccountEditorScene sc) {
        super(smallSquareInsets);
        this.scene = sc;
        this.content = new EditorPane();
        this.add((Component)this.content);
        this.freeTip = new Tip(Account.AccountType.FREE, null);
        this.mojangTip = new Tip(Account.AccountType.MOJANG, ImageCache.getRes("mojang-user.png"));
        this.elyTip = new Tip(Account.AccountType.ELY, ImageCache.getRes("ely.png"));
        this.setTip(null);
    }

    public void setAccountType(Account.AccountType type) {
        if (type != null) {
            switch (SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$minecraft$auth$Account$AccountType[type.ordinal()]) {
                case 1: {
                    this.setTip(this.elyTip);
                    return;
                }
                case 2: {
                    this.setTip(this.freeTip);
                    return;
                }
                case 3: {
                    this.setTip(this.mojangTip);
                    return;
                }
            }
        }
        this.setTip(null);
    }

    public Tip getTip() {
        return this.tip;
    }

    public void setTip(Tip tip) {
        this.tip = tip;
        if (tip == null) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
            StringBuilder builder = new StringBuilder();
            builder.append("<table width=\"").append(510 - this.getInsets().left - this.getInsets().right).append("\" height=\"").append(tip.getHeight()).append("\"><tr><td align=\"center\" valign=\"center\">");
            if (tip.image != null) {
                builder.append("<img src=\"").append(tip.image).append("\" /></td><td align=\"center\" valign=\"center\" width=\"100%\">");
            }
            builder.append(Localizable.get(tip.path));
            builder.append("</td></tr></table>");
            this.setContent(builder.toString(), 510, tip.getHeight());
        }
    }

    void setContent(String text, int width, int height) {
        if (width >= 1 && height >= 1) {
            this.content.setText(text);
            if (OS.CURRENT == OS.LINUX) {
                width = (int)((double)width * 1.2);
                height = (int)((double)height * 1.2);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.setSize(width, height + this.getInsets().top + this.getInsets().bottom);
    }

    @Override
    public void updateLocale() {
        this.setTip(this.tip);
    }

    public class Tip {
        private final Account.AccountType type;
        private final String path;
        private final URL image;

        Tip(Account.AccountType type, URL image) {
            this.type = type;
            this.path = "auth.tip." + (Object)((Object)type);
            this.image = image;
        }

        public int getHeight() {
            return AccountTip.this.tlauncher.getLang().getInteger(this.path + ".height");
        }
    }

    static class SyntheticClass_1 {
        static final int[] $SwitchMap$ru$turikhay$tlauncher$minecraft$auth$Account$AccountType = new int[Account.AccountType.values().length];

        SyntheticClass_1() {
        }

        static {
            try {
                SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$minecraft$auth$Account$AccountType[Account.AccountType.ELY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$minecraft$auth$Account$AccountType[Account.AccountType.FREE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$minecraft$auth$Account$AccountType[Account.AccountType.MOJANG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

