/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.listener;

import java.net.URI;
import java.net.URISyntaxException;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.updater.Update;
import ru.turikhay.tlauncher.updater.UpdateListener;
import ru.turikhay.util.OS;

public class UpdateUIListener
implements UpdateListener {
    private final TLauncher t;
    private final Update u;

    public UpdateUIListener(Update u) {
        if (u == null) {
            throw new NullPointerException();
        }
        this.t = TLauncher.getInstance();
        this.u = u;
        u.addListener(this);
    }

    public void push() {
        this.block();
        this.u.download(true);
    }

    @Override
    public void onUpdateError(Update u, Throwable e) {
        if (Alert.showLocQuestion("updater.error.title", "updater.download-error", e)) {
            UpdateUIListener.openUpdateLink(u.getLink());
        }
        this.unblock();
    }

    @Override
    public void onUpdateDownloading(Update u) {
    }

    @Override
    public void onUpdateDownloadError(Update u, Throwable e) {
        this.onUpdateError(u, e);
    }

    @Override
    public void onUpdateReady(Update u) {
        UpdateUIListener.onUpdateReady(u, false);
    }

    private static void onUpdateReady(Update u, boolean showChangeLog) {
        Alert.showLocWarning("updater.downloaded", (Object)(showChangeLog ? u.getDescription() : null));
        u.apply();
    }

    @Override
    public void onUpdateApplying(Update u) {
    }

    @Override
    public void onUpdateApplyError(Update u, Throwable e) {
        if (Alert.showLocQuestion("updater.save-error", e)) {
            UpdateUIListener.openUpdateLink(u.getLink());
        }
        this.unblock();
    }

    public static boolean openUpdateLink(String link) {
        try {
            if (OS.openLink(new URI(link), false)) {
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Alert.showLocError("updater.found.cannotopen", link);
        return false;
    }

    private void block() {
        Blocker.block(this.t.getFrame().mp, "updater");
    }

    private void unblock() {
        Blocker.unblock(this.t.getFrame().mp, "updater");
    }
}

