/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.login;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import ru.turikhay.tlauncher.managers.ProfileManager;
import ru.turikhay.tlauncher.managers.ProfileManagerListener;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.minecraft.auth.Authenticator;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorDatabase;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorListener;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.listener.AuthUIListener;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.login.LoginException;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.tlauncher.ui.login.LoginWaitException;
import ru.turikhay.tlauncher.ui.login.VersionComboBox;
import ru.turikhay.tlauncher.ui.swing.AccountCellRenderer;
import ru.turikhay.tlauncher.ui.swing.SimpleComboBoxModel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedComboBox;

public class AccountComboBox
extends ExtendedComboBox<Account>
implements Blockable,
LoginForm.LoginProcessListener,
ProfileManagerListener,
LocalizableComponent {
    private static final long serialVersionUID = 6618039863712810645L;
    private static final Account EMPTY = AccountCellRenderer.EMPTY;
    private static final Account MANAGE = AccountCellRenderer.MANAGE;
    private final ProfileManager manager;
    private final LoginForm loginForm;
    private final AuthenticatorListener listener;
    private final SimpleComboBoxModel<Account> model;

    AccountComboBox(LoginForm lf) {
        super(new AccountCellRenderer());
        this.loginForm = lf;
        this.model = this.getSimpleModel();
        this.manager = TLauncher.getInstance().getProfileManager();
        this.manager.addListener(this);
        this.listener = new AuthUIListener(lf);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Account selected = (Account)AccountComboBox.this.getSelectedItem();
                if (selected != null && !selected.equals(EMPTY)) {
                    if (selected.equals(MANAGE)) {
                        ((AccountComboBox)AccountComboBox.this).loginForm.pane.openAccountEditor();
                        AccountComboBox.this.setSelectedIndex(0);
                    } else {
                        VersionComboBox.showElyVersions = selected.getType() == Account.AccountType.ELY;
                    }
                }
            }
        });
    }

    public Account getAccount() {
        Account value = (Account)this.getSelectedItem();
        return value != null && !value.equals(EMPTY) ? value : null;
    }

    public void setAccount(Account account) {
        if (account != null && !account.equals(this.getAccount())) {
            this.setSelectedItem(account);
        }
    }

    void setAccount(String username, Account.AccountType type) {
        if (username != null) {
            this.setSelectedItem(this.manager.getAuthDatabase().getByUsername(username));
        }
    }

    @Override
    public void logginingIn() throws LoginException {
        final Account account = this.getAccount();
        if (account == null) {
            this.loginForm.pane.openAccountEditor();
            Alert.showLocError("account.empty.error");
            throw new LoginException("Account list is empty!");
        }
        if (!account.isFree()) {
            throw new LoginWaitException("Waiting for auth...", new LoginWaitException.LoginWaitTask(){

                @Override
                public void runTask() {
                    Authenticator.instanceFor(account).pass(AccountComboBox.this.listener);
                }
            });
        }
    }

    @Override
    public void loginFailed() {
    }

    @Override
    public void loginSucceed() {
    }

    public void refreshAccounts(AuthenticatorDatabase db, Account select) {
        this.removeAllItems();
        Collection<Account> list = db.getAccounts();
        if (list.isEmpty()) {
            this.addItem(EMPTY);
        } else {
            this.model.addElements(list);
            for (Account account : list) {
                if (select == null || !select.equals(account)) continue;
                this.setSelectedItem(account);
            }
        }
        this.addItem(MANAGE);
    }

    @Override
    public void updateLocale() {
        this.refreshAccounts(this.manager.getAuthDatabase(), null);
    }

    @Override
    public void onAccountsRefreshed(AuthenticatorDatabase db) {
        this.refreshAccounts(db, null);
    }

    @Override
    public void onProfilesRefreshed(ProfileManager pm) {
        this.refreshAccounts(pm.getAuthDatabase(), null);
    }

    @Override
    public void onProfileManagerChanged(ProfileManager pm) {
        this.refreshAccounts(pm.getAuthDatabase(), null);
    }

    @Override
    public void block(Object reason) {
        this.setEnabled(false);
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }
}

