/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.login.buttons;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import ru.turikhay.tlauncher.managers.ComponentManager;
import ru.turikhay.tlauncher.managers.ComponentManagerListener;
import ru.turikhay.tlauncher.managers.ComponentManagerListenerHelper;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.images.ImageCache;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.tlauncher.updater.Updater;
import ru.turikhay.tlauncher.updater.UpdaterListener;

public class RefreshButton
extends LocalizableButton
implements Blockable,
ComponentManagerListener,
UpdaterListener {
    private static final long serialVersionUID = -1334187593288746348L;
    private static final int TYPE_REFRESH = 0;
    private static final int TYPE_CANCEL = 1;
    private LoginForm lf;
    private int type;
    private final Icon refresh = ImageCache.getIcon("refresh.png");
    private final Icon cancel = ImageCache.getIcon("cancel.png");
    private Updater updaterFlag;

    private RefreshButton(LoginForm loginform, int type) {
        this.lf = loginform;
        this.setType(type, false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RefreshButton.this.onPressButton();
            }
        });
        TLauncher.getInstance().getManager().getComponent(ComponentManagerListenerHelper.class).addListener(this);
        TLauncher.getInstance().getUpdater().addListener(this);
    }

    RefreshButton(LoginForm loginform) {
        this(loginform, 0);
    }

    private void onPressButton() {
        switch (this.type) {
            case 0: {
                if (this.updaterFlag != null) {
                    this.updaterFlag.asyncFindUpdate();
                }
                TLauncher.getInstance().getManager().startAsyncRefresh();
                break;
            }
            case 1: {
                TLauncher.getInstance().getManager().stopRefresh();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + this.type + ". Use RefreshButton.TYPE_* constants.");
            }
        }
        this.lf.defocus();
    }

    void setType(int type) {
        this.setType(type, true);
    }

    void setType(int type, boolean repaint) {
        String text;
        Icon icon;
        switch (type) {
            case 0: {
                icon = this.refresh;
                text = "loginform.button.refresh";
                break;
            }
            case 1: {
                icon = this.cancel;
                text = "loginform.button.refresh-cancel";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + type + ". Use RefreshButton.TYPE_* constants.");
            }
        }
        this.type = type;
        this.setText(text);
        this.setIcon(icon);
    }

    @Override
    public void onUpdaterRequesting(Updater u) {
    }

    @Override
    public void onUpdaterErrored(Updater.SearchFailed failed) {
        this.updaterFlag = failed.getUpdater();
    }

    @Override
    public void onUpdaterSucceeded(Updater.SearchSucceeded succeeded) {
        this.updaterFlag = null;
    }

    @Override
    public void onComponentsRefreshing(ComponentManager manager) {
        Blocker.block(this, "refresh");
    }

    @Override
    public void onComponentsRefreshed(ComponentManager manager) {
        Blocker.unblock(this, "refresh");
    }

    @Override
    public void block(Object reason) {
        if (reason.equals("refresh")) {
            this.setType(1);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void unblock(Object reason) {
        if (reason.equals("refresh")) {
            this.setType(0);
        }
        this.setEnabled(true);
    }
}

