/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.launcher.updater.AssetIndex;
import net.minecraft.launcher.versions.CompleteVersion;
import ru.turikhay.tlauncher.component.ComponentDependence;
import ru.turikhay.tlauncher.component.LauncherComponent;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.downloader.DownloadableContainer;
import ru.turikhay.tlauncher.managers.ComponentManager;
import ru.turikhay.tlauncher.managers.VersionLists;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.util.FileUtil;

@ComponentDependence(value={VersionManager.class, VersionLists.class})
public class AssetsManager
extends LauncherComponent {
    private final Gson gson = TLauncher.getGson();
    private final Object assetsFlushLock = new Object();

    public AssetsManager(ComponentManager manager) throws Exception {
        super(manager);
    }

    public DownloadableContainer downloadResources(CompleteVersion version, List<AssetIndex.AssetObject> list, boolean force) {
        File baseDirectory = this.manager.getLauncher().getVersionManager().getLocalList().getBaseDirectory();
        DownloadableContainer container = new DownloadableContainer();
        container.addAll(AssetsManager.getResourceFiles(version, baseDirectory, list));
        return container;
    }

    private static Set<Downloadable> getResourceFiles(CompleteVersion version, File baseDirectory, List<AssetIndex.AssetObject> list) {
        HashSet<Downloadable> result = new HashSet<Downloadable>();
        File objectsFolder = new File(baseDirectory, "assets/objects");
        for (AssetIndex.AssetObject object : list) {
            String filename = object.getFilename();
            Downloadable d = new Downloadable(Repository.ASSETS_REPO, filename, new File(objectsFolder, filename), false, true);
            result.add(d);
        }
        return result;
    }

    List<AssetIndex.AssetObject> getResourceFiles(CompleteVersion version, File baseDirectory, boolean local) {
        List<AssetIndex.AssetObject> list = null;
        if (!local) {
            try {
                list = this.getRemoteResourceFilesList(version, baseDirectory, true);
            }
            catch (Exception var7) {
                this.log("Cannot get remote assets list. Trying to use the local one.", var7);
            }
        }
        if (list == null) {
            list = this.getLocalResourceFilesList(version, baseDirectory);
        }
        if (list == null) {
            try {
                list = this.getRemoteResourceFilesList(version, baseDirectory, true);
            }
            catch (Exception var6) {
                this.log("Gave up trying to get assets list.", var6);
            }
        }
        return list;
    }

    private List<AssetIndex.AssetObject> getLocalResourceFilesList(CompleteVersion version, File baseDirectory) {
        String json;
        ArrayList<AssetIndex.AssetObject> result = new ArrayList<AssetIndex.AssetObject>();
        String indexName = version.getAssets();
        File indexesFolder = new File(baseDirectory, "assets/indexes/");
        File indexFile = new File(indexesFolder, indexName + ".json");
        this.log("Reading indexes from file", indexFile);
        try {
            json = FileUtil.readFile(indexFile);
        }
        catch (Exception var12) {
            this.log("Cannot read local resource files list for index:", indexName, var12);
            return null;
        }
        AssetIndex index = null;
        try {
            index = this.gson.fromJson(json, AssetIndex.class);
        }
        catch (JsonSyntaxException var11) {
            this.log("JSON file is invalid", var11);
        }
        if (index == null) {
            this.log("Cannot read data from JSON file.");
            return null;
        }
        for (AssetIndex.AssetObject object : index.getUniqueObjects()) {
            result.add(object);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AssetIndex.AssetObject> getRemoteResourceFilesList(CompleteVersion version, File baseDirectory, boolean save) throws IOException {
        ArrayList<AssetIndex.AssetObject> result = new ArrayList<AssetIndex.AssetObject>();
        String indexName = version.getAssets();
        if (indexName == null) {
            indexName = "legacy";
        }
        File assets = new File(baseDirectory, "assets");
        File indexesFolder = new File(assets, "indexes");
        File indexFile = new File(indexesFolder, indexName + ".json");
        this.log("Reading from repository...");
        String json = Repository.OFFICIAL_VERSION_REPO.getUrl("indexes/" + indexName + ".json");
        if (save) {
            Object index = this.assetsFlushLock;
            Object object = this.assetsFlushLock;
            synchronized (object) {
                FileUtil.writeFile(indexFile, json);
            }
        }
        AssetIndex index1 = this.gson.fromJson(json, AssetIndex.class);
        for (AssetIndex.AssetObject object : index1.getUniqueObjects()) {
            result.add(object);
        }
        return result;
    }

    List<AssetIndex.AssetObject> checkResources(CompleteVersion version, File baseDirectory, boolean local, boolean fast) {
        this.log("Checking resources...");
        ArrayList<AssetIndex.AssetObject> r = new ArrayList<AssetIndex.AssetObject>();
        List<AssetIndex.AssetObject> list = local ? this.getLocalResourceFilesList(version, baseDirectory) : this.getResourceFiles(version, baseDirectory, true);
        if (list == null) {
            this.log("Cannot get assets list. Aborting.");
            return r;
        }
        this.log("Fast comparing:", fast);
        for (AssetIndex.AssetObject resource : list) {
            if (AssetsManager.checkResource(baseDirectory, resource, fast)) continue;
            r.add(resource);
        }
        return r;
    }

    public List<AssetIndex.AssetObject> checkResources(CompleteVersion version, boolean fast) {
        return this.checkResources(version, this.manager.getComponent(VersionLists.class).getLocal().getBaseDirectory(), false, fast);
    }

    private static boolean checkResource(File baseDirectory, AssetIndex.AssetObject local, boolean fast) {
        String path = local.getFilename();
        File file = new File(baseDirectory, "assets/objects/" + path);
        long size = file.length();
        return file.isFile() && size != 0L ? (fast ? true : (local.getSize() != size ? false : (local.getHash() == null ? true : local.getHash().equals(FileUtil.getChecksum(file, "SHA-1"))))) : false;
    }
}

