/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.turikhay.tlauncher.component.LauncherComponent;
import ru.turikhay.tlauncher.managers.ComponentManager;
import ru.turikhay.tlauncher.managers.ComponentManagerListener;
import ru.turikhay.tlauncher.managers.ElyManager;
import ru.turikhay.tlauncher.managers.ElyManagerListener;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.managers.VersionManagerListener;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Blocker;

public class ComponentManagerListenerHelper
extends LauncherComponent
implements Blockable,
VersionManagerListener,
ElyManagerListener {
    private final List<ComponentManagerListener> listeners = Collections.synchronizedList(new ArrayList());

    public ComponentManagerListenerHelper(ComponentManager manager) throws Exception {
        super(manager);
        manager.getComponent(VersionManager.class).addListener(this);
    }

    public void addListener(ComponentManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(listener);
    }

    @Override
    public void onVersionsRefreshing(VersionManager manager) {
        Blocker.block(this, manager);
    }

    @Override
    public void onVersionsRefreshingFailed(VersionManager manager) {
        Blocker.unblock(this, manager);
    }

    @Override
    public void onVersionsRefreshed(VersionManager manager) {
        Blocker.unblock(this, manager);
    }

    @Override
    public void block(Object reason) {
        for (ComponentManagerListener listener : this.listeners) {
            listener.onComponentsRefreshing(this.manager);
        }
    }

    @Override
    public void unblock(Object reason) {
        for (ComponentManagerListener listener : this.listeners) {
            listener.onComponentsRefreshed(this.manager);
        }
    }

    @Override
    public void onElyUpdating(ElyManager manager) {
        Blocker.block(this, manager);
    }

    @Override
    public void onElyUpdated(ElyManager manager) {
        Blocker.unblock(this, manager);
    }
}

