/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.Countable;
import com.sk89q.worldedit.DoubleArrayList;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.bags.BlockBagException;
import com.sk89q.worldedit.bags.UnplaceableBlockException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.blocks.ChestBlock;
import com.sk89q.worldedit.blocks.ContainerBlock;
import com.sk89q.worldedit.blocks.DispenserBlock;
import com.sk89q.worldedit.blocks.FurnaceBlock;
import com.sk89q.worldedit.blocks.MobSpawnerBlock;
import com.sk89q.worldedit.blocks.NoteBlock;
import com.sk89q.worldedit.blocks.SignBlock;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.masks.Mask;
import com.sk89q.worldedit.patterns.Pattern;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.TreeGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditSession {
    private static Random prng = new Random();
    protected LocalWorld world;
    private DoubleArrayList<BlockVector, BaseBlock> original = new DoubleArrayList(true);
    private DoubleArrayList<BlockVector, BaseBlock> current = new DoubleArrayList(false);
    private DoubleArrayList<BlockVector, BaseBlock> queueAfter = new DoubleArrayList(false);
    private DoubleArrayList<BlockVector, BaseBlock> queueLast = new DoubleArrayList(false);
    private int maxBlocks = -1;
    private boolean queued = false;
    private boolean fastMode = false;
    private BlockBag blockBag;
    private Set<Integer> missingBlocks = new HashSet<Integer>();
    private Mask mask;

    public EditSession(LocalWorld world, int maxBlocks) {
        if (maxBlocks < -1) {
            throw new IllegalArgumentException("Max blocks must be >= -1");
        }
        this.maxBlocks = maxBlocks;
        this.world = world;
    }

    public EditSession(LocalWorld world, int maxBlocks, BlockBag blockBag) {
        if (maxBlocks < -1) {
            throw new IllegalArgumentException("Max blocks must be >= -1");
        }
        this.maxBlocks = maxBlocks;
        this.blockBag = blockBag;
        this.world = world;
    }

    public boolean rawSetBlock(Vector pt, BaseBlock block) {
        int y = pt.getBlockY();
        int type = block.getType();
        if (y < 0 || y > 127) {
            return false;
        }
        this.world.checkLoadedChuck(pt);
        if (!this.world.isValidBlockType(type)) {
            return false;
        }
        if (this.mask != null && !this.mask.matches(this, pt)) {
            return false;
        }
        int existing = this.world.getBlockType(pt);
        if (BlockType.isContainerBlock(existing) && this.blockBag == null) {
            this.world.clearContainerBlockContents(pt);
        } else if (existing == 79) {
            this.world.setBlockType(pt, 0);
        }
        if (this.blockBag != null) {
            if (type > 0) {
                try {
                    this.blockBag.fetchPlacedBlock(type);
                }
                catch (UnplaceableBlockException e) {
                    return false;
                }
                catch (BlockBagException e) {
                    this.missingBlocks.add(type);
                    return false;
                }
            }
            if (existing > 0) {
                try {
                    this.blockBag.storeDroppedBlock(existing);
                }
                catch (BlockBagException e) {
                    // empty catch block
                }
            }
        }
        boolean result = BlockType.usesData(type) ? (this.fastMode ? this.world.setTypeIdAndDataFast(pt, type, block.getData() > -1 ? block.getData() : 0) : this.world.setTypeIdAndData(pt, type, block.getData() > -1 ? block.getData() : 0)) : (this.fastMode ? this.world.setBlockTypeFast(pt, type) : this.world.setBlockType(pt, type));
        if (type != 0) {
            if (block instanceof ContainerBlock) {
                if (this.blockBag == null) {
                    this.world.copyToWorld(pt, block);
                }
            } else if (block instanceof TileEntityBlock) {
                this.world.copyToWorld(pt, block);
            }
        }
        return result;
    }

    public boolean setBlock(Vector pt, BaseBlock block) throws MaxChangedBlocksException {
        BlockVector blockPt = pt.toBlockVector();
        this.original.put(blockPt, this.getBlock(pt));
        if (this.maxBlocks != -1 && this.original.size() > this.maxBlocks) {
            throw new MaxChangedBlocksException(this.maxBlocks);
        }
        this.current.put(pt.toBlockVector(), block);
        return this.smartSetBlock(pt, block);
    }

    public void rememberChange(Vector pt, BaseBlock existing, BaseBlock block) {
        BlockVector blockPt = pt.toBlockVector();
        this.original.put(blockPt, existing);
        this.current.put(pt.toBlockVector(), block);
    }

    public boolean setBlock(Vector pt, Pattern pat) throws MaxChangedBlocksException {
        return this.setBlock(pt, pat.next(pt));
    }

    public boolean setBlockIfAir(Vector pt, BaseBlock block) throws MaxChangedBlocksException {
        if (!this.getBlock(pt).isAir()) {
            return false;
        }
        return this.setBlock(pt, block);
    }

    public boolean smartSetBlock(Vector pt, BaseBlock block) {
        if (this.queued) {
            if (BlockType.shouldPlaceLast(block.getType())) {
                this.queueLast.put(pt.toBlockVector(), block);
                return this.getBlockType(pt) != block.getType() || this.getBlockData(pt) != block.getData();
            }
            if (BlockType.shouldPlaceLast(this.getBlockType(pt))) {
                this.rawSetBlock(pt, new BaseBlock(0));
            } else {
                this.queueAfter.put(pt.toBlockVector(), block);
                return this.getBlockType(pt) != block.getType() || this.getBlockData(pt) != block.getData();
            }
        }
        return this.rawSetBlock(pt, block);
    }

    public BaseBlock getBlock(Vector pt) {
        if (this.queued) {
            // empty if block
        }
        return this.rawGetBlock(pt);
    }

    public int getBlockType(Vector pt) {
        if (this.queued) {
            // empty if block
        }
        return this.world.getBlockType(pt);
    }

    public int getBlockData(Vector pt) {
        if (this.queued) {
            // empty if block
        }
        return this.world.getBlockData(pt);
    }

    public BaseBlock rawGetBlock(Vector pt) {
        this.world.checkLoadedChuck(pt);
        int type = this.world.getBlockType(pt);
        int data = this.world.getBlockData(pt);
        switch (type) {
            case 63: 
            case 68: {
                SignBlock block = new SignBlock(type, data);
                this.world.copyFromWorld(pt, block);
                return block;
            }
            case 54: {
                ChestBlock block = new ChestBlock(data);
                this.world.copyFromWorld(pt, block);
                return block;
            }
            case 61: 
            case 62: {
                FurnaceBlock block = new FurnaceBlock(type, data);
                this.world.copyFromWorld(pt, block);
                return block;
            }
            case 23: {
                DispenserBlock block = new DispenserBlock(data);
                this.world.copyFromWorld(pt, block);
                return block;
            }
            case 52: {
                MobSpawnerBlock block = new MobSpawnerBlock(data);
                this.world.copyFromWorld(pt, block);
                return block;
            }
            case 25: {
                NoteBlock block = new NoteBlock(data);
                this.world.copyFromWorld(pt, block);
                return block;
            }
        }
        return new BaseBlock(type, data);
    }

    public void undo(EditSession sess) {
        for (Map.Entry<BlockVector, BaseBlock> entry : this.original) {
            BlockVector pt = entry.getKey();
            sess.smartSetBlock(pt, entry.getValue());
        }
        sess.flushQueue();
    }

    public void redo(EditSession sess) {
        for (Map.Entry<BlockVector, BaseBlock> entry : this.current) {
            BlockVector pt = entry.getKey();
            sess.smartSetBlock(pt, entry.getValue());
        }
        sess.flushQueue();
    }

    public int size() {
        return this.original.size();
    }

    public int getBlockChangeLimit() {
        return this.maxBlocks;
    }

    public void setBlockChangeLimit(int maxBlocks) {
        if (maxBlocks < -1) {
            throw new IllegalArgumentException("Max blocks must be >= -1");
        }
        this.maxBlocks = maxBlocks;
    }

    public boolean isQueueEnabled() {
        return this.queued;
    }

    public void enableQueue() {
        this.queued = true;
    }

    public void disableQueue() {
        if (this.queued) {
            this.flushQueue();
        }
        this.queued = false;
    }

    public void setFastMode(boolean fastMode) {
        this.fastMode = fastMode;
    }

    public boolean hasFastMode() {
        return this.fastMode;
    }

    public void flushQueue() {
        BlockVector pt;
        if (!this.queued) {
            return;
        }
        for (Map.Entry<BlockVector, BaseBlock> entry : this.queueAfter) {
            pt = entry.getKey();
            this.rawSetBlock(pt, entry.getValue());
        }
        if (this.blockBag == null || this.missingBlocks.size() == 0) {
            for (Map.Entry<BlockVector, BaseBlock> entry : this.queueLast) {
                pt = entry.getKey();
                this.rawSetBlock(pt, entry.getValue());
            }
        }
        this.queueAfter.clear();
        this.queueLast.clear();
    }

    public int fillXZ(Vector origin, BaseBlock block, double radius, int depth, boolean recursive) throws MaxChangedBlocksException {
        int affected = 0;
        int originX = origin.getBlockX();
        int originY = origin.getBlockY();
        int originZ = origin.getBlockZ();
        HashSet<BlockVector> visited = new HashSet<BlockVector>();
        Stack<BlockVector> queue = new Stack<BlockVector>();
        queue.push(new BlockVector(originX, originY, originZ));
        while (!queue.empty()) {
            BlockVector pt = (BlockVector)queue.pop();
            int cx = pt.getBlockX();
            int cy = pt.getBlockY();
            int cz = pt.getBlockZ();
            if (cy < 0 || cy > originY || visited.contains(pt)) continue;
            visited.add(pt);
            if (recursive) {
                if (origin.distance(pt) > radius || !this.getBlock(pt).isAir()) continue;
                if (this.setBlock((Vector)pt, block)) {
                    ++affected;
                }
                queue.push(new BlockVector(cx, cy - 1, cz));
                queue.push(new BlockVector(cx, cy + 1, cz));
            } else {
                double dist = Math.sqrt(Math.pow(originX - cx, 2.0) + Math.pow(originZ - cz, 2.0));
                int minY = originY - depth + 1;
                if (dist > radius || !this.getBlock(pt).isAir()) continue;
                affected += this.fillY(cx, originY, cz, block, minY);
            }
            queue.push(new BlockVector(cx + 1, cy, cz));
            queue.push(new BlockVector(cx - 1, cy, cz));
            queue.push(new BlockVector(cx, cy, cz + 1));
            queue.push(new BlockVector(cx, cy, cz - 1));
        }
        return affected;
    }

    private int fillY(int x, int cy, int z, BaseBlock block, int minY) throws MaxChangedBlocksException {
        Vector pt;
        int affected = 0;
        for (int y = cy; y >= minY && this.getBlock(pt = new Vector(x, y, z)).isAir(); --y) {
            this.setBlock(pt, block);
            ++affected;
        }
        return affected;
    }

    public int fillXZ(Vector origin, Pattern pattern, double radius, int depth, boolean recursive) throws MaxChangedBlocksException {
        int affected = 0;
        int originX = origin.getBlockX();
        int originY = origin.getBlockY();
        int originZ = origin.getBlockZ();
        HashSet<BlockVector> visited = new HashSet<BlockVector>();
        Stack<BlockVector> queue = new Stack<BlockVector>();
        queue.push(new BlockVector(originX, originY, originZ));
        while (!queue.empty()) {
            BlockVector pt = (BlockVector)queue.pop();
            int cx = pt.getBlockX();
            int cy = pt.getBlockY();
            int cz = pt.getBlockZ();
            if (cy < 0 || cy > originY || visited.contains(pt)) continue;
            visited.add(pt);
            if (recursive) {
                if (origin.distance(pt) > radius || !this.getBlock(pt).isAir()) continue;
                if (this.setBlock((Vector)pt, pattern.next(pt))) {
                    ++affected;
                }
                queue.push(new BlockVector(cx, cy - 1, cz));
                queue.push(new BlockVector(cx, cy + 1, cz));
            } else {
                double dist = Math.sqrt(Math.pow(originX - cx, 2.0) + Math.pow(originZ - cz, 2.0));
                int minY = originY - depth + 1;
                if (dist > radius || !this.getBlock(pt).isAir()) continue;
                affected += this.fillY(cx, originY, cz, pattern, minY);
            }
            queue.push(new BlockVector(cx + 1, cy, cz));
            queue.push(new BlockVector(cx - 1, cy, cz));
            queue.push(new BlockVector(cx, cy, cz + 1));
            queue.push(new BlockVector(cx, cy, cz - 1));
        }
        return affected;
    }

    private int fillY(int x, int cy, int z, Pattern pattern, int minY) throws MaxChangedBlocksException {
        Vector pt;
        int affected = 0;
        for (int y = cy; y >= minY && this.getBlock(pt = new Vector(x, y, z)).isAir(); --y) {
            this.setBlock(pt, pattern.next(pt));
            ++affected;
        }
        return affected;
    }

    public int removeAbove(Vector pos, int size, int height) throws MaxChangedBlocksException {
        int maxY = Math.min(127, pos.getBlockY() + height - 1);
        int affected = 0;
        int oX = pos.getBlockX();
        int oY = pos.getBlockY();
        int oZ = pos.getBlockZ();
        for (int x = oX - --size; x <= oX + size; ++x) {
            for (int z = oZ - size; z <= oZ + size; ++z) {
                for (int y = oY; y <= maxY; ++y) {
                    Vector pt = new Vector(x, y, z);
                    if (this.getBlockType(pt) == 0) continue;
                    this.setBlock(pt, new BaseBlock(0));
                    ++affected;
                }
            }
        }
        return affected;
    }

    public int removeBelow(Vector pos, int size, int height) throws MaxChangedBlocksException {
        int minY = Math.max(0, pos.getBlockY() - height);
        int affected = 0;
        int oX = pos.getBlockX();
        int oY = pos.getBlockY();
        int oZ = pos.getBlockZ();
        for (int x = oX - --size; x <= oX + size; ++x) {
            for (int z = oZ - size; z <= oZ + size; ++z) {
                for (int y = oY; y >= minY; --y) {
                    Vector pt = new Vector(x, y, z);
                    if (this.getBlockType(pt) == 0) continue;
                    this.setBlock(pt, new BaseBlock(0));
                    ++affected;
                }
            }
        }
        return affected;
    }

    public int removeNear(Vector pos, int blockType, int size) throws MaxChangedBlocksException {
        int affected = 0;
        BaseBlock air = new BaseBlock(0);
        int minX = pos.getBlockX() - size;
        int maxX = pos.getBlockX() + size;
        int minY = Math.max(0, pos.getBlockY() - size);
        int maxY = Math.min(127, pos.getBlockY() + size);
        int minZ = pos.getBlockZ() - size;
        int maxZ = pos.getBlockZ() + size;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Vector p = new Vector(x, y, z);
                    if (this.getBlockType(p) != blockType || !this.setBlock(p, air)) continue;
                    ++affected;
                }
            }
        }
        return affected;
    }

    public int setBlocks(Region region, BaseBlock block) throws MaxChangedBlocksException {
        int affected = 0;
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Vector pt = new Vector(x, y, z);
                        if (!this.setBlock(pt, block)) continue;
                        ++affected;
                    }
                }
            }
        } else {
            for (BlockVector pt : region) {
                if (!this.setBlock((Vector)pt, block)) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int setBlocks(Region region, Pattern pattern) throws MaxChangedBlocksException {
        int affected = 0;
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Vector pt = new Vector(x, y, z);
                        if (!this.setBlock(pt, pattern.next(pt))) continue;
                        ++affected;
                    }
                }
            }
        } else {
            for (BlockVector pt : region) {
                if (!this.setBlock((Vector)pt, pattern.next(pt))) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int replaceBlocks(Region region, Set<BaseBlock> fromBlockTypes, BaseBlock toBlock) throws MaxChangedBlocksException {
        int affected = 0;
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Vector pt = new Vector(x, y, z);
                        BaseBlock curBlockType = this.getBlock(pt);
                        if ((fromBlockTypes != null || curBlockType.isAir()) && (fromBlockTypes == null || !curBlockType.inIterable(fromBlockTypes)) || !this.setBlock(pt, toBlock)) continue;
                        ++affected;
                    }
                }
            }
        } else {
            for (BlockVector pt : region) {
                BaseBlock curBlockType = this.getBlock(pt);
                if ((fromBlockTypes != null || curBlockType.isAir()) && (fromBlockTypes == null || !curBlockType.inIterable(fromBlockTypes)) || !this.setBlock((Vector)pt, toBlock)) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int replaceBlocks(Region region, Set<BaseBlock> fromBlockTypes, Pattern pattern) throws MaxChangedBlocksException {
        int affected = 0;
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Vector pt = new Vector(x, y, z);
                        BaseBlock curBlockType = this.getBlock(pt);
                        if ((fromBlockTypes != null || curBlockType.isAir()) && (fromBlockTypes == null || !curBlockType.inIterable(fromBlockTypes)) || !this.setBlock(pt, pattern.next(pt))) continue;
                        ++affected;
                    }
                }
            }
        } else {
            for (BlockVector pt : region) {
                BaseBlock curBlockType = this.getBlock(pt);
                if ((fromBlockTypes != null || curBlockType.isAir()) && !curBlockType.inIterable(fromBlockTypes) || !this.setBlock((Vector)pt, pattern.next(pt))) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int makeCuboidFaces(Region region, BaseBlock block) throws MaxChangedBlocksException {
        int affected = 0;
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                if (this.setBlock(new Vector(x, y, minZ), block)) {
                    ++affected;
                }
                if (this.setBlock(new Vector(x, y, maxZ), block)) {
                    ++affected;
                }
                ++affected;
            }
        }
        for (int y = minY; y <= maxY; ++y) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (this.setBlock(new Vector(minX, y, z), block)) {
                    ++affected;
                }
                if (!this.setBlock(new Vector(maxX, y, z), block)) continue;
                ++affected;
            }
        }
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                if (this.setBlock(new Vector(x, minY, z), block)) {
                    ++affected;
                }
                if (!this.setBlock(new Vector(x, maxY, z), block)) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int makeCuboidFaces(Region region, Pattern pattern) throws MaxChangedBlocksException {
        Vector maxV;
        Vector minV;
        int affected = 0;
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                minV = new Vector(x, y, minZ);
                if (this.setBlock(min, pattern.next(minV))) {
                    ++affected;
                }
                if (this.setBlock(maxV = new Vector(x, y, maxZ), pattern.next(maxV))) {
                    ++affected;
                }
                ++affected;
            }
        }
        for (int y = minY; y <= maxY; ++y) {
            for (int z = minZ; z <= maxZ; ++z) {
                minV = new Vector(minX, y, z);
                if (this.setBlock(minV, pattern.next(minV))) {
                    ++affected;
                }
                if (!this.setBlock(maxV = new Vector(maxX, y, z), pattern.next(maxV))) continue;
                ++affected;
            }
        }
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                minV = new Vector(x, minY, z);
                if (this.setBlock(minV, pattern.next(minV))) {
                    ++affected;
                }
                if (!this.setBlock(maxV = new Vector(x, maxY, z), pattern.next(maxV))) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int makeCuboidWalls(Region region, BaseBlock block) throws MaxChangedBlocksException {
        int affected = 0;
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                if (this.setBlock(new Vector(x, y, minZ), block)) {
                    ++affected;
                }
                if (this.setBlock(new Vector(x, y, maxZ), block)) {
                    ++affected;
                }
                ++affected;
            }
        }
        for (int y = minY; y <= maxY; ++y) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (this.setBlock(new Vector(minX, y, z), block)) {
                    ++affected;
                }
                if (!this.setBlock(new Vector(maxX, y, z), block)) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int makeCuboidWalls(Region region, Pattern pattern) throws MaxChangedBlocksException {
        Vector maxV;
        Vector minV;
        int affected = 0;
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                minV = new Vector(x, y, minZ);
                if (this.setBlock(minV, pattern.next(minV))) {
                    ++affected;
                }
                if (this.setBlock(maxV = new Vector(x, y, maxZ), pattern.next(maxV))) {
                    ++affected;
                }
                ++affected;
            }
        }
        for (int y = minY; y <= maxY; ++y) {
            for (int z = minZ; z <= maxZ; ++z) {
                minV = new Vector(minX, y, z);
                if (this.setBlock(minV, pattern.next(minV))) {
                    ++affected;
                }
                if (!this.setBlock(maxV = new Vector(maxX, y, z), pattern.next(maxV))) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int overlayCuboidBlocks(Region region, BaseBlock block) throws MaxChangedBlocksException {
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int upperY = Math.min(127, max.getBlockY() + 1);
        int lowerY = Math.max(0, min.getBlockY() - 1);
        int affected = 0;
        int minX = min.getBlockX();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxZ = max.getBlockZ();
        for (int x = minX; x <= maxX; ++x) {
            block1: for (int z = minZ; z <= maxZ; ++z) {
                for (int y = upperY; y >= lowerY; --y) {
                    Vector above = new Vector(x, y + 1, z);
                    if (y + 1 > 127 || this.getBlock(new Vector(x, y, z)).isAir() || !this.getBlock(above).isAir()) continue;
                    if (!this.setBlock(above, block)) continue block1;
                    ++affected;
                    continue block1;
                }
            }
        }
        return affected;
    }

    public int overlayCuboidBlocks(Region region, Pattern pattern) throws MaxChangedBlocksException {
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int upperY = Math.min(127, max.getBlockY() + 1);
        int lowerY = Math.max(0, min.getBlockY() - 1);
        int affected = 0;
        int minX = min.getBlockX();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxZ = max.getBlockZ();
        for (int x = minX; x <= maxX; ++x) {
            block1: for (int z = minZ; z <= maxZ; ++z) {
                for (int y = upperY; y >= lowerY; --y) {
                    Vector above = new Vector(x, y + 1, z);
                    if (y + 1 > 127 || this.getBlock(new Vector(x, y, z)).isAir() || !this.getBlock(above).isAir()) continue;
                    if (!this.setBlock(above, pattern.next(above))) continue block1;
                    ++affected;
                    continue block1;
                }
            }
        }
        return affected;
    }

    public int naturalizeCuboidBlocks(Region region) throws MaxChangedBlocksException {
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int upperY = Math.min(127, max.getBlockY() + 1);
        int lowerY = Math.max(0, min.getBlockY() - 1);
        int affected = 0;
        int minX = min.getBlockX();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxZ = max.getBlockZ();
        BaseBlock grass = new BaseBlock(2);
        BaseBlock dirt = new BaseBlock(3);
        BaseBlock stone = new BaseBlock(1);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int level = -1;
                for (int y = upperY; y >= lowerY; --y) {
                    boolean isTransformable;
                    Vector pt = new Vector(x, y, z);
                    int blockType = this.getBlockType(pt);
                    boolean bl = isTransformable = blockType == 2 || blockType == 3 || blockType == 1;
                    if (level == -1) {
                        if (!isTransformable) continue;
                        level = 0;
                    }
                    if (level < 0) continue;
                    if (isTransformable) {
                        if (level == 0) {
                            this.setBlock(pt, grass);
                            ++affected;
                        } else if (level <= 2) {
                            this.setBlock(pt, dirt);
                            ++affected;
                        } else {
                            this.setBlock(pt, stone);
                            ++affected;
                        }
                    }
                    ++level;
                }
            }
        }
        return affected;
    }

    public int stackCuboidRegion(Region region, Vector dir, int count, boolean copyAir) throws MaxChangedBlocksException {
        int affected = 0;
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        int xs = region.getWidth();
        int ys = region.getHeight();
        int zs = region.getLength();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BaseBlock block = this.getBlock(new Vector(x, y, z));
                    if (block.isAir() && !copyAir) continue;
                    for (int i = 1; i <= count; ++i) {
                        Vector pos = new Vector(x + xs * dir.getBlockX() * i, y + ys * dir.getBlockY() * i, z + zs * dir.getBlockZ() * i);
                        if (!this.setBlock(pos, block)) continue;
                        ++affected;
                    }
                }
            }
        }
        return affected;
    }

    public int moveCuboidRegion(Region region, Vector dir, int distance, boolean copyAir, BaseBlock replace) throws MaxChangedBlocksException {
        int affected = 0;
        Vector shift = dir.multiply(distance);
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        Vector newMin = min.add(shift);
        Vector newMax = min.add(shift);
        LinkedHashMap<Vector, BaseBlock> delayed = new LinkedHashMap<Vector, BaseBlock>();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    Vector pos = new Vector(x, y, z);
                    BaseBlock block = this.getBlock(pos);
                    if (block.isAir() && !copyAir) continue;
                    Vector newPos = pos.add(shift);
                    delayed.put(newPos, this.getBlock(pos));
                    if (x >= newMin.getBlockX() && x <= newMax.getBlockX() && y >= newMin.getBlockY() && y <= newMax.getBlockY() && z >= newMin.getBlockZ() && z <= newMax.getBlockZ()) continue;
                    this.setBlock(pos, replace);
                }
            }
        }
        for (Map.Entry entry : delayed.entrySet()) {
            this.setBlock((Vector)entry.getKey(), (BaseBlock)entry.getValue());
            ++affected;
        }
        return affected;
    }

    public int drainArea(Vector pos, double radius) throws MaxChangedBlocksException {
        int affected = 0;
        HashSet<BlockVector> visited = new HashSet<BlockVector>();
        Stack<BlockVector> queue = new Stack<BlockVector>();
        for (int x = pos.getBlockX() - 1; x <= pos.getBlockX() + 1; ++x) {
            for (int z = pos.getBlockZ() - 1; z <= pos.getBlockZ() + 1; ++z) {
                for (int y = pos.getBlockY() - 1; y <= pos.getBlockY() + 1; ++y) {
                    queue.push(new BlockVector(x, y, z));
                }
            }
        }
        while (!queue.empty()) {
            BlockVector cur = (BlockVector)queue.pop();
            int type = this.getBlockType(cur);
            if (type != 8 && type != 9 && type != 10 && type != 11 || visited.contains(cur)) continue;
            visited.add(cur);
            if (pos.distance(cur) > radius) continue;
            for (int x = cur.getBlockX() - 1; x <= cur.getBlockX() + 1; ++x) {
                for (int z = cur.getBlockZ() - 1; z <= cur.getBlockZ() + 1; ++z) {
                    for (int y = cur.getBlockY() - 1; y <= cur.getBlockY() + 1; ++y) {
                        BlockVector newPos = new BlockVector(x, y, z);
                        if (cur.equals(newPos)) continue;
                        queue.push(newPos);
                    }
                }
            }
            if (!this.setBlock((Vector)cur, new BaseBlock(0))) continue;
            ++affected;
        }
        return affected;
    }

    public int fixLiquid(Vector pos, double radius, int moving, int stationary) throws MaxChangedBlocksException {
        int affected = 0;
        HashSet<BlockVector> visited = new HashSet<BlockVector>();
        Stack<BlockVector> queue = new Stack<BlockVector>();
        for (int x = pos.getBlockX() - 1; x <= pos.getBlockX() + 1; ++x) {
            for (int z = pos.getBlockZ() - 1; z <= pos.getBlockZ() + 1; ++z) {
                for (int y = pos.getBlockY() - 1; y <= pos.getBlockY() + 1; ++y) {
                    int type = this.getBlock(new Vector(x, y, z)).getType();
                    if (type != moving && type != stationary) continue;
                    queue.push(new BlockVector(x, y, z));
                }
            }
        }
        BaseBlock stationaryBlock = new BaseBlock(stationary);
        while (!queue.empty()) {
            BlockVector cur = (BlockVector)queue.pop();
            int type = this.getBlockType(cur);
            if (type != moving && type != stationary && type != 0 || visited.contains(cur)) continue;
            visited.add(cur);
            if (this.setBlock((Vector)cur, stationaryBlock)) {
                ++affected;
            }
            if (pos.distance(cur) > radius) continue;
            queue.push(cur.add(1, 0, 0).toBlockVector());
            queue.push(cur.add(-1, 0, 0).toBlockVector());
            queue.push(cur.add(0, 0, 1).toBlockVector());
            queue.push(cur.add(0, 0, -1).toBlockVector());
        }
        return affected;
    }

    private int makeHCylinderPoints(Vector center, int x, double z, int height, Pattern block) throws MaxChangedBlocksException {
        int affected;
        block4: {
            int ceilZ;
            block5: {
                block3: {
                    ceilZ = (int)Math.ceil(z);
                    affected = 0;
                    if (x != 0) break block3;
                    for (int y = 0; y < height; ++y) {
                        this.setBlock(center.add(0, y, ceilZ), block);
                        this.setBlock(center.add(0, y, -ceilZ), block);
                        this.setBlock(center.add(ceilZ, y, 0), block);
                        this.setBlock(center.add(-ceilZ, y, 0), block);
                        affected += 4;
                    }
                    break block4;
                }
                if ((double)x != z) break block5;
                for (int y = 0; y < height; ++y) {
                    this.setBlock(center.add(x, y, ceilZ), block);
                    this.setBlock(center.add(-x, y, ceilZ), block);
                    this.setBlock(center.add(x, y, -ceilZ), block);
                    this.setBlock(center.add(-x, y, -ceilZ), block);
                    affected += 4;
                }
                break block4;
            }
            if (!((double)x < z)) break block4;
            for (int y = 0; y < height; ++y) {
                this.setBlock(center.add(x, y, ceilZ), block);
                this.setBlock(center.add(-x, y, ceilZ), block);
                this.setBlock(center.add(x, y, -ceilZ), block);
                this.setBlock(center.add(-x, y, -ceilZ), block);
                this.setBlock(center.add(ceilZ, y, x), block);
                this.setBlock(center.add(-ceilZ, y, x), block);
                this.setBlock(center.add(ceilZ, y, -x), block);
                this.setBlock(center.add(-ceilZ, y, -x), block);
                affected += 8;
            }
        }
        return affected;
    }

    public int makeHollowCylinder(Vector pos, Pattern block, double radius, int height) throws MaxChangedBlocksException {
        int x = 0;
        double z = radius;
        double d = (5.0 - radius * 4.0) / 4.0;
        int affected = 0;
        if (height == 0) {
            return 0;
        }
        if (height < 0) {
            height = -height;
            pos = pos.subtract(0, height, 0);
        }
        if (height < 0 && pos.getBlockY() - height - 1 < 0) {
            height = pos.getBlockY() + 1;
        } else if (pos.getBlockY() + height - 1 > 127) {
            height = 127 - pos.getBlockY() + 1;
        }
        affected += this.makeHCylinderPoints(pos, x, z, height, block);
        while ((double)x < z) {
            d = d >= 0.0 ? (d += 2.0 * ((double)x - (z -= 1.0)) + 1.0) : (d += (double)(2 * ++x + 1));
            affected += this.makeHCylinderPoints(pos, x, z, height, block);
        }
        return affected;
    }

    private int makeCylinderPoints(Vector center, int x, double z, int height, Pattern block) throws MaxChangedBlocksException {
        int affected;
        block6: {
            int ceilZ;
            block5: {
                ceilZ = (int)Math.ceil(z);
                affected = 0;
                if ((double)x != z) break block5;
                for (int y = 0; y < height; ++y) {
                    for (int z2 = -ceilZ; z2 <= ceilZ; ++z2) {
                        this.setBlock(center.add(x, y, z2), block);
                        this.setBlock(center.add(-x, y, z2), block);
                        affected += 2;
                    }
                }
                break block6;
            }
            if (!((double)x < z)) break block6;
            for (int y = 0; y < height; ++y) {
                for (int x2 = -x; x2 <= x; ++x2) {
                    for (int z2 = -ceilZ; z2 <= ceilZ; ++z2) {
                        this.setBlock(center.add(x2, y, z2), block);
                        ++affected;
                    }
                    this.setBlock(center.add(ceilZ, y, x2), block);
                    this.setBlock(center.add(-ceilZ, y, x2), block);
                    affected += 2;
                }
            }
        }
        return affected;
    }

    public int makeCylinder(Vector pos, Pattern block, double radius, int height) throws MaxChangedBlocksException {
        int x = 0;
        double z = radius;
        double d = (5.0 - radius * 4.0) / 4.0;
        int affected = 0;
        if (height == 0) {
            return 0;
        }
        if (height < 0) {
            height = -height;
            pos = pos.subtract(0, height, 0);
        }
        if (pos.getBlockY() - height - 1 < 0) {
            height = pos.getBlockY() + 1;
        } else if (pos.getBlockY() + height - 1 > 127) {
            height = 127 - pos.getBlockY() + 1;
        }
        affected += this.makeCylinderPoints(pos, x, z, height, block);
        while ((double)x < z) {
            d = d >= 0.0 ? (d += 2.0 * ((double)x - (z -= 1.0)) + 1.0) : (d += (double)(2 * ++x + 1));
            affected += this.makeCylinderPoints(pos, x, z, height, block);
        }
        return affected;
    }

    public int makeSphere(Vector pos, Pattern block, double radius, boolean filled) throws MaxChangedBlocksException {
        int affected = 0;
        double radiusSq = (radius += 0.5) * radius;
        double radius1Sq = (radius - 1.0) * (radius - 1.0);
        int ceilRadius = (int)Math.ceil(radius);
        for (int x = 0; x <= ceilRadius; ++x) {
            for (int y = 0; y <= ceilRadius; ++y) {
                for (int z = 0; z <= ceilRadius; ++z) {
                    double dSq = EditSession.lengthSq(x, y, z);
                    if (dSq > radiusSq || !filled && (dSq < radius1Sq || EditSession.lengthSq(x + 1, y, z) <= radiusSq && EditSession.lengthSq(x, y + 1, z) <= radiusSq && EditSession.lengthSq(x, y, z + 1) <= radiusSq)) continue;
                    if (this.setBlock(pos.add(x, y, z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(-x, y, z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(x, -y, z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(x, y, -z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(-x, -y, z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(x, -y, -z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(-x, y, -z), block)) {
                        ++affected;
                    }
                    if (!this.setBlock(pos.add(-x, -y, -z), block)) continue;
                    ++affected;
                }
            }
        }
        return affected;
    }

    public int makeSphere(Vector pos, Pattern block, double radiusX, double radiusY, double radiusZ, boolean filled) throws MaxChangedBlocksException {
        int affected = 0;
        double invRadiusX = 1.0 / (radiusX += 0.5);
        double invRadiusY = 1.0 / (radiusY += 0.5);
        double invRadiusZ = 1.0 / (radiusZ += 0.5);
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusY = (int)Math.ceil(radiusY);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        double nextXn = 0.0;
        block0: for (int x = 0; x <= ceilRadiusX; ++x) {
            double xn = nextXn;
            nextXn = (double)(x + 1) * invRadiusX;
            double nextYn = 0.0;
            block1: for (int y = 0; y <= ceilRadiusY; ++y) {
                double yn = nextYn;
                nextYn = (double)(y + 1) * invRadiusY;
                double nextZn = 0.0;
                for (int z = 0; z <= ceilRadiusZ; ++z) {
                    double zn = nextZn;
                    nextZn = (double)(z + 1) * invRadiusZ;
                    double distanceSq = EditSession.lengthSq(xn, yn, zn);
                    if (distanceSq > 1.0) {
                        if (z != 0) continue block1;
                        if (y != 0) continue block0;
                        break block0;
                    }
                    if (!filled && EditSession.lengthSq(nextXn, yn, zn) <= 1.0 && EditSession.lengthSq(xn, nextYn, zn) <= 1.0 && EditSession.lengthSq(xn, yn, nextZn) <= 1.0) continue;
                    if (this.setBlock(pos.add(x, y, z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(-x, y, z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(x, -y, z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(x, y, -z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(-x, -y, z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(x, -y, -z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(-x, y, -z), block)) {
                        ++affected;
                    }
                    if (!this.setBlock(pos.add(-x, -y, -z), block)) continue;
                    ++affected;
                }
            }
        }
        return affected;
    }

    private static final double lengthSq(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public int makePyramid(Vector pos, Pattern block, int size, boolean filled) throws MaxChangedBlocksException {
        int affected = 0;
        int height = size;
        for (int y = 0; y <= height; ++y) {
            --size;
            for (int x = 0; x <= size; ++x) {
                for (int z = 0; z <= size; ++z) {
                    if ((!filled || z > size || x > size) && z != size && x != size) continue;
                    if (this.setBlock(pos.add(x, y, z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(-x, y, z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(x, y, -z), block)) {
                        ++affected;
                    }
                    if (!this.setBlock(pos.add(-x, y, -z), block)) continue;
                    ++affected;
                }
            }
        }
        return affected;
    }

    public int thaw(Vector pos, double radius) throws MaxChangedBlocksException {
        int affected = 0;
        double radiusSq = radius * radius;
        int ox = pos.getBlockX();
        int oy = pos.getBlockY();
        int oz = pos.getBlockZ();
        BaseBlock air = new BaseBlock(0);
        BaseBlock water = new BaseBlock(9);
        int ceilRadius = (int)Math.ceil(radius);
        for (int x = ox - ceilRadius; x <= ox + ceilRadius; ++x) {
            block6: for (int z = oz - ceilRadius; z <= oz + ceilRadius; ++z) {
                if (new Vector(x, oy, z).distanceSq(pos) > radiusSq) continue;
                block7: for (int y = 127; y >= 1; --y) {
                    Vector pt = new Vector(x, y, z);
                    int id = this.getBlockType(pt);
                    switch (id) {
                        case 79: {
                            if (!this.setBlock(pt, water)) continue block6;
                            ++affected;
                            continue block6;
                        }
                        case 78: {
                            if (!this.setBlock(pt, air)) continue block6;
                            ++affected;
                            continue block6;
                        }
                        case 0: {
                            continue block7;
                        }
                        default: {
                            continue block6;
                        }
                    }
                }
            }
        }
        return affected;
    }

    public int simulateSnow(Vector pos, double radius) throws MaxChangedBlocksException {
        int affected = 0;
        double radiusSq = radius * radius;
        int ox = pos.getBlockX();
        int oy = pos.getBlockY();
        int oz = pos.getBlockZ();
        BaseBlock ice = new BaseBlock(79);
        BaseBlock snow = new BaseBlock(78);
        int ceilRadius = (int)Math.ceil(radius);
        for (int x = ox - ceilRadius; x <= ox + ceilRadius; ++x) {
            block1: for (int z = oz - ceilRadius; z <= oz + ceilRadius; ++z) {
                if (new Vector(x, oy, z).distanceSq(pos) > radiusSq) continue;
                for (int y = 127; y >= 1; --y) {
                    Vector pt = new Vector(x, y, z);
                    int id = this.getBlockType(pt);
                    if (id == 0) continue;
                    if (id == 8 || id == 9) {
                        if (!this.setBlock(pt, ice)) continue block1;
                        ++affected;
                        continue block1;
                    }
                    if (BlockType.canPassThrough(id) || y == 127 || !this.setBlock(pt.add(0, 1, 0), snow)) continue block1;
                    ++affected;
                    continue block1;
                }
            }
        }
        return affected;
    }

    public int green(Vector pos, double radius) throws MaxChangedBlocksException {
        int affected = 0;
        double radiusSq = radius * radius;
        int ox = pos.getBlockX();
        int oy = pos.getBlockY();
        int oz = pos.getBlockZ();
        BaseBlock grass = new BaseBlock(2);
        int ceilRadius = (int)Math.ceil(radius);
        for (int x = ox - ceilRadius; x <= ox + ceilRadius; ++x) {
            block1: for (int z = oz - ceilRadius; z <= oz + ceilRadius; ++z) {
                if (new Vector(x, oy, z).distanceSq(pos) > radiusSq) continue;
                for (int y = 127; y >= 1; --y) {
                    Vector pt = new Vector(x, y, z);
                    int id = this.getBlockType(pt);
                    if (BlockType.canPassThrough(id)) continue;
                    if (id != 3 || !this.setBlock(pt, grass)) continue block1;
                    ++affected;
                    continue block1;
                }
            }
        }
        return affected;
    }

    public boolean setChanceBlockIfAir(Vector pos, BaseBlock block, double c) throws MaxChangedBlocksException {
        if (Math.random() <= c) {
            return this.setBlockIfAir(pos, block);
        }
        return false;
    }

    private void makePumpkinPatch(Vector basePos) throws MaxChangedBlocksException {
        BaseBlock leavesBlock = new BaseBlock(18);
        this.setBlockIfAir(basePos, leavesBlock);
        this.makePumpkinPatchVine(basePos, basePos.add(0, 0, 1));
        this.makePumpkinPatchVine(basePos, basePos.add(0, 0, -1));
        this.makePumpkinPatchVine(basePos, basePos.add(1, 0, 0));
        this.makePumpkinPatchVine(basePos, basePos.add(-1, 0, 0));
    }

    private void makePumpkinPatchVine(Vector basePos, Vector pos) throws MaxChangedBlocksException {
        Vector testPos;
        if (pos.distance(basePos) > 4.0) {
            return;
        }
        if (this.getBlockType(pos) != 0) {
            return;
        }
        for (int i = -1; i > -3 && this.getBlockType(testPos = pos.add(0, i, 0)) == 0; --i) {
            pos = testPos;
        }
        this.setBlockIfAir(pos, new BaseBlock(18));
        int t = prng.nextInt(4);
        int h = prng.nextInt(3) - 1;
        BaseBlock log = new BaseBlock(17);
        BaseBlock pumpkin = new BaseBlock(86);
        switch (t) {
            case 0: {
                if (prng.nextBoolean()) {
                    this.makePumpkinPatchVine(basePos, pos.add(1, 0, 0));
                }
                if (prng.nextBoolean()) {
                    this.setBlockIfAir(pos.add(1, h, -1), log);
                }
                this.setBlockIfAir(pos.add(0, 0, -1), pumpkin);
                break;
            }
            case 1: {
                if (prng.nextBoolean()) {
                    this.makePumpkinPatchVine(basePos, pos.add(0, 0, 1));
                }
                if (prng.nextBoolean()) {
                    this.setBlockIfAir(pos.add(1, h, 0), log);
                }
                this.setBlockIfAir(pos.add(1, 0, 1), pumpkin);
                break;
            }
            case 2: {
                if (prng.nextBoolean()) {
                    this.makePumpkinPatchVine(basePos, pos.add(0, 0, -1));
                }
                if (prng.nextBoolean()) {
                    this.setBlockIfAir(pos.add(-1, h, 0), log);
                }
                this.setBlockIfAir(pos.add(-1, 0, 1), pumpkin);
                break;
            }
            case 3: {
                if (prng.nextBoolean()) {
                    this.makePumpkinPatchVine(basePos, pos.add(-1, 0, 0));
                }
                if (prng.nextBoolean()) {
                    this.setBlockIfAir(pos.add(-1, h, -1), log);
                }
                this.setBlockIfAir(pos.add(-1, 0, -1), pumpkin);
            }
        }
    }

    public int makePumpkinPatches(Vector basePos, int size) throws MaxChangedBlocksException {
        int affected = 0;
        for (int x = basePos.getBlockX() - size; x <= basePos.getBlockX() + size; ++x) {
            block1: for (int z = basePos.getBlockZ() - size; z <= basePos.getBlockZ() + size; ++z) {
                if (!this.getBlock(new Vector(x, basePos.getBlockY(), z)).isAir() || Math.random() < 0.98) continue;
                for (int y = basePos.getBlockY(); y >= basePos.getBlockY() - 10; --y) {
                    int t = this.getBlock(new Vector(x, y, z)).getType();
                    if (t == 2 || t == 3) {
                        this.makePumpkinPatch(new Vector(x, y + 1, z));
                        ++affected;
                        continue block1;
                    }
                    if (t != 0) continue block1;
                }
            }
        }
        return affected;
    }

    public int makeForest(Vector basePos, int size, double density, TreeGenerator treeGenerator) throws MaxChangedBlocksException {
        int affected = 0;
        for (int x = basePos.getBlockX() - size; x <= basePos.getBlockX() + size; ++x) {
            block1: for (int z = basePos.getBlockZ() - size; z <= basePos.getBlockZ() + size; ++z) {
                if (!this.getBlock(new Vector(x, basePos.getBlockY(), z)).isAir() || Math.random() >= density) continue;
                for (int y = basePos.getBlockY(); y >= basePos.getBlockY() - 10; --y) {
                    int t = this.getBlock(new Vector(x, y, z)).getType();
                    if (t == 2 || t == 3) {
                        treeGenerator.generate(this, new Vector(x, y + 1, z));
                        ++affected;
                        continue block1;
                    }
                    if (t != 0) continue block1;
                }
            }
        }
        return affected;
    }

    public int countBlocks(Region region, Set<Integer> searchIDs) {
        int count = 0;
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Vector pt = new Vector(x, y, z);
                        if (!searchIDs.contains(this.getBlockType(pt))) continue;
                        ++count;
                    }
                }
            }
        } else {
            for (BlockVector pt : region) {
                if (!searchIDs.contains(this.getBlockType(pt))) continue;
                ++count;
            }
        }
        return count;
    }

    public List<Countable<Integer>> getBlockDistribution(Region region) {
        ArrayList<Countable<Integer>> distribution = new ArrayList<Countable<Integer>>();
        HashMap<Integer, Countable<Integer>> map = new HashMap<Integer, Countable<Integer>>();
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Vector pt = new Vector(x, y, z);
                        int id = this.getBlockType(pt);
                        if (map.containsKey(id)) {
                            ((Countable)map.get(id)).increment();
                            continue;
                        }
                        Countable<Integer> c = new Countable<Integer>(id, 1);
                        map.put(id, c);
                        distribution.add(c);
                    }
                }
            }
        } else {
            for (BlockVector pt : region) {
                int id = this.getBlockType(pt);
                if (map.containsKey(id)) {
                    ((Countable)map.get(id)).increment();
                    continue;
                }
                Countable<Integer> c = new Countable<Integer>(id, 1);
                map.put(id, c);
            }
        }
        Collections.sort(distribution);
        return distribution;
    }

    public int getHighestTerrainBlock(int x, int z, int minY, int maxY) {
        return this.getHighestTerrainBlock(x, z, minY, maxY, false);
    }

    public int getHighestTerrainBlock(int x, int z, int minY, int maxY, boolean naturalOnly) {
        for (int y = maxY; y >= minY; --y) {
            Vector pt = new Vector(x, y, z);
            int id = this.getBlockType(pt);
            if (!(naturalOnly ? BlockType.isNaturalTerrainBlock(id) : !BlockType.canPassThrough(id))) continue;
            return y;
        }
        return minY;
    }

    public Set<Integer> popMissingBlocks() {
        Set<Integer> missingBlocks = this.missingBlocks;
        this.missingBlocks = new HashSet<Integer>();
        return missingBlocks;
    }

    public BlockBag getBlockBag() {
        return this.blockBag;
    }

    public void setBlockBag(BlockBag blockBag) {
        this.blockBag = blockBag;
    }

    public LocalWorld getWorld() {
        return this.world;
    }

    public int getBlockChangeCount() {
        return this.original.size();
    }

    public Mask getMask() {
        return this.mask;
    }

    public void setMask(Mask mask) {
        this.mask = mask;
    }
}

