/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bags;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bags.BlockBagException;
import com.sk89q.worldedit.bags.OutOfBlocksException;
import com.sk89q.worldedit.bags.UnplaceableBlockException;
import com.sk89q.worldedit.blocks.BlockType;

public abstract class BlockBag {
    public void storeDroppedBlock(int id) throws BlockBagException {
        int dropped = BlockType.getDroppedBlock(id);
        if (dropped > 0) {
            this.storeBlock(dropped);
        }
    }

    public void fetchPlacedBlock(int id) throws BlockBagException {
        try {
            switch (id) {
                case 7: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 46: 
                case 52: 
                case 56: 
                case 59: 
                case 73: 
                case 74: 
                case 78: 
                case 89: 
                case 90: {
                    throw new UnplaceableBlockException();
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    return;
                }
            }
            this.fetchBlock(id);
        }
        catch (OutOfBlocksException e) {
            switch (id) {
                case 1: {
                    this.fetchBlock(4);
                    break;
                }
                case 2: {
                    this.fetchBlock(3);
                    break;
                }
                case 55: {
                    this.fetchBlock(331);
                    break;
                }
                case 75: {
                    this.fetchBlock(76);
                    break;
                }
                case 63: 
                case 68: {
                    this.fetchBlock(323);
                    break;
                }
                default: {
                    throw e;
                }
            }
        }
    }

    public abstract void fetchBlock(int var1) throws BlockBagException;

    public abstract void storeBlock(int var1) throws BlockBagException;

    public boolean peekBlock(int id) {
        try {
            this.fetchBlock(id);
            this.storeBlock(id);
            return true;
        }
        catch (BlockBagException e) {
            return false;
        }
    }

    public abstract void flushChanges();

    public abstract void addSourcePosition(Vector var1);

    public abstract void addSingleSourcePosition(Vector var1);
}

