/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.blocks;

import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.PlayerDirection;
import com.sk89q.worldedit.blocks.BaseItemStack;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BlockType
extends Enum<BlockType> {
    public static final /* enum */ BlockType AIR;
    public static final /* enum */ BlockType STONE;
    public static final /* enum */ BlockType GRASS;
    public static final /* enum */ BlockType DIRT;
    public static final /* enum */ BlockType COBBLESTONE;
    public static final /* enum */ BlockType WOOD;
    public static final /* enum */ BlockType SAPLING;
    public static final /* enum */ BlockType BEDROCK;
    public static final /* enum */ BlockType WATER;
    public static final /* enum */ BlockType STATIONARY_WATER;
    public static final /* enum */ BlockType LAVA;
    public static final /* enum */ BlockType STATIONARY_LAVA;
    public static final /* enum */ BlockType SAND;
    public static final /* enum */ BlockType GRAVEL;
    public static final /* enum */ BlockType GOLD_ORE;
    public static final /* enum */ BlockType IRON_ORE;
    public static final /* enum */ BlockType COAL_ORE;
    public static final /* enum */ BlockType LOG;
    public static final /* enum */ BlockType LEAVES;
    public static final /* enum */ BlockType SPONGE;
    public static final /* enum */ BlockType GLASS;
    public static final /* enum */ BlockType LAPIS_LAZULI_ORE;
    public static final /* enum */ BlockType LAPIS_LAZULI;
    public static final /* enum */ BlockType DISPENSER;
    public static final /* enum */ BlockType SANDSTONE;
    public static final /* enum */ BlockType NOTE_BLOCK;
    public static final /* enum */ BlockType BED;
    public static final /* enum */ BlockType POWERED_RAIL;
    public static final /* enum */ BlockType DETECTOR_RAIL;
    public static final /* enum */ BlockType PISTON_STICKY_BASE;
    public static final /* enum */ BlockType WEB;
    public static final /* enum */ BlockType LONG_GRASS;
    public static final /* enum */ BlockType DEAD_BUSH;
    public static final /* enum */ BlockType PISTON_BASE;
    public static final /* enum */ BlockType PISTON_EXTENSION;
    public static final /* enum */ BlockType CLOTH;
    public static final /* enum */ BlockType PISTON_MOVING_PIECE;
    public static final /* enum */ BlockType YELLOW_FLOWER;
    public static final /* enum */ BlockType RED_FLOWER;
    public static final /* enum */ BlockType BROWN_MUSHROOM;
    public static final /* enum */ BlockType RED_MUSHROOM;
    public static final /* enum */ BlockType GOLD_BLOCK;
    public static final /* enum */ BlockType IRON_BLOCK;
    public static final /* enum */ BlockType DOUBLE_STEP;
    public static final /* enum */ BlockType STEP;
    public static final /* enum */ BlockType BRICK;
    public static final /* enum */ BlockType TNT;
    public static final /* enum */ BlockType BOOKCASE;
    public static final /* enum */ BlockType MOSSY_COBBLESTONE;
    public static final /* enum */ BlockType OBSIDIAN;
    public static final /* enum */ BlockType TORCH;
    public static final /* enum */ BlockType FIRE;
    public static final /* enum */ BlockType MOB_SPAWNER;
    public static final /* enum */ BlockType WOODEN_STAIRS;
    public static final /* enum */ BlockType CHEST;
    public static final /* enum */ BlockType REDSTONE_WIRE;
    public static final /* enum */ BlockType DIAMOND_ORE;
    public static final /* enum */ BlockType DIAMOND_BLOCK;
    public static final /* enum */ BlockType WORKBENCH;
    public static final /* enum */ BlockType CROPS;
    public static final /* enum */ BlockType SOIL;
    public static final /* enum */ BlockType FURNACE;
    public static final /* enum */ BlockType BURNING_FURNACE;
    public static final /* enum */ BlockType SIGN_POST;
    public static final /* enum */ BlockType WOODEN_DOOR;
    public static final /* enum */ BlockType LADDER;
    public static final /* enum */ BlockType MINECART_TRACKS;
    public static final /* enum */ BlockType COBBLESTONE_STAIRS;
    public static final /* enum */ BlockType WALL_SIGN;
    public static final /* enum */ BlockType LEVER;
    public static final /* enum */ BlockType STONE_PRESSURE_PLATE;
    public static final /* enum */ BlockType IRON_DOOR;
    public static final /* enum */ BlockType WOODEN_PRESSURE_PLATE;
    public static final /* enum */ BlockType REDSTONE_ORE;
    public static final /* enum */ BlockType GLOWING_REDSTONE_ORE;
    public static final /* enum */ BlockType REDSTONE_TORCH_OFF;
    public static final /* enum */ BlockType REDSTONE_TORCH_ON;
    public static final /* enum */ BlockType STONE_BUTTON;
    public static final /* enum */ BlockType SNOW;
    public static final /* enum */ BlockType ICE;
    public static final /* enum */ BlockType SNOW_BLOCK;
    public static final /* enum */ BlockType CACTUS;
    public static final /* enum */ BlockType CLAY;
    public static final /* enum */ BlockType SUGAR_CANE;
    public static final /* enum */ BlockType JUKEBOX;
    public static final /* enum */ BlockType FENCE;
    public static final /* enum */ BlockType PUMPKIN;
    public static final /* enum */ BlockType NETHERRACK;
    public static final /* enum */ BlockType SOUL_SAND;
    public static final /* enum */ BlockType GLOWSTONE;
    public static final /* enum */ BlockType PORTAL;
    public static final /* enum */ BlockType JACK_O_LANTERN;
    public static final /* enum */ BlockType CAKE;
    public static final /* enum */ BlockType REDSTONE_REPEATER_OFF;
    public static final /* enum */ BlockType REDSTONE_REPEATER_ON;
    public static final /* enum */ BlockType LOCKED_CHEST;
    public static final /* enum */ BlockType TRAP_DOOR;
    public static final /* enum */ BlockType SILVERFISH_BLOCK;
    public static final /* enum */ BlockType STONE_BRICK;
    public static final /* enum */ BlockType RED_MUSHROOM_CAP;
    public static final /* enum */ BlockType BROWN_MUSHROOM_CAP;
    public static final /* enum */ BlockType IRON_BARS;
    public static final /* enum */ BlockType GLASS_PANE;
    public static final /* enum */ BlockType MELON_BLOCK;
    public static final /* enum */ BlockType PUMPKIN_STEM;
    public static final /* enum */ BlockType MELON_STEM;
    public static final /* enum */ BlockType VINE;
    public static final /* enum */ BlockType FENCE_GATE;
    public static final /* enum */ BlockType BRICK_STAIRS;
    public static final /* enum */ BlockType STONE_BRICK_STAIRS;
    private static final Map<Integer, BlockType> ids;
    private static final Map<String, BlockType> lookup;
    private final int id;
    private final String name;
    private final String[] lookupKeys;
    private static final Set<Integer> shouldPlaceLast;
    private static final Set<Integer> canPassThrough;
    private static final Set<Integer> usesData;
    private static final Set<Integer> isContainerBlock;
    private static final Set<Integer> isRedstoneBlock;
    private static final Set<Integer> canTransferRedstone;
    private static final Set<Integer> isRedstoneSource;
    private static final Set<Integer> isRailBlock;
    private static final Set<Integer> isNaturalTerrainBlock;
    private static final Map<Integer, Integer> blockDrops;
    private static final Random random;
    private static final Map<Integer, PlayerDirection> dataAttachments;
    private static final Map<Integer, PlayerDirection> nonDataAttachments;
    private static final /* synthetic */ BlockType[] $VALUES;

    public static BlockType[] values() {
        return (BlockType[])$VALUES.clone();
    }

    public static BlockType valueOf(String name) {
        return Enum.valueOf(BlockType.class, name);
    }

    private BlockType(int id, String name, String lookupKey) {
        this.id = id;
        this.name = name;
        this.lookupKeys = new String[]{lookupKey};
    }

    private BlockType(int id, String name, String ... lookupKeys) {
        this.id = id;
        this.name = name;
        this.lookupKeys = lookupKeys;
    }

    public static BlockType fromID(int id) {
        return ids.get(id);
    }

    public static BlockType lookup(String name) {
        return BlockType.lookup(name, true);
    }

    public static BlockType lookup(String name, boolean fuzzy) {
        String testName = name.replace(" ", "").toLowerCase();
        BlockType type = lookup.get(testName);
        if (type != null) {
            return type;
        }
        if (!fuzzy) {
            return null;
        }
        int minDist = -1;
        for (Map.Entry<String, BlockType> entry : lookup.entrySet()) {
            int dist;
            if (entry.getKey().charAt(0) != testName.charAt(0) || (dist = StringUtil.getLevenshteinDistance(entry.getKey(), testName)) >= minDist && minDist != -1 || dist >= 2) continue;
            minDist = dist;
            type = entry.getValue();
        }
        return type;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static boolean shouldPlaceLast(int id) {
        return shouldPlaceLast.contains(id);
    }

    public boolean shouldPlaceLast() {
        return shouldPlaceLast.contains(this.id);
    }

    public static boolean canPassThrough(int id) {
        return canPassThrough.contains(id);
    }

    public static boolean usesData(int id) {
        return usesData.contains(id);
    }

    public static boolean isContainerBlock(int id) {
        return isContainerBlock.contains(id);
    }

    public static boolean isRedstoneBlock(int id) {
        return isRedstoneBlock.contains(id);
    }

    public static boolean canTransferRedstone(int id) {
        return canTransferRedstone.contains(id);
    }

    public static boolean isRedstoneSource(int id) {
        return isRedstoneSource.contains(id);
    }

    public static boolean isRailBlock(int id) {
        return isRailBlock.contains(id);
    }

    public static boolean isNaturalTerrainBlock(int id) {
        return isNaturalTerrainBlock.contains(id);
    }

    @Deprecated
    public static int getDroppedBlock(int id) {
        Integer dropped = blockDrops.get(id);
        if (dropped == null) {
            return 0;
        }
        return dropped;
    }

    public static BaseItemStack getBlockDrop(int id, short data) {
        switch (id) {
            case 1: {
                return new BaseItemStack(4);
            }
            case 2: {
                return new BaseItemStack(3);
            }
            case 13: {
                if (random.nextDouble() >= 0.9) {
                    return new BaseItemStack(318);
                }
                return new BaseItemStack(13);
            }
            case 16: {
                return new BaseItemStack(263);
            }
            case 18: {
                if (random.nextDouble() > 0.95) {
                    return new BaseItemStack(6, 1, data);
                }
                return null;
            }
            case 21: {
                return new BaseItemStack(351, random.nextInt(5) + 4, 4);
            }
            case 26: {
                return new BaseItemStack(355);
            }
            case 31: {
                if (random.nextInt(8) == 0) {
                    return new BaseItemStack(295);
                }
                return null;
            }
            case 43: {
                return new BaseItemStack(44, 2, data);
            }
            case 53: {
                return new BaseItemStack(5);
            }
            case 55: {
                return new BaseItemStack(331);
            }
            case 56: {
                return new BaseItemStack(264);
            }
            case 59: {
                return new BaseItemStack(295);
            }
            case 60: {
                return new BaseItemStack(3);
            }
            case 62: {
                return new BaseItemStack(61);
            }
            case 63: {
                return new BaseItemStack(323);
            }
            case 64: {
                return new BaseItemStack(324);
            }
            case 67: {
                return new BaseItemStack(4);
            }
            case 68: {
                return new BaseItemStack(323);
            }
            case 71: {
                return new BaseItemStack(330);
            }
            case 73: 
            case 74: {
                return new BaseItemStack(331, random.nextInt(2) + 4);
            }
            case 75: {
                return new BaseItemStack(76);
            }
            case 82: {
                return new BaseItemStack(337, 4);
            }
            case 83: {
                return new BaseItemStack(338);
            }
            case 89: {
                return new BaseItemStack(348, random.nextInt(3) + 2);
            }
            case 93: 
            case 94: {
                return new BaseItemStack(356);
            }
            case 103: {
                return new BaseItemStack(360, random.nextInt(5) + 3);
            }
            case 104: {
                return new BaseItemStack(361);
            }
            case 105: {
                return new BaseItemStack(362);
            }
            case 0: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 34: 
            case 47: 
            case 51: 
            case 52: 
            case 78: 
            case 79: 
            case 90: 
            case 95: 
            case 97: 
            case 106: {
                return null;
            }
        }
        if (BlockType.usesData(id)) {
            return new BaseItemStack(id, 1, data);
        }
        return new BaseItemStack(id);
    }

    public static PlayerDirection getAttachment(int type, int data) {
        PlayerDirection direction = nonDataAttachments.get(type);
        if (direction != null) {
            return direction;
        }
        return dataAttachments.get(BlockType.attachmentKey(type, data));
    }

    private static int attachmentKey(int type, int data) {
        return type << 4 | data & 0xF;
    }

    private static void addCardinals(int type, int west, int north, int east, int south) {
        dataAttachments.put(BlockType.attachmentKey(type, west), PlayerDirection.WEST);
        dataAttachments.put(BlockType.attachmentKey(type, north), PlayerDirection.NORTH);
        dataAttachments.put(BlockType.attachmentKey(type, east), PlayerDirection.EAST);
        dataAttachments.put(BlockType.attachmentKey(type, south), PlayerDirection.SOUTH);
    }

    static {
        int offset;
        AIR = new BlockType(0, "Air", "air");
        STONE = new BlockType(1, "Stone", "stone", "rock");
        GRASS = new BlockType(2, "Grass", "grass");
        DIRT = new BlockType(3, "Dirt", "dirt");
        COBBLESTONE = new BlockType(4, "Cobblestone", "cobblestone", "cobble");
        WOOD = new BlockType(5, "Wood", "wood", "woodplank", "plank", "woodplanks", "planks");
        SAPLING = new BlockType(6, "Sapling", "sapling", "seedling");
        BEDROCK = new BlockType(7, "Bedrock", "adminium", "bedrock");
        WATER = new BlockType(8, "Water", "watermoving", "movingwater", "flowingwater", "waterflowing");
        STATIONARY_WATER = new BlockType(9, "Water (stationary)", "water", "waterstationary", "stationarywater", "stillwater");
        LAVA = new BlockType(10, "Lava", "lavamoving", "movinglava", "flowinglava", "lavaflowing");
        STATIONARY_LAVA = new BlockType(11, "Lava (stationary)", "lava", "lavastationary", "stationarylava", "stilllava");
        SAND = new BlockType(12, "Sand", "sand");
        GRAVEL = new BlockType(13, "Gravel", "gravel");
        GOLD_ORE = new BlockType(14, "Gold ore", "goldore");
        IRON_ORE = new BlockType(15, "Iron ore", "ironore");
        COAL_ORE = new BlockType(16, "Coal ore", "coalore");
        LOG = new BlockType(17, "Log", "log", "tree", "pine", "oak", "birch", "redwood");
        LEAVES = new BlockType(18, "Leaves", "leaves", "leaf");
        SPONGE = new BlockType(19, "Sponge", "sponge");
        GLASS = new BlockType(20, "Glass", "glass");
        LAPIS_LAZULI_ORE = new BlockType(21, "Lapis lazuli ore", "lapislazuliore", "blueore", "lapisore");
        LAPIS_LAZULI = new BlockType(22, "Lapis lazuli", "lapislazuli", "lapislazuliblock", "bluerock");
        DISPENSER = new BlockType(23, "Dispenser", "dispenser");
        SANDSTONE = new BlockType(24, "Sandstone", "sandstone");
        NOTE_BLOCK = new BlockType(25, "Note block", "musicblock", "noteblock", "note", "music", "instrument");
        BED = new BlockType(26, "Bed", "bed");
        POWERED_RAIL = new BlockType(27, "Powered Rail", "poweredrail", "boosterrail", "poweredtrack", "boostertrack", "booster");
        DETECTOR_RAIL = new BlockType(28, "Detector Rail", "detectorrail", "detector");
        PISTON_STICKY_BASE = new BlockType(29, "Sticky Piston", "stickypiston");
        WEB = new BlockType(30, "Web", "web", "spiderweb");
        LONG_GRASS = new BlockType(31, "Long grass", "longgrass", "tallgrass");
        DEAD_BUSH = new BlockType(32, "Shrub", "deadbush", "shrub", "deadshrub", "tumbleweed");
        PISTON_BASE = new BlockType(33, "Piston", "piston");
        PISTON_EXTENSION = new BlockType(34, "Piston extension", "pistonextendsion", "pistonhead");
        CLOTH = new BlockType(35, "Wool", "cloth", "wool");
        PISTON_MOVING_PIECE = new BlockType(36, "Piston moving piece", "movingpiston");
        YELLOW_FLOWER = new BlockType(37, "Yellow flower", "yellowflower", "flower");
        RED_FLOWER = new BlockType(38, "Red rose", "redflower", "redrose", "rose");
        BROWN_MUSHROOM = new BlockType(39, "Brown mushroom", "brownmushroom", "mushroom");
        RED_MUSHROOM = new BlockType(40, "Red mushroom", "redmushroom");
        GOLD_BLOCK = new BlockType(41, "Gold block", "gold", "goldblock");
        IRON_BLOCK = new BlockType(42, "Iron block", "iron", "ironblock");
        DOUBLE_STEP = new BlockType(43, "Double step", "doubleslab", "doublestoneslab", "doublestep");
        STEP = new BlockType(44, "Step", "slab", "stoneslab", "step", "halfstep");
        BRICK = new BlockType(45, "Brick", "brick", "brickblock");
        TNT = new BlockType(46, "TNT", "tnt", "c4", "explosive");
        BOOKCASE = new BlockType(47, "Bookcase", "bookshelf", "bookshelves", "bookcase", "bookcases");
        MOSSY_COBBLESTONE = new BlockType(48, "Cobblestone (mossy)", "mossycobblestone", "mossstone", "mossystone", "mosscobble", "mossycobble", "moss", "mossy", "sossymobblecone");
        OBSIDIAN = new BlockType(49, "Obsidian", "obsidian");
        TORCH = new BlockType(50, "Torch", "torch", "light", "candle");
        FIRE = new BlockType(51, "Fire", "fire", "flame", "flames");
        MOB_SPAWNER = new BlockType(52, "Mob spawner", "mobspawner", "spawner");
        WOODEN_STAIRS = new BlockType(53, "Wooden stairs", "woodstair", "woodstairs", "woodenstair", "woodenstairs");
        CHEST = new BlockType(54, "Chest", "chest", "storage", "storagechest");
        REDSTONE_WIRE = new BlockType(55, "Redstone wire", "redstone", "redstoneblock");
        DIAMOND_ORE = new BlockType(56, "Diamond ore", "diamondore");
        DIAMOND_BLOCK = new BlockType(57, "Diamond block", "diamond", "diamondblock");
        WORKBENCH = new BlockType(58, "Workbench", "workbench", "table", "craftingtable", "crafting");
        CROPS = new BlockType(59, "Crops", "crops", "crop", "plant", "plants");
        SOIL = new BlockType(60, "Soil", "soil", "farmland");
        FURNACE = new BlockType(61, "Furnace", "furnace");
        BURNING_FURNACE = new BlockType(62, "Furnace (burning)", "burningfurnace", "litfurnace");
        SIGN_POST = new BlockType(63, "Sign post", "sign", "signpost");
        WOODEN_DOOR = new BlockType(64, "Wooden door", "wooddoor", "woodendoor", "door");
        LADDER = new BlockType(65, "Ladder", "ladder");
        MINECART_TRACKS = new BlockType(66, "Minecart tracks", "track", "tracks", "minecrattrack", "minecarttracks", "rails", "rail");
        COBBLESTONE_STAIRS = new BlockType(67, "Cobblestone stairs", "cobblestonestair", "cobblestonestairs", "cobblestair", "cobblestairs");
        WALL_SIGN = new BlockType(68, "Wall sign", "wallsign");
        LEVER = new BlockType(69, "Lever", "lever", "switch", "stonelever", "stoneswitch");
        STONE_PRESSURE_PLATE = new BlockType(70, "Stone pressure plate", "stonepressureplate", "stoneplate");
        IRON_DOOR = new BlockType(71, "Iron Door", "irondoor");
        WOODEN_PRESSURE_PLATE = new BlockType(72, "Wooden pressure plate", "woodpressureplate", "woodplate", "woodenpressureplate", "woodenplate", "plate", "pressureplate");
        REDSTONE_ORE = new BlockType(73, "Redstone ore", "redstoneore");
        GLOWING_REDSTONE_ORE = new BlockType(74, "Glowing redstone ore", "glowingredstoneore");
        REDSTONE_TORCH_OFF = new BlockType(75, "Redstone torch (off)", "redstonetorchoff", "rstorchoff");
        REDSTONE_TORCH_ON = new BlockType(76, "Redstone torch (on)", "redstonetorch", "redstonetorchon", "rstorchon", "redtorch");
        STONE_BUTTON = new BlockType(77, "Stone Button", "stonebutton", "button");
        SNOW = new BlockType(78, "Snow", "snow");
        ICE = new BlockType(79, "Ice", "ice");
        SNOW_BLOCK = new BlockType(80, "Snow block", "snowblock");
        CACTUS = new BlockType(81, "Cactus", "cactus", "cacti");
        CLAY = new BlockType(82, "Clay", "clay");
        SUGAR_CANE = new BlockType(83, "Reed", "reed", "cane", "sugarcane", "sugarcanes", "vine", "vines");
        JUKEBOX = new BlockType(84, "Jukebox", "jukebox", "stereo", "recordplayer");
        FENCE = new BlockType(85, "Fence", "fence");
        PUMPKIN = new BlockType(86, "Pumpkin", "pumpkin");
        NETHERRACK = new BlockType(87, "Netherrack", "redmossycobblestone", "redcobblestone", "redmosstone", "redcobble", "netherstone", "netherrack", "nether", "hellstone");
        SOUL_SAND = new BlockType(88, "Soul sand", "slowmud", "mud", "soulsand", "hellmud");
        GLOWSTONE = new BlockType(89, "Glowstone", "brittlegold", "glowstone", "lightstone", "brimstone", "australium");
        PORTAL = new BlockType(90, "Portal", "portal");
        JACK_O_LANTERN = new BlockType(91, "Pumpkin (on)", "pumpkinlighted", "pumpkinon", "litpumpkin", "jackolantern");
        CAKE = new BlockType(92, "Cake", "cake", "cakeblock");
        REDSTONE_REPEATER_OFF = new BlockType(93, "Redstone repeater (off)", "diodeoff", "redstonerepeater", "repeateroff", "delayeroff");
        REDSTONE_REPEATER_ON = new BlockType(94, "Redstone repeater (on)", "diodeon", "redstonerepeateron", "repeateron", "delayeron");
        LOCKED_CHEST = new BlockType(95, "Locked chest", "lockedchest", "steveco", "supplycrate", "valveneedstoworkonep3nottf2kthx");
        TRAP_DOOR = new BlockType(96, "Trap door", "trapdoor", "hatch", "floordoor");
        SILVERFISH_BLOCK = new BlockType(97, "Silverfish block", "silverfish", "silver");
        STONE_BRICK = new BlockType(98, "Stone brick", "stonebrick", "sbrick", "smoothstonebrick");
        RED_MUSHROOM_CAP = new BlockType(100, "Red mushroom cap", "giantmushroomred", "redgiantmushroom", "redmushroomcap");
        BROWN_MUSHROOM_CAP = new BlockType(99, "Brown mushroom cap", "giantmushroombrown", "browngiantmushoom", "brownmushroomcap");
        IRON_BARS = new BlockType(101, "Iron bars", "ironbars", "ironfence");
        GLASS_PANE = new BlockType(102, "Glass pane", "window", "glasspane", "glasswindow");
        MELON_BLOCK = new BlockType(103, "Melon (block)", "melonblock");
        PUMPKIN_STEM = new BlockType(104, "Pumpkin stem", "pumpkinstem");
        MELON_STEM = new BlockType(105, "Melon stem", "melonstem");
        VINE = new BlockType(106, "Vine", "vine", "vines", "creepers");
        FENCE_GATE = new BlockType(107, "Fence gate", "fencegate", "gate");
        BRICK_STAIRS = new BlockType(108, "Brick stairs", "brickstairs", "bricksteps");
        STONE_BRICK_STAIRS = new BlockType(109, "Stone brick stairs", "stonebrickstairs", "smoothstonebrickstairs");
        $VALUES = new BlockType[]{AIR, STONE, GRASS, DIRT, COBBLESTONE, WOOD, SAPLING, BEDROCK, WATER, STATIONARY_WATER, LAVA, STATIONARY_LAVA, SAND, GRAVEL, GOLD_ORE, IRON_ORE, COAL_ORE, LOG, LEAVES, SPONGE, GLASS, LAPIS_LAZULI_ORE, LAPIS_LAZULI, DISPENSER, SANDSTONE, NOTE_BLOCK, BED, POWERED_RAIL, DETECTOR_RAIL, PISTON_STICKY_BASE, WEB, LONG_GRASS, DEAD_BUSH, PISTON_BASE, PISTON_EXTENSION, CLOTH, PISTON_MOVING_PIECE, YELLOW_FLOWER, RED_FLOWER, BROWN_MUSHROOM, RED_MUSHROOM, GOLD_BLOCK, IRON_BLOCK, DOUBLE_STEP, STEP, BRICK, TNT, BOOKCASE, MOSSY_COBBLESTONE, OBSIDIAN, TORCH, FIRE, MOB_SPAWNER, WOODEN_STAIRS, CHEST, REDSTONE_WIRE, DIAMOND_ORE, DIAMOND_BLOCK, WORKBENCH, CROPS, SOIL, FURNACE, BURNING_FURNACE, SIGN_POST, WOODEN_DOOR, LADDER, MINECART_TRACKS, COBBLESTONE_STAIRS, WALL_SIGN, LEVER, STONE_PRESSURE_PLATE, IRON_DOOR, WOODEN_PRESSURE_PLATE, REDSTONE_ORE, GLOWING_REDSTONE_ORE, REDSTONE_TORCH_OFF, REDSTONE_TORCH_ON, STONE_BUTTON, SNOW, ICE, SNOW_BLOCK, CACTUS, CLAY, SUGAR_CANE, JUKEBOX, FENCE, PUMPKIN, NETHERRACK, SOUL_SAND, GLOWSTONE, PORTAL, JACK_O_LANTERN, CAKE, REDSTONE_REPEATER_OFF, REDSTONE_REPEATER_ON, LOCKED_CHEST, TRAP_DOOR, SILVERFISH_BLOCK, STONE_BRICK, RED_MUSHROOM_CAP, BROWN_MUSHROOM_CAP, IRON_BARS, GLASS_PANE, MELON_BLOCK, PUMPKIN_STEM, MELON_STEM, VINE, FENCE_GATE, BRICK_STAIRS, STONE_BRICK_STAIRS};
        ids = new HashMap<Integer, BlockType>();
        lookup = new HashMap<String, BlockType>();
        for (BlockType type : EnumSet.allOf(BlockType.class)) {
            ids.put(type.id, type);
            for (String key : type.lookupKeys) {
                lookup.put(key, type);
            }
        }
        shouldPlaceLast = new HashSet<Integer>();
        shouldPlaceLast.add(6);
        shouldPlaceLast.add(26);
        shouldPlaceLast.add(27);
        shouldPlaceLast.add(28);
        shouldPlaceLast.add(31);
        shouldPlaceLast.add(32);
        shouldPlaceLast.add(34);
        shouldPlaceLast.add(37);
        shouldPlaceLast.add(38);
        shouldPlaceLast.add(39);
        shouldPlaceLast.add(40);
        shouldPlaceLast.add(50);
        shouldPlaceLast.add(51);
        shouldPlaceLast.add(55);
        shouldPlaceLast.add(59);
        shouldPlaceLast.add(63);
        shouldPlaceLast.add(64);
        shouldPlaceLast.add(65);
        shouldPlaceLast.add(66);
        shouldPlaceLast.add(68);
        shouldPlaceLast.add(69);
        shouldPlaceLast.add(70);
        shouldPlaceLast.add(71);
        shouldPlaceLast.add(72);
        shouldPlaceLast.add(75);
        shouldPlaceLast.add(76);
        shouldPlaceLast.add(77);
        shouldPlaceLast.add(78);
        shouldPlaceLast.add(81);
        shouldPlaceLast.add(83);
        shouldPlaceLast.add(90);
        shouldPlaceLast.add(92);
        shouldPlaceLast.add(93);
        shouldPlaceLast.add(94);
        shouldPlaceLast.add(96);
        shouldPlaceLast.add(106);
        canPassThrough = new HashSet<Integer>();
        canPassThrough.add(0);
        canPassThrough.add(8);
        canPassThrough.add(9);
        canPassThrough.add(6);
        canPassThrough.add(27);
        canPassThrough.add(28);
        canPassThrough.add(30);
        canPassThrough.add(31);
        canPassThrough.add(32);
        canPassThrough.add(37);
        canPassThrough.add(38);
        canPassThrough.add(39);
        canPassThrough.add(40);
        canPassThrough.add(50);
        canPassThrough.add(51);
        canPassThrough.add(55);
        canPassThrough.add(59);
        canPassThrough.add(63);
        canPassThrough.add(65);
        canPassThrough.add(66);
        canPassThrough.add(68);
        canPassThrough.add(69);
        canPassThrough.add(70);
        canPassThrough.add(72);
        canPassThrough.add(75);
        canPassThrough.add(76);
        canPassThrough.add(77);
        canPassThrough.add(78);
        canPassThrough.add(83);
        canPassThrough.add(90);
        canPassThrough.add(93);
        canPassThrough.add(94);
        canPassThrough.add(106);
        usesData = new HashSet<Integer>();
        usesData.add(6);
        usesData.add(8);
        usesData.add(9);
        usesData.add(10);
        usesData.add(11);
        usesData.add(17);
        usesData.add(18);
        usesData.add(23);
        usesData.add(25);
        usesData.add(26);
        usesData.add(27);
        usesData.add(28);
        usesData.add(29);
        usesData.add(31);
        usesData.add(33);
        usesData.add(34);
        usesData.add(35);
        usesData.add(43);
        usesData.add(44);
        usesData.add(50);
        usesData.add(53);
        usesData.add(55);
        usesData.add(59);
        usesData.add(60);
        usesData.add(61);
        usesData.add(62);
        usesData.add(63);
        usesData.add(64);
        usesData.add(65);
        usesData.add(66);
        usesData.add(67);
        usesData.add(68);
        usesData.add(69);
        usesData.add(70);
        usesData.add(71);
        usesData.add(72);
        usesData.add(75);
        usesData.add(76);
        usesData.add(77);
        usesData.add(78);
        usesData.add(81);
        usesData.add(86);
        usesData.add(91);
        usesData.add(92);
        usesData.add(93);
        usesData.add(94);
        usesData.add(96);
        usesData.add(97);
        usesData.add(98);
        usesData.add(100);
        usesData.add(99);
        usesData.add(104);
        usesData.add(105);
        usesData.add(106);
        usesData.add(107);
        usesData.add(108);
        usesData.add(109);
        isContainerBlock = new HashSet<Integer>();
        isContainerBlock.add(23);
        isContainerBlock.add(61);
        isContainerBlock.add(62);
        isContainerBlock.add(54);
        isRedstoneBlock = new HashSet<Integer>();
        isRedstoneBlock.add(27);
        isRedstoneBlock.add(28);
        isRedstoneBlock.add(29);
        isRedstoneBlock.add(33);
        isRedstoneBlock.add(69);
        isRedstoneBlock.add(70);
        isRedstoneBlock.add(72);
        isRedstoneBlock.add(75);
        isRedstoneBlock.add(76);
        isRedstoneBlock.add(77);
        isRedstoneBlock.add(55);
        isRedstoneBlock.add(64);
        isRedstoneBlock.add(71);
        isRedstoneBlock.add(46);
        isRedstoneBlock.add(23);
        isRedstoneBlock.add(25);
        isRedstoneBlock.add(93);
        isRedstoneBlock.add(94);
        canTransferRedstone = new HashSet<Integer>();
        canTransferRedstone.add(75);
        canTransferRedstone.add(76);
        canTransferRedstone.add(55);
        canTransferRedstone.add(93);
        canTransferRedstone.add(94);
        isRedstoneSource = new HashSet<Integer>();
        isRedstoneSource.add(28);
        isRedstoneSource.add(75);
        isRedstoneSource.add(76);
        isRedstoneSource.add(69);
        isRedstoneSource.add(70);
        isRedstoneSource.add(72);
        isRedstoneSource.add(77);
        isRailBlock = new HashSet<Integer>();
        isRailBlock.add(27);
        isRailBlock.add(28);
        isRailBlock.add(66);
        isNaturalTerrainBlock = new HashSet<Integer>();
        isNaturalTerrainBlock.add(1);
        isNaturalTerrainBlock.add(2);
        isNaturalTerrainBlock.add(3);
        isNaturalTerrainBlock.add(7);
        isNaturalTerrainBlock.add(12);
        isNaturalTerrainBlock.add(13);
        isNaturalTerrainBlock.add(82);
        isNaturalTerrainBlock.add(87);
        isNaturalTerrainBlock.add(88);
        isNaturalTerrainBlock.add(89);
        isNaturalTerrainBlock.add(16);
        isNaturalTerrainBlock.add(15);
        isNaturalTerrainBlock.add(14);
        isNaturalTerrainBlock.add(21);
        isNaturalTerrainBlock.add(56);
        isNaturalTerrainBlock.add(73);
        isNaturalTerrainBlock.add(74);
        blockDrops = new HashMap<Integer, Integer>();
        blockDrops.put(1, 4);
        blockDrops.put(2, 3);
        blockDrops.put(3, 3);
        blockDrops.put(4, 4);
        blockDrops.put(5, 5);
        blockDrops.put(6, 6);
        blockDrops.put(7, -1);
        blockDrops.put(12, 12);
        blockDrops.put(13, 13);
        blockDrops.put(14, 14);
        blockDrops.put(15, 15);
        blockDrops.put(16, 16);
        blockDrops.put(17, 17);
        blockDrops.put(18, 18);
        blockDrops.put(19, 19);
        blockDrops.put(20, 20);
        blockDrops.put(21, 21);
        blockDrops.put(22, 22);
        blockDrops.put(23, 23);
        blockDrops.put(24, 24);
        blockDrops.put(25, 25);
        blockDrops.put(26, 355);
        blockDrops.put(27, 27);
        blockDrops.put(28, 28);
        blockDrops.put(30, 30);
        blockDrops.put(34, -1);
        blockDrops.put(35, 35);
        blockDrops.put(36, -1);
        blockDrops.put(37, 37);
        blockDrops.put(38, 38);
        blockDrops.put(39, 39);
        blockDrops.put(40, 40);
        blockDrops.put(41, 41);
        blockDrops.put(42, 42);
        blockDrops.put(43, 43);
        blockDrops.put(44, 44);
        blockDrops.put(45, 45);
        blockDrops.put(47, 47);
        blockDrops.put(48, 48);
        blockDrops.put(49, 49);
        blockDrops.put(50, 50);
        blockDrops.put(53, 53);
        blockDrops.put(54, 54);
        blockDrops.put(55, 331);
        blockDrops.put(56, 264);
        blockDrops.put(57, 57);
        blockDrops.put(58, 58);
        blockDrops.put(59, 295);
        blockDrops.put(60, 60);
        blockDrops.put(61, 61);
        blockDrops.put(62, 61);
        blockDrops.put(63, 323);
        blockDrops.put(64, 324);
        blockDrops.put(65, 65);
        blockDrops.put(66, 66);
        blockDrops.put(67, 67);
        blockDrops.put(68, 323);
        blockDrops.put(69, 69);
        blockDrops.put(70, 70);
        blockDrops.put(71, 330);
        blockDrops.put(72, 72);
        blockDrops.put(73, 331);
        blockDrops.put(74, 331);
        blockDrops.put(75, 76);
        blockDrops.put(76, 76);
        blockDrops.put(77, 77);
        blockDrops.put(78, 332);
        blockDrops.put(79, 79);
        blockDrops.put(80, 80);
        blockDrops.put(82, 82);
        blockDrops.put(83, 338);
        blockDrops.put(84, 84);
        blockDrops.put(85, 85);
        blockDrops.put(86, 86);
        blockDrops.put(87, 87);
        blockDrops.put(88, 88);
        blockDrops.put(89, 348);
        blockDrops.put(91, 91);
        blockDrops.put(92, 354);
        blockDrops.put(93, 356);
        blockDrops.put(94, 356);
        blockDrops.put(95, 95);
        blockDrops.put(96, 96);
        blockDrops.put(97, -1);
        blockDrops.put(98, 98);
        blockDrops.put(99, 99);
        blockDrops.put(100, 100);
        blockDrops.put(101, 101);
        blockDrops.put(102, 102);
        blockDrops.put(103, 103);
        blockDrops.put(104, 104);
        blockDrops.put(105, 105);
        blockDrops.put(106, -1);
        blockDrops.put(107, 107);
        blockDrops.put(108, 45);
        blockDrops.put(109, 98);
        random = new Random();
        dataAttachments = new HashMap<Integer, PlayerDirection>();
        nonDataAttachments = new HashMap<Integer, PlayerDirection>();
        nonDataAttachments.put(6, PlayerDirection.DOWN);
        nonDataAttachments.put(27, PlayerDirection.DOWN);
        nonDataAttachments.put(28, PlayerDirection.DOWN);
        nonDataAttachments.put(31, PlayerDirection.DOWN);
        nonDataAttachments.put(32, PlayerDirection.DOWN);
        for (int offset2 = 0; offset2 <= 8; offset2 += 8) {
            dataAttachments.put(BlockType.attachmentKey(34, offset2 + 0), PlayerDirection.UP);
            dataAttachments.put(BlockType.attachmentKey(34, offset2 + 1), PlayerDirection.DOWN);
            BlockType.addCardinals(34, offset2 + 2, offset2 + 5, offset2 + 3, offset2 + 4);
        }
        nonDataAttachments.put(37, PlayerDirection.DOWN);
        nonDataAttachments.put(38, PlayerDirection.DOWN);
        nonDataAttachments.put(39, PlayerDirection.DOWN);
        nonDataAttachments.put(40, PlayerDirection.DOWN);
        for (int blockId : new int[]{50, 76, 75}) {
            dataAttachments.put(BlockType.attachmentKey(blockId, 5), PlayerDirection.DOWN);
            BlockType.addCardinals(blockId, 4, 1, 3, 2);
        }
        nonDataAttachments.put(55, PlayerDirection.DOWN);
        nonDataAttachments.put(59, PlayerDirection.DOWN);
        nonDataAttachments.put(63, PlayerDirection.DOWN);
        nonDataAttachments.put(64, PlayerDirection.DOWN);
        BlockType.addCardinals(65, 2, 5, 3, 4);
        nonDataAttachments.put(66, PlayerDirection.DOWN);
        BlockType.addCardinals(68, 2, 5, 3, 4);
        for (offset = 0; offset <= 8; offset += 8) {
            BlockType.addCardinals(69, offset + 4, offset + 1, offset + 3, offset + 2);
            dataAttachments.put(BlockType.attachmentKey(69, offset + 5), PlayerDirection.DOWN);
            dataAttachments.put(BlockType.attachmentKey(69, offset + 6), PlayerDirection.DOWN);
        }
        nonDataAttachments.put(70, PlayerDirection.DOWN);
        nonDataAttachments.put(71, PlayerDirection.DOWN);
        nonDataAttachments.put(72, PlayerDirection.DOWN);
        for (offset = 0; offset <= 8; offset += 8) {
            BlockType.addCardinals(77, offset + 4, offset + 1, offset + 3, offset + 2);
        }
        nonDataAttachments.put(81, PlayerDirection.DOWN);
        nonDataAttachments.put(83, PlayerDirection.DOWN);
        nonDataAttachments.put(92, PlayerDirection.DOWN);
        nonDataAttachments.put(93, PlayerDirection.DOWN);
        nonDataAttachments.put(94, PlayerDirection.DOWN);
        for (offset = 0; offset <= 4; offset += 4) {
            BlockType.addCardinals(96, offset + 0, offset + 3, offset + 1, offset + 2);
        }
        nonDataAttachments.put(104, PlayerDirection.DOWN);
        nonDataAttachments.put(105, PlayerDirection.DOWN);
        dataAttachments.put(BlockType.attachmentKey(106, 0), PlayerDirection.UP);
        BlockType.addCardinals(106, 1, 2, 4, 8);
    }
}

