/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.tools;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.tools.BlockTool;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatingTreeRemover
implements BlockTool {
    private static final BaseBlock air = new BaseBlock(0);
    private int range = 100;

    @Override
    public boolean canUse(LocalPlayer player) {
        return player.hasPermission("worldedit.tool.deltree");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean actPrimary(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session, WorldVector clicked) {
        HashSet<BlockVector> blockSet;
        EditSession editSession;
        block7: {
            LocalWorld world = clicked.getWorld();
            int initialType = world.getBlockType(clicked);
            editSession = session.createEditSession(player);
            if (initialType != 17 && initialType != 18 && initialType != 99 && initialType != 100) {
                player.printError("That's not a floating tree.");
                return true;
            }
            blockSet = new HashSet<BlockVector>();
            if (this.recurse(server, editSession, world, clicked.toBlockVector(), clicked, this.range, blockSet, 0)) break block7;
            player.printError("That's not a floating tree.");
            boolean bl = true;
            Object var14_13 = null;
            session.remember(editSession);
            return bl;
        }
        try {
            try {
                for (BlockVector blockVector : blockSet) {
                    int block = editSession.getBlock(blockVector).getType();
                    if (block != 17 && block != 18 && block != 99 && block != 100) continue;
                    editSession.setBlock((Vector)blockVector, air);
                }
                Object var14_14 = null;
                session.remember(editSession);
            }
            catch (MaxChangedBlocksException e) {
                player.printError("Max blocks change limit reached.");
                Object var14_15 = null;
                session.remember(editSession);
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            session.remember(editSession);
            throw throwable;
        }
        return true;
    }

    private boolean recurse(ServerInterface server, EditSession editSession, LocalWorld world, BlockVector pos, Vector origin, int size, Set<BlockVector> visited, int lastBlock) throws MaxChangedBlocksException {
        if (origin.distance(pos) > (double)size || visited.contains(pos)) {
            return true;
        }
        visited.add(pos);
        int block = editSession.getBlock(pos).getType();
        if (block == 0 || block == 78) {
            return true;
        }
        if (block != 17 && block != 18 && block != 99 && block != 100) {
            return lastBlock == 18;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (Math.abs(i) + Math.abs(j) + Math.abs(k) != 1 || this.recurse(server, editSession, world, pos.add(i, j, k).toBlockVector(), origin, size, visited, block)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

