/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.bukkit.migration;

import com.sk89q.bukkit.migration.ConfigurationPermissionsResolver;
import com.sk89q.bukkit.migration.DinnerPermsResolver;
import com.sk89q.bukkit.migration.FlatFilePermissionsResolver;
import com.sk89q.bukkit.migration.NijiPermissionsResolver;
import com.sk89q.bukkit.migration.PermissionsExResolver;
import com.sk89q.bukkit.migration.PermissionsProvider;
import com.sk89q.bukkit.migration.PermissionsResolver;
import com.sk89q.bukkit.migration.PermissionsResolverServerListener;
import com.sk89q.bukkit.migration.PluginPermissionsResolver;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.config.Configuration;

public class PermissionsResolverManager
implements PermissionsResolver {
    private static final String CONFIG_HEADER = "#\r\n# WEPIF Configuration File\r\n#\r\n# This file handles permissions configuration for every plugin using WEPIF\r\n#\r\n# About editing this file:\r\n# - DO NOT USE TABS. You MUST use spaces or Bukkit will complain. If\r\n#   you use an editor like Notepad++ (recommended for Windows users), you\r\n#   must configure it to \"replace tabs with spaces.\" In Notepad++, this can\r\n#   be changed in Settings > Preferences > Language Menu.\r\n# - Don't get rid of the indents. They are indented so some entries are\r\n#   in categories (like \"enforce-single-session\" is in the \"protection\"\r\n#   category.\r\n# - If you want to check the format of this file before putting it\r\n#   into WEPIF, paste it into http://yaml-online-parser.appspot.com/\r\n#   and see if it gives \"ERROR:\".\r\n# - Lines starting with # are comments and so they are ignored.\r\n#\r\n# About Configuration Permissions\r\n# - See http://wiki.sk89q.com/wiki/WorldEdit/Permissions/Bukkit\r\n# - Now with multiworld support (see example)\r\n\r\n";
    private Server server;
    private PermissionsResolver permissionResolver;
    private PermissionsResolverServerListener listener;
    private Configuration config;
    private String name;
    private Logger logger;
    protected Class<? extends PermissionsResolver>[] availableResolvers = new Class[]{PluginPermissionsResolver.class, PermissionsExResolver.class, NijiPermissionsResolver.class, DinnerPermsResolver.class, FlatFilePermissionsResolver.class};

    @Deprecated
    public PermissionsResolverManager(Configuration config, Server server, String name, Logger logger) {
        this.server = server;
        this.name = name;
        this.logger = logger;
        this.loadConfig(new File("wepif.yml"));
        this.findResolver();
    }

    public PermissionsResolverManager(Plugin plugin, String name, Logger logger) {
        this.server = plugin.getServer();
        this.name = name;
        this.logger = logger;
        this.listener = new PermissionsResolverServerListener(this, plugin);
        this.loadConfig(new File("wepif.yml"));
        this.findResolver();
    }

    public void findResolver() {
        for (Class<? extends PermissionsResolver> resolverClass : this.availableResolvers) {
            try {
                Method factoryMethod = resolverClass.getMethod("factory", Server.class, Configuration.class);
                this.permissionResolver = (PermissionsResolver)factoryMethod.invoke(null, this.server, this.config);
                if (this.permissionResolver == null) continue;
                this.logger.info(this.name + ": " + this.permissionResolver.getDetectionMessage());
                return;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        this.permissionResolver = new ConfigurationPermissionsResolver(this.config);
        this.logger.info(this.name + ": No known permissions plugin detected. Using configuration file for permissions.");
    }

    public void setPluginPermissionsResolver(Plugin plugin) {
        if (!(plugin instanceof PermissionsProvider)) {
            return;
        }
        this.permissionResolver = new PluginPermissionsResolver((PermissionsProvider)plugin, plugin);
        this.logger.info(this.name + ": Using plugin '" + plugin.getDescription().getName() + "' for permissions.");
    }

    public void load() {
        this.permissionResolver.load();
    }

    public boolean hasPermission(String name, String permission) {
        return this.permissionResolver.hasPermission(name, permission);
    }

    public boolean hasPermission(String worldName, String name, String permission) {
        return this.permissionResolver.hasPermission(worldName, name, permission);
    }

    public boolean inGroup(String player, String group) {
        return this.permissionResolver.inGroup(player, group);
    }

    public String[] getGroups(String player) {
        return this.permissionResolver.getGroups(player);
    }

    private boolean loadConfig(File file) {
        boolean isUpdated = false;
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = new Configuration(file);
        this.config.load();
        List keys = this.config.getKeys();
        this.config.setHeader(CONFIG_HEADER);
        if (!keys.contains("dinnerperms")) {
            this.config.setProperty("dinnerperms", (Object)this.config.getBoolean("dinner-perms", true));
            isUpdated = true;
        }
        if (!keys.contains("ignore-nijiperms-bridges")) {
            this.config.setProperty("ignore-nijiperms-bridges", (Object)true);
            isUpdated = true;
        }
        if (keys.contains("dinner-perms")) {
            this.config.removeProperty("dinner-perms");
            isUpdated = true;
        }
        if (!keys.contains("permissions")) {
            ConfigurationPermissionsResolver.generateDefaultPerms(this.config);
            isUpdated = true;
        }
        if (isUpdated) {
            this.logger.info("WEPIF: Updated config file");
            this.config.save();
        }
        return isUpdated;
    }

    boolean hasServerListener() {
        return this.listener != null;
    }

    void setServerListener(PermissionsResolverServerListener listener) {
        this.listener = listener;
    }

    public String getDetectionMessage() {
        return "Using WEPIF for permissions";
    }

    public static class MissingPluginException
    extends Exception {
        private static final long serialVersionUID = 7044832912491608706L;
    }
}

