/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.tools;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.tools.DoubleActionBlockTool;

public class BlockReplacer
implements DoubleActionBlockTool {
    private BaseBlock targetBlock;

    public BlockReplacer(BaseBlock targetBlock) {
        this.targetBlock = targetBlock;
    }

    public boolean canUse(LocalPlayer player) {
        return player.hasPermission("worldedit.tool.replacer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean actPrimary(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session, WorldVector clicked) {
        BlockBag bag = session.getBlockBag(player);
        LocalWorld world = clicked.getWorld();
        EditSession editSession = new EditSession(world, -1, bag);
        try {
            try {
                editSession.setBlock((Vector)clicked, this.targetBlock);
            }
            catch (MaxChangedBlocksException e) {
                Object var11_10 = null;
                if (bag != null) {
                    bag.flushChanges();
                }
                session.remember(editSession);
            }
            Object var11_9 = null;
            if (bag != null) {
                bag.flushChanges();
            }
            session.remember(editSession);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (bag != null) {
                bag.flushChanges();
            }
            session.remember(editSession);
            throw throwable;
        }
        return true;
    }

    public boolean actSecondary(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session, WorldVector clicked) {
        LocalWorld world = clicked.getWorld();
        this.targetBlock = new EditSession(world, -1).getBlock(clicked);
        BlockType type = BlockType.fromID(this.targetBlock.getType());
        if (type != null) {
            player.print("Replacer tool switched to: " + type.getName());
        }
        return true;
    }
}

