/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.endergen;

import java.util.List;
import mcjty.lib.api.Infusable;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.rftools.Achievements;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.endergen.EndergenicRenderer;
import mcjty.rftools.blocks.endergen.EndergenicTileEntity;
import mcjty.rftools.blocks.endergen.GuiEndergenic;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IItemStyle;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class EndergenicBlock
extends GenericRFToolsBlock<EndergenicTileEntity, EmptyContainer>
implements Infusable {
    public EndergenicBlock() {
        super(Material.field_151573_f, EndergenicTileEntity.class, EmptyContainer.class, "endergenic", true);
    }

    public boolean needsRedstoneCheck() {
        return true;
    }

    public boolean hasNoRotation() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
        ClientRegistry.bindTileEntitySpecialRenderer(EndergenicTileEntity.class, (TileEntitySpecialRenderer)new EndergenicRenderer());
    }

    public int getGuiID() {
        return RFTools.GUI_ENDERGENIC;
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GenericGuiContainer> getGuiClass() {
        return GuiEndergenic.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "Generate power out of ender pearls. You need at");
            list.add(TextFormatting.WHITE + "least two generators for this to work and the setup");
            list.add(TextFormatting.WHITE + "is relatively complicated. Timing is crucial.");
            list.add(TextFormatting.YELLOW + "Infusing bonus: increased power generation and");
            list.add(TextFormatting.YELLOW + "reduced powerloss for holding pearls.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        if (mode == ProbeMode.EXTENDED) {
            TileEntity te = world.func_175625_s(data.getPos());
            if (te instanceof EndergenicTileEntity) {
                EndergenicTileEntity tileEntity = (EndergenicTileEntity)te;
                IItemStyle style = probeInfo.defaultItemStyle().width(16).height(13);
                ILayoutStyle layoutStyle = probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
                probeInfo.text(TextFormatting.BLUE + "Stats over the last 5 seconds:");
                probeInfo.horizontal(layoutStyle).item(new ItemStack(Items.field_151137_ax), style).text("Charged " + tileEntity.getLastChargeCounter() + " time(s)");
                probeInfo.horizontal(layoutStyle).item(new ItemStack(Items.field_151079_bi), style).text("Fired " + tileEntity.getLastPearlsLaunched()).text(" / Lost " + tileEntity.getLastPearlsLost());
                if (tileEntity.getLastPearlsLost() > 0) {
                    probeInfo.text(TextFormatting.RED + tileEntity.getLastPearlsLostReason());
                }
                if (tileEntity.getLastPearlArrivedAt() > -2) {
                    probeInfo.text("Last pearl arrived at " + tileEntity.getLastPearlArrivedAt());
                }
                probeInfo.horizontal().text(TextFormatting.GREEN + "RF Gain " + tileEntity.getLastRfGained()).text(" / ").text(TextFormatting.RED + "Lost " + tileEntity.getLastRfLost()).text(" (RF/t " + tileEntity.getLastRfPerTick() + ")");
            }
        } else {
            probeInfo.text("(sneak to get statistics)");
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (placer instanceof EntityPlayer) {
            Achievements.trigger((EntityPlayer)placer, Achievements.hardPower);
        }
    }

    protected boolean wrenchUse(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        if (world.field_72995_K) {
            EndergenicTileEntity endergenicTileEntity = (EndergenicTileEntity)world.func_175625_s(pos);
            SoundEvent pling = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("block.note.pling"));
            world.func_184133_a(player, pos, pling, SoundCategory.BLOCKS, 1.0f, 1.0f);
            endergenicTileEntity.useWrench(player);
        }
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.func_176221_a(state, worldIn, pos);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

