/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.itemfilter;

import java.util.Map;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.tools.ItemStackTools;
import mcjty.rftools.blocks.itemfilter.ItemFilterContainer;
import mcjty.rftools.blocks.itemfilter.ItemFilterInvWrapper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemFilterTileEntity
extends GenericTileEntity
implements DefaultSidedInventory {
    public static final String CMD_SETMODE = "setMode";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, ItemFilterContainer.factory, 18);
    private int[] inputMode = new int[6];
    private int[] outputMode = new int[6];
    IItemHandler invHandlerN = new ItemFilterInvWrapper((ISidedInventory)this, EnumFacing.NORTH);
    IItemHandler invHandlerS = new ItemFilterInvWrapper((ISidedInventory)this, EnumFacing.SOUTH);
    IItemHandler invHandlerW = new ItemFilterInvWrapper((ISidedInventory)this, EnumFacing.WEST);
    IItemHandler invHandlerE = new ItemFilterInvWrapper((ISidedInventory)this, EnumFacing.EAST);
    IItemHandler invHandlerD = new ItemFilterInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler invHandlerU = new ItemFilterInvWrapper((ISidedInventory)this, EnumFacing.UP);

    public int[] getInputMode() {
        return this.inputMode;
    }

    public int[] getOutputMode() {
        return this.outputMode;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.inputMode = tagCompound.func_74759_k("inputs");
        this.outputMode = tagCompound.func_74759_k("outputs");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74783_a("inputs", this.inputMode);
        tagCompound.func_74783_a("outputs", this.outputMode);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETMODE.equals(command)) {
            Integer side = args.get("side").getInteger();
            Integer slot = args.get("slot").getInteger();
            Boolean input = args.get("input").getBoolean();
            Boolean output = args.get("output").getBoolean();
            int n = side;
            this.inputMode[n] = this.inputMode[n] & ~(1 << slot);
            if (input.booleanValue()) {
                int n2 = side;
                this.inputMode[n2] = this.inputMode[n2] | 1 << slot;
            }
            int n3 = side;
            this.outputMode[n3] = this.outputMode[n3] & ~(1 << slot);
            if (output.booleanValue()) {
                int n4 = side;
                this.outputMode[n4] = this.outputMode[n4] | 1 << slot;
            }
            this.markDirtyClient();
            return true;
        }
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isUsable(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index < 9) {
            return false;
        }
        ItemStack ghostStack = this.inventoryHelper.getStackInSlot(index - 9);
        return ItemStackTools.isEmpty((ItemStack)ghostStack) || ghostStack.func_77969_a(stack);
    }

    public int[] func_180463_a(EnumFacing side) {
        int v = 9;
        return new int[]{v, v + 1, v + 2, v + 3, v + 4, v + 5, v + 6, v + 7, v + 8};
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing side) {
        if (index < 9) {
            return false;
        }
        if (!this.isInputMode(side, index - 9)) {
            return false;
        }
        int ghostIndex = index - 9;
        ItemStack ghostStack = this.inventoryHelper.getStackInSlot(ghostIndex);
        if (ItemStackTools.isEmpty((ItemStack)ghostStack)) {
            int im = this.inputMode[side.ordinal()];
            for (int i = 0; i < 9; ++i) {
                ItemStack g = this.inventoryHelper.getStackInSlot(i);
                if (!ItemStackTools.isValid((ItemStack)g) || (im & 1 << i) == 0 || !g.func_77969_a(stack)) continue;
                return false;
            }
            return true;
        }
        return ghostStack.func_77969_a(stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        if (index < 9) {
            return false;
        }
        return this.isOutputMode(direction, index - 9);
    }

    private boolean isInputMode(EnumFacing side, int slot) {
        return (this.inputMode[side.ordinal()] & 1 << slot) != 0;
    }

    private boolean isOutputMode(EnumFacing side, int slot) {
        return (this.outputMode[side.ordinal()] & 1 << slot) != 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            switch (facing) {
                case DOWN: {
                    return (T)this.invHandlerD;
                }
                case UP: {
                    return (T)this.invHandlerU;
                }
                case NORTH: {
                    return (T)this.invHandlerN;
                }
                case SOUTH: {
                    return (T)this.invHandlerS;
                }
                case WEST: {
                    return (T)this.invHandlerW;
                }
                case EAST: {
                    return (T)this.invHandlerE;
                }
            }
        }
        return (T)super.getCapability(capability, facing);
    }
}

