/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient;

import mcjty.lib.varia.BlockPosTools;
import mcjty.rftools.api.screens.FormatStyle;
import mcjty.rftools.api.screens.IClientScreenModule;
import mcjty.rftools.api.screens.IModuleGuiBuilder;
import mcjty.rftools.api.screens.IModuleRenderHelper;
import mcjty.rftools.api.screens.ModuleRenderInfo;
import mcjty.rftools.api.screens.data.IModuleDataContents;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EnergyBarClientScreenModule
implements IClientScreenModule<IModuleDataContents> {
    private String line = "";
    private int color = 0xFFFFFF;
    private int rfcolor = 0xFFFFFF;
    private int rfcolorNeg = 0xFFFFFF;
    protected int dim = 0;
    private boolean hidebar = false;
    private boolean hidetext = false;
    private boolean showdiff = false;
    private boolean showpct = false;
    private FormatStyle format = FormatStyle.MODE_FULL;
    protected BlockPos coordinate = BlockPosTools.INVALID;

    @Override
    public IClientScreenModule.TransformMode getTransformMode() {
        return IClientScreenModule.TransformMode.TEXT;
    }

    @Override
    public int getHeight() {
        return 10;
    }

    @Override
    public void render(IModuleRenderHelper renderHelper, FontRenderer fontRenderer, int currenty, IModuleDataContents screenData, ModuleRenderInfo renderInfo) {
        int xoffset;
        GlStateManager.func_179140_f();
        if (!this.line.isEmpty()) {
            fontRenderer.func_78276_b(this.line, 7, currenty, this.color);
            xoffset = 47;
        } else {
            xoffset = 7;
        }
        if (!BlockPosTools.INVALID.equals((Object)this.coordinate)) {
            renderHelper.renderLevel(fontRenderer, xoffset, currenty, screenData, "RF", this.hidebar, this.hidetext, this.showpct, this.showdiff, this.rfcolor, this.rfcolorNeg, -65536, -13421824, this.format);
        } else {
            fontRenderer.func_78276_b("<invalid>", xoffset, currenty, 0xFF0000);
        }
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    @Override
    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Label:").text("text", "Label text").color("color", "Color for the label").nl().label("RF+:").color("rfcolor", "Color for the RF text").label("RF-:").color("rfcolor_neg", "Color for the negative", "RF/tick ratio").nl().toggleNegative("hidebar", "Bar", "Toggle visibility of the", "energy bar").mode("RF").format("format").nl().label("Block:").block("monitor").nl();
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.func_74779_i("text");
            this.color = tagCompound.func_74764_b("color") ? tagCompound.func_74762_e("color") : 0xFFFFFF;
            this.rfcolor = tagCompound.func_74764_b("rfcolor") ? tagCompound.func_74762_e("rfcolor") : 0xFFFFFF;
            this.rfcolorNeg = tagCompound.func_74764_b("rfcolor_neg") ? tagCompound.func_74762_e("rfcolor_neg") : 0xFFFFFF;
            this.hidebar = tagCompound.func_74767_n("hidebar");
            this.hidetext = tagCompound.func_74767_n("hidetext");
            this.showdiff = tagCompound.func_74767_n("showdiff");
            this.showpct = tagCompound.func_74767_n("showpct");
            this.format = FormatStyle.values()[tagCompound.func_74762_e("format")];
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
        }
    }

    protected void setupCoordinateFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        if (tagCompound.func_74764_b("monitorx")) {
            this.dim = tagCompound.func_74764_b("monitordim") ? tagCompound.func_74762_e("monitordim") : tagCompound.func_74762_e("dim");
            if (dim == this.dim) {
                BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                if (dx <= 64 && dy <= 64 && dz <= 64) {
                    this.coordinate = c;
                }
            }
        }
    }

    @Override
    public boolean needsServerData() {
        return true;
    }
}

