/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.tools.PacketBufferTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.screens.ScreenTileEntity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketModuleUpdate
implements IMessage {
    private BlockPos pos;
    private int slotIndex;
    private NBTTagCompound tagCompound;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.slotIndex = buf.readInt();
        PacketBuffer buffer = new PacketBuffer(buf);
        try {
            this.tagCompound = PacketBufferTools.readCompoundTag((PacketBuffer)buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        buf.writeInt(this.slotIndex);
        PacketBuffer buffer = new PacketBuffer(buf);
        PacketBufferTools.writeCompoundTag((PacketBuffer)buffer, (NBTTagCompound)this.tagCompound);
    }

    public PacketModuleUpdate() {
    }

    public PacketModuleUpdate(BlockPos pos, int slotIndex, NBTTagCompound tagCompound) {
        this.pos = pos;
        this.slotIndex = slotIndex;
        this.tagCompound = tagCompound;
    }

    public static class Handler
    implements IMessageHandler<PacketModuleUpdate, IMessage> {
        public IMessage onMessage(PacketModuleUpdate message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketModuleUpdate message, MessageContext ctx) {
            TileEntity te = ctx.getServerHandler().field_147369_b.func_130014_f_().func_175625_s(message.pos);
            if (!(te instanceof ScreenTileEntity)) {
                Logging.logError((String)"PacketModuleUpdate: TileEntity is not a SimpleScreenTileEntity!");
                return;
            }
            ((ScreenTileEntity)te).updateModuleData(message.slotIndex, message.tagCompound);
        }
    }
}

