/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.tools.WorldTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class SecurityChannels
extends WorldSavedData {
    public static final String SECURITY_CHANNELS_NAME = "RFToolsSecurityChannels";
    private static SecurityChannels instance = null;
    private int lastId = 0;
    private final Map<Integer, SecurityChannel> channels = new HashMap<Integer, SecurityChannel>();

    public SecurityChannels(String identifier) {
        super(identifier);
    }

    public void save(World world) {
        WorldTools.saveData((World)world, (String)SECURITY_CHANNELS_NAME, (WorldSavedData)this);
        this.func_76185_a();
    }

    public static void clearInstance() {
        if (instance != null) {
            SecurityChannels.instance.channels.clear();
            instance = null;
        }
    }

    public static SecurityChannels getChannels() {
        return instance;
    }

    public static SecurityChannels getChannels(World world) {
        if (world.field_72995_K) {
            return null;
        }
        if (instance != null) {
            return instance;
        }
        instance = (SecurityChannels)WorldTools.loadData((World)world, SecurityChannels.class, (String)SECURITY_CHANNELS_NAME);
        if (instance == null) {
            instance = new SecurityChannels(SECURITY_CHANNELS_NAME);
        }
        return instance;
    }

    public SecurityChannel getOrCreateChannel(int id) {
        SecurityChannel channel = this.channels.get(id);
        if (channel == null) {
            channel = new SecurityChannel();
            this.channels.put(id, channel);
        }
        return channel;
    }

    public SecurityChannel getChannel(int id) {
        return this.channels.get(id);
    }

    public void deleteChannel(int id) {
        this.channels.remove(id);
    }

    public int newChannel() {
        ++this.lastId;
        return this.lastId;
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        this.channels.clear();
        NBTTagList lst = tagCompound.func_150295_c("channels", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tc = lst.func_150305_b(i);
            int channel = tc.func_74762_e("channel");
            SecurityChannel value = new SecurityChannel();
            value.setName(tc.func_74779_i("name"));
            value.setWhitelist(tc.func_74767_n("whitelist"));
            value.clearPlayers();
            NBTTagList playerList = tc.func_150295_c("players", 8);
            if (playerList != null) {
                for (int j = 0; j < playerList.func_74745_c(); ++j) {
                    String player = playerList.func_150307_f(j);
                    value.addPlayer(player);
                }
            }
            this.channels.put(channel, value);
        }
        this.lastId = tagCompound.func_74762_e("lastId");
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tagCompound) {
        NBTTagList lst = new NBTTagList();
        for (Map.Entry<Integer, SecurityChannel> entry : this.channels.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74768_a("channel", entry.getKey().intValue());
            SecurityChannel channel = entry.getValue();
            tc.func_74778_a("name", channel.getName());
            tc.func_74757_a("whitelist", channel.isWhitelist());
            NBTTagList playerTagList = new NBTTagList();
            for (String player : channel.getPlayers()) {
                playerTagList.func_74742_a((NBTBase)new NBTTagString(player));
            }
            tc.func_74782_a("players", (NBTBase)playerTagList);
            lst.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("channels", (NBTBase)lst);
        tagCompound.func_74768_a("lastId", this.lastId);
        return tagCompound;
    }

    public static class SecurityChannel {
        private String name = "";
        private boolean whitelist = true;
        private final List<String> players = new ArrayList<String>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getPlayers() {
            return this.players;
        }

        public void addPlayer(String player) {
            this.players.add(player);
        }

        public void delPlayer(String player) {
            this.players.remove(player);
        }

        public void clearPlayers() {
            this.players.clear();
        }

        public boolean isWhitelist() {
            return this.whitelist;
        }

        public void setWhitelist(boolean whitelist) {
            this.whitelist = whitelist;
        }
    }
}

