/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.tools.ItemStackTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.storage.ModularStorageContainer;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSyncSlotsToClient
implements IMessage {
    private BlockPos pos;
    private int maxSize;
    private int numStacks;
    private String viewMode;
    private String sortMode;
    private boolean groupMode;
    private String filter;
    private List<Pair<Integer, ItemStack>> items;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.viewMode = NetworkTools.readString((ByteBuf)buf);
        this.sortMode = NetworkTools.readString((ByteBuf)buf);
        this.groupMode = buf.readBoolean();
        this.filter = NetworkTools.readString((ByteBuf)buf);
        this.maxSize = buf.readInt();
        this.numStacks = buf.readInt();
        int s = buf.readInt();
        this.items = new ArrayList<Pair<Integer, ItemStack>>(s);
        for (int i = 0; i < s; ++i) {
            int slotIdx = buf.readInt();
            if (slotIdx < 0) {
                this.items.add((Pair<Integer, ItemStack>)Pair.of((Object)(-slotIdx - 1), null));
                continue;
            }
            ItemStack stack = NetworkTools.readItemStack((ByteBuf)buf);
            this.items.add((Pair<Integer, ItemStack>)Pair.of((Object)slotIdx, (Object)stack));
        }
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        NetworkTools.writeString((ByteBuf)buf, (String)this.viewMode);
        NetworkTools.writeString((ByteBuf)buf, (String)this.sortMode);
        buf.writeBoolean(this.groupMode);
        NetworkTools.writeString((ByteBuf)buf, (String)this.filter);
        buf.writeInt(this.maxSize);
        buf.writeInt(this.numStacks);
        buf.writeInt(this.items.size());
        for (Pair<Integer, ItemStack> pair : this.items) {
            if (ItemStackTools.isEmpty((ItemStack)((ItemStack)pair.getRight()))) {
                buf.writeInt(-((Integer)pair.getLeft()).intValue() - 1);
                continue;
            }
            buf.writeInt(((Integer)pair.getLeft()).intValue());
            NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStack)pair.getRight()));
        }
    }

    public PacketSyncSlotsToClient() {
    }

    public PacketSyncSlotsToClient(BlockPos pos, String sortMode, String viewMode, boolean groupMode, String filter, int maxSize, int numStacks, List<Pair<Integer, ItemStack>> items) {
        this.sortMode = sortMode;
        this.viewMode = viewMode;
        this.groupMode = groupMode;
        this.filter = filter;
        this.pos = pos;
        this.maxSize = maxSize;
        this.numStacks = numStacks;
        this.items = items;
    }

    public static class Handler
    implements IMessageHandler<PacketSyncSlotsToClient, IMessage> {
        public IMessage onMessage(PacketSyncSlotsToClient message, MessageContext ctx) {
            RFTools.proxy.addScheduledTaskClient(() -> this.handle(message, ctx));
            return null;
        }

        public void handle(PacketSyncSlotsToClient message, MessageContext ctx) {
            TileEntity te = RFTools.proxy.getClientWorld().func_175625_s(message.pos);
            if (te instanceof ModularStorageTileEntity) {
                ModularStorageTileEntity storage = (ModularStorageTileEntity)te;
                storage.syncInventoryFromServer(message.maxSize, message.numStacks, message.sortMode, message.viewMode, message.groupMode, message.filter);
                Container container = RFTools.proxy.getClientPlayer().field_71070_bA;
                if (container instanceof ModularStorageContainer) {
                    for (Pair pair : message.items) {
                        container.func_75141_a(((Integer)pair.getLeft()).intValue(), (ItemStack)pair.getRight());
                    }
                }
            }
        }
    }
}

