/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mcjty.lib.network.Argument;
import mcjty.lib.network.CommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.PacketRequestListFromServer;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.teleporter.PacketPlayersReady;
import mcjty.rftools.blocks.teleporter.PlayerName;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGetPlayers
extends PacketRequestListFromServer<PlayerName, PacketGetPlayers, PacketPlayersReady> {
    private String clientcmd;

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.clientcmd = NetworkTools.readString((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        NetworkTools.writeString((ByteBuf)buf, (String)this.clientcmd);
    }

    public PacketGetPlayers() {
    }

    public PacketGetPlayers(BlockPos pos, String cmd, String clientcmd) {
        super("rftools", pos, cmd, new Argument[0]);
        this.clientcmd = clientcmd;
    }

    public static class Handler
    implements IMessageHandler<PacketGetPlayers, IMessage> {
        public IMessage onMessage(PacketGetPlayers message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketGetPlayers message, MessageContext ctx) {
            TileEntity te = ctx.getServerHandler().field_147369_b.func_130014_f_().func_175625_s(message.pos);
            if (!(te instanceof CommandHandler)) {
                Logging.log((String)"createStartScanPacket: TileEntity is not a CommandHandler!");
                return;
            }
            CommandHandler commandHandler = (CommandHandler)te;
            List list = commandHandler.executeWithResultList(message.command, message.args);
            if (list == null) {
                Logging.log((String)("Command " + message.command + " was not handled!"));
                return;
            }
            RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketPlayersReady(message.pos, message.clientcmd, list), ctx.getServerHandler().field_147369_b);
        }
    }
}

