/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.craftinggrid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.lib.tools.InventoryTools;
import mcjty.lib.tools.ItemStackTools;
import mcjty.rftools.blocks.crafter.CraftingRecipe;
import mcjty.rftools.craftinggrid.IItemKey;
import mcjty.rftools.craftinggrid.IItemSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class StorageCraftingTools {
    static int[] tryRecipe(EntityPlayerMP player, CraftingRecipe craftingRecipe, int n, IItemSource itemSource, boolean strictDamage) {
        InventoryCrafting workInventory = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        ArrayList<Pair<IItemKey, ItemStack>> undo = new ArrayList<Pair<IItemKey, ItemStack>>();
        InventoryCrafting inventory = craftingRecipe.getInventory();
        int[] missingCount = new int[10];
        for (int i = 0; i < 10; ++i) {
            missingCount[i] = 0;
        }
        for (int counter = 0; counter < n; ++counter) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (ItemStackTools.isValid((ItemStack)stack)) {
                    int count = ItemStackTools.getStackSize((ItemStack)stack);
                    count = StorageCraftingTools.findMatchingItems(workInventory, undo, i, stack, count, itemSource, strictDamage);
                    int n2 = i;
                    missingCount[n2] = missingCount[n2] + count;
                    continue;
                }
                workInventory.func_70299_a(i, ItemStackTools.getEmptyStack());
            }
        }
        IRecipe recipe = craftingRecipe.getCachedRecipe(player.func_130014_f_());
        missingCount[9] = !recipe.func_77569_a(workInventory, player.func_130014_f_()) ? 1 : 0;
        StorageCraftingTools.undo(player, itemSource, undo);
        return missingCount;
    }

    private static List<ItemStack> testAndConsumeCraftingItems(EntityPlayerMP player, CraftingRecipe craftingRecipe, IItemSource itemSource, boolean strictDamage) {
        ItemStack stack;
        InventoryCrafting workInventory = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        ArrayList<Pair<IItemKey, ItemStack>> undo = new ArrayList<Pair<IItemKey, ItemStack>>();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        InventoryCrafting inventory = craftingRecipe.getInventory();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            stack = inventory.func_70301_a(i);
            if (ItemStackTools.isValid((ItemStack)stack)) {
                int count = ItemStackTools.getStackSize((ItemStack)stack);
                if ((count = StorageCraftingTools.findMatchingItems(workInventory, undo, i, stack, count, itemSource, strictDamage)) <= 0) continue;
                StorageCraftingTools.undo(player, itemSource, undo);
                return Collections.emptyList();
            }
            workInventory.func_70299_a(i, ItemStackTools.getEmptyStack());
        }
        IRecipe recipe = craftingRecipe.getCachedRecipe(player.func_130014_f_());
        if (!recipe.func_77569_a(workInventory, player.func_130014_f_())) {
            result.clear();
            StorageCraftingTools.undo(player, itemSource, undo);
            return result;
        }
        stack = recipe.func_77572_b(workInventory);
        if (ItemStackTools.isValid((ItemStack)stack)) {
            result.add(stack);
            List remaining = InventoryTools.getRemainingItems((IRecipe)recipe, (InventoryCrafting)workInventory);
            if (remaining != null) {
                for (ItemStack s : remaining) {
                    if (!ItemStackTools.isValid((ItemStack)s)) continue;
                    result.add(s);
                }
            }
        } else {
            result.clear();
            StorageCraftingTools.undo(player, itemSource, undo);
        }
        return result;
    }

    private static boolean match(ItemStack target, ItemStack input, boolean strictDamage) {
        if (strictDamage) {
            return OreDictionary.itemMatches((ItemStack)target, (ItemStack)input, (boolean)false);
        }
        if (ItemStackTools.isEmpty((ItemStack)input) && ItemStackTools.isValid((ItemStack)target) || ItemStackTools.isValid((ItemStack)input) && ItemStackTools.isEmpty((ItemStack)target)) {
            return false;
        }
        return target.func_77973_b() == input.func_77973_b();
    }

    private static int findMatchingItems(InventoryCrafting workInventory, List<Pair<IItemKey, ItemStack>> undo, int i, ItemStack stack, int count, IItemSource itemSource, boolean strictDamage) {
        for (Pair<IItemKey, ItemStack> pair : itemSource.getItems()) {
            ItemStack input = (ItemStack)pair.getValue();
            if (ItemStackTools.isValid((ItemStack)input) && StorageCraftingTools.match(stack, input, strictDamage)) {
                workInventory.func_70299_a(i, input.func_77946_l());
                int ss = count;
                if (ItemStackTools.getStackSize((ItemStack)input) - ss < 0) {
                    ss = ItemStackTools.getStackSize((ItemStack)input);
                }
                count -= ss;
                IItemKey key = (IItemKey)pair.getKey();
                ItemStack actuallyExtracted = itemSource.decrStackSize(key, ss);
                undo.add((Pair<IItemKey, ItemStack>)Pair.of((Object)key, (Object)actuallyExtracted));
            }
            if (count != 0) continue;
            break;
        }
        return count;
    }

    private static void undo(EntityPlayerMP player, IItemSource itemSource, List<Pair<IItemKey, ItemStack>> undo) {
        for (Pair<IItemKey, ItemStack> pair : undo) {
            int amountLeft;
            ItemStack stack = (ItemStack)pair.getValue();
            if (itemSource.insertStack((IItemKey)pair.getKey(), stack) || (amountLeft = itemSource.insertStackAnySlot((IItemKey)pair.getKey(), stack)) <= 0) continue;
            ItemStack copy = stack.func_77946_l();
            ItemStackTools.setStackSize((ItemStack)copy, (int)amountLeft);
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)copy);
        }
        player.field_71070_bA.func_75142_b();
    }

    public static void craftItems(EntityPlayerMP player, int n, CraftingRecipe craftingRecipe, IItemSource itemSource) {
        IRecipe recipe = craftingRecipe.getCachedRecipe(player.func_130014_f_());
        if (recipe == null) {
            return;
        }
        if (ItemStackTools.isValid((ItemStack)craftingRecipe.getResult()) && ItemStackTools.getStackSize((ItemStack)craftingRecipe.getResult()) > 0) {
            if (n == -1) {
                n = craftingRecipe.getResult().func_77976_d();
            }
            int remainder = n % ItemStackTools.getStackSize((ItemStack)craftingRecipe.getResult());
            n /= ItemStackTools.getStackSize((ItemStack)craftingRecipe.getResult());
            if (remainder != 0) {
                ++n;
            }
            if (n * ItemStackTools.getStackSize((ItemStack)craftingRecipe.getResult()) > craftingRecipe.getResult().func_77976_d()) {
                --n;
            }
            for (int i = 0; i < n; ++i) {
                List<ItemStack> result = StorageCraftingTools.testAndConsumeCraftingItems(player, craftingRecipe, itemSource, true);
                if (result.isEmpty() && (result = StorageCraftingTools.testAndConsumeCraftingItems(player, craftingRecipe, itemSource, false)).isEmpty()) {
                    return;
                }
                for (ItemStack stack : result) {
                    if (player.field_71071_by.func_70441_a(stack)) continue;
                    player.func_70099_a(stack, 1.05f);
                }
            }
        }
    }

    public static int[] testCraftItems(EntityPlayerMP player, int n, CraftingRecipe craftingRecipe, IItemSource itemSource) {
        IRecipe recipe = craftingRecipe.getCachedRecipe(player.func_130014_f_());
        if (recipe == null) {
            return null;
        }
        if (ItemStackTools.isValid((ItemStack)craftingRecipe.getResult()) && ItemStackTools.getStackSize((ItemStack)craftingRecipe.getResult()) > 0) {
            if (n == -1) {
                n = craftingRecipe.getResult().func_77976_d();
            }
            int remainder = n % ItemStackTools.getStackSize((ItemStack)craftingRecipe.getResult());
            n /= ItemStackTools.getStackSize((ItemStack)craftingRecipe.getResult());
            if (remainder != 0) {
                ++n;
            }
            if (n * ItemStackTools.getStackSize((ItemStack)craftingRecipe.getResult()) > craftingRecipe.getResult().func_77976_d()) {
                --n;
            }
            int[] result = StorageCraftingTools.tryRecipe(player, craftingRecipe, n, itemSource, true);
            for (int i = 0; i < 10; ++i) {
                if (result[i] <= 0) continue;
                int[] result2 = StorageCraftingTools.tryRecipe(player, craftingRecipe, n, itemSource, false);
                if (result2[9] == 0) {
                    return result2;
                }
                return result;
            }
            return result;
        }
        return null;
    }
}

