/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.storage;

import java.util.HashSet;
import java.util.Set;
import mcjty.lib.tools.ItemStackTools;
import mcjty.rftools.blocks.storage.sorters.ModItemSorter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.OreDictionary;

public class StorageFilterCache {
    private boolean matchDamage = true;
    private boolean oredictMode = false;
    private boolean blacklistMode = true;
    private boolean nbtMode = false;
    private boolean modMode = false;
    private ItemStack[] stacks;
    private Set<Integer> oredictMatches = new HashSet<Integer>();

    StorageFilterCache(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            ItemStack s;
            NBTTagCompound nbtTagCompound;
            int i;
            this.matchDamage = tagCompound.func_74767_n("damageMode");
            this.oredictMode = tagCompound.func_74767_n("oredictMode");
            this.nbtMode = tagCompound.func_74767_n("nbtMode");
            this.modMode = tagCompound.func_74767_n("modMode");
            this.blacklistMode = "Black".equals(tagCompound.func_74779_i("blacklistMode"));
            NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
            int cnt = 0;
            for (i = 0; i < bufferTagList.func_74745_c(); ++i) {
                nbtTagCompound = bufferTagList.func_150305_b(i);
                s = ItemStackTools.loadFromNBT((NBTTagCompound)nbtTagCompound);
                if (!ItemStackTools.isValid((ItemStack)s)) continue;
                ++cnt;
            }
            this.stacks = new ItemStack[cnt];
            cnt = 0;
            for (i = 0; i < bufferTagList.func_74745_c(); ++i) {
                nbtTagCompound = bufferTagList.func_150305_b(i);
                s = ItemStackTools.loadFromNBT((NBTTagCompound)nbtTagCompound);
                if (!ItemStackTools.isValid((ItemStack)s)) continue;
                this.stacks[cnt++] = s;
                if (!this.oredictMode) continue;
                for (int id : OreDictionary.getOreIDs((ItemStack)s)) {
                    this.oredictMatches.add(id);
                }
            }
        } else {
            this.stacks = new ItemStack[0];
        }
    }

    public boolean match(ItemStack stack) {
        if (ItemStackTools.isValid((ItemStack)stack)) {
            boolean match = false;
            String modName = "";
            if (this.modMode) {
                modName = ModItemSorter.getMod(stack);
            }
            if (this.oredictMode) {
                int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
                if (oreIDs.length == 0) {
                    match = this.itemMatches(stack, modName);
                } else {
                    for (int id : oreIDs) {
                        if (!this.oredictMatches.contains(id)) continue;
                        match = true;
                        break;
                    }
                }
            } else {
                match = this.itemMatches(stack, modName);
            }
            return match != this.blacklistMode;
        }
        return false;
    }

    private boolean itemMatches(ItemStack stack, String modName) {
        if (this.stacks != null) {
            for (ItemStack itemStack : this.stacks) {
                if (this.matchDamage && itemStack.func_77952_i() != stack.func_77952_i() || this.nbtMode && !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)stack) || !(this.modMode ? modName.equals(ModItemSorter.getMod(itemStack)) : itemStack.func_77973_b().equals(stack.func_77973_b()))) continue;
                return true;
            }
        }
        return false;
    }
}

