/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.storage;

import mcjty.lib.compat.CompatInventory;
import mcjty.lib.tools.ItemStackTools;
import mcjty.rftools.items.storage.StorageFilterContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;

public class StorageFilterInventory
implements CompatInventory {
    private ItemStack[] stacks = new ItemStack[30];
    private final EntityPlayer entityPlayer;

    public StorageFilterInventory(EntityPlayer player) {
        this.entityPlayer = player;
        NBTTagCompound tagCompound = this.entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            this.entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77982_d(tagCompound);
        }
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.stacks[i] = ItemStackTools.loadFromNBT((NBTTagCompound)nbtTagCompound);
        }
    }

    public int func_70302_i_() {
        return 30;
    }

    public ItemStack func_70301_a(int index) {
        return this.stacks[index];
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (index >= this.stacks.length) {
            return ItemStackTools.getEmptyStack();
        }
        if (ItemStackTools.isValid((ItemStack)this.stacks[index])) {
            if (ItemStackTools.getStackSize((ItemStack)this.stacks[index]) <= amount) {
                ItemStack old = this.stacks[index];
                this.stacks[index] = ItemStackTools.getEmptyStack();
                this.func_70296_d();
                return old;
            }
            ItemStack its = this.stacks[index].func_77979_a(amount);
            if (ItemStackTools.isEmpty((ItemStack)this.stacks[index])) {
                this.stacks[index] = ItemStackTools.getEmptyStack();
            }
            this.func_70296_d();
            return its;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index >= this.stacks.length) {
            return;
        }
        if (StorageFilterContainer.factory.isGhostSlot(index)) {
            if (ItemStackTools.isValid((ItemStack)stack)) {
                this.stacks[index] = stack.func_77946_l();
                if (index < 9) {
                    ItemStackTools.setStackSize((ItemStack)this.stacks[index], (int)1);
                }
            } else {
                this.stacks[index] = null;
            }
        } else {
            this.stacks[index] = stack;
            if (ItemStackTools.isValid((ItemStack)stack) && ItemStackTools.getStackSize((ItemStack)stack) > this.func_70297_j_()) {
                ItemStackTools.setStackSize((ItemStack)stack, (int)this.func_70297_j_());
            }
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        NBTTagCompound tagCompound = this.entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77978_p();
        StorageFilterInventory.convertItemsToNBT(tagCompound, this.stacks);
    }

    public static void convertItemsToNBT(NBTTagCompound tagCompound, ItemStack[] stacks) {
        NBTTagList bufferTagList = new NBTTagList();
        for (ItemStack stack : stacks) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (ItemStackTools.isValid((ItemStack)stack)) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public boolean isUsable(EntityPlayer player) {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        this.func_70299_a(index, ItemStackTools.getEmptyStack());
        return stack;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return "storage filter";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }
}

