/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.teleportprobe;

import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.items.teleportprobe.ChargedPorterItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class AdvancedChargedPorterItem
extends ChargedPorterItem {
    public static final int MAXTARGETS = 8;

    public AdvancedChargedPorterItem() {
        super("advanced_charged_porter");
        this.capacity = TeleportConfiguration.ADVANCED_CHARGEDPORTER_MAXENERGY;
    }

    @Override
    protected int getSpeedBonus() {
        return TeleportConfiguration.advancedSpeedBonus;
    }

    @Override
    protected void selectOnReceiver(EntityPlayer player, World world, NBTTagCompound tagCompound, int id) {
        int i;
        for (i = 0; i < 8; ++i) {
            if (!tagCompound.func_74764_b("target" + i) || tagCompound.func_74762_e("target" + i) != id) continue;
            Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Receiver " + id + " was already added to the charged porter."));
            return;
        }
        for (i = 0; i < 8; ++i) {
            if (tagCompound.func_74764_b("target" + i)) continue;
            tagCompound.func_74768_a("target" + i, id);
            if (world.field_72995_K) {
                Logging.message((EntityPlayer)player, (String)("Receiver " + id + " is added to the charged porter."));
            }
            if (!tagCompound.func_74764_b("target")) {
                tagCompound.func_74768_a("target", id);
            }
            return;
        }
        if (world.field_72995_K) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Charged porter has no free targets!"));
        }
    }

    @Override
    protected void selectReceiver(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            player.openGui((Object)RFTools.instance, RFTools.GUI_ADVANCEDPORTER, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }

    @Override
    protected void selectOnThinAir(EntityPlayer player, World world, NBTTagCompound tagCompound, ItemStack stack) {
        this.selectReceiver(stack, world, player);
    }
}

